/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.interfaces.RSAKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.CipherSpi;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKeyFactory;
import javax.crypto.ShortBufferException;
import org.bouncycastle.jcajce.KTSKeyWithEncapsulation;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.spec.KTSExtractKeySpec;
import org.bouncycastle.jcajce.spec.KTSGenerateKeySpec;
import org.bouncycastle.jcajce.spec.KTSParameterSpec;
import org.bouncycastle.util.Arrays;

class KtsCipherSpi
extends CipherSpi {
    private final BouncyCastleFipsProvider fipsProvider;
    private final String algorithmName;
    private SecretKeyFactory kemFact;
    private KTSParameterSpec ktsParameterSpec;
    private RSAPublicKey wrapKey;
    private RSAPrivateKey unwrapKey;
    private SecureRandom random;
    private AlgorithmParameters engineParams;

    KtsCipherSpi(BouncyCastleFipsProvider fipsProvider, String algorithmName) throws NoSuchAlgorithmException {
        this.fipsProvider = fipsProvider;
        this.algorithmName = algorithmName;
        this.kemFact = SecretKeyFactory.getInstance("RSA-KAS-KEM", fipsProvider);
    }

    protected void engineSetMode(String mode) throws NoSuchAlgorithmException {
        throw new NoSuchAlgorithmException("Cannot support mode " + mode);
    }

    protected void engineSetPadding(String padding) throws NoSuchPaddingException {
        throw new NoSuchPaddingException("Padding " + padding + " unknown");
    }

    protected int engineGetKeySize(Key key) {
        if (key instanceof RSAKey) {
            RSAKey k = (RSAKey)((Object)key);
            return k.getModulus().bitLength();
        }
        throw new IllegalArgumentException("not an valid key!");
    }

    protected int engineGetBlockSize() {
        return 0;
    }

    protected int engineGetOutputSize(int i) {
        return -1;
    }

    protected byte[] engineGetIV() {
        return null;
    }

    protected AlgorithmParameters engineGetParameters() {
        if (this.engineParams == null) {
            try {
                this.engineParams = AlgorithmParameters.getInstance(this.algorithmName, this.fipsProvider);
                this.engineParams.init(this.ktsParameterSpec);
            }
            catch (Exception e) {
                throw new IllegalStateException(e.toString(), e);
            }
        }
        return this.engineParams;
    }

    protected void engineInit(int opmode, Key key, SecureRandom random) throws InvalidKeyException {
        try {
            this.engineInit(opmode, key, (AlgorithmParameterSpec)null, random);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void engineInit(int opmode, Key key, AlgorithmParameterSpec paramSpec, SecureRandom random) throws InvalidKeyException, InvalidAlgorithmParameterException {
        if (random == null) {
            this.random = this.fipsProvider.getDefaultSecureRandom();
        }
        if (paramSpec == null) {
            this.ktsParameterSpec = new KTSParameterSpec.Builder("AES", 128).build();
        } else {
            if (!(paramSpec instanceof KTSParameterSpec)) {
                throw new InvalidAlgorithmParameterException(this.algorithmName + " can only accept KTSParameterSpec");
            }
            this.ktsParameterSpec = (KTSParameterSpec)paramSpec;
        }
        if (opmode == 3) {
            if (!(key instanceof RSAPublicKey)) throw new InvalidKeyException("Only an RSA public key can be used for wrapping");
            this.wrapKey = (RSAPublicKey)key;
            return;
        } else {
            if (opmode != 4) throw new InvalidParameterException("Cipher only valid for wrapping/unwrapping");
            if (!(key instanceof RSAPrivateKey)) throw new InvalidKeyException("Only an RSA private key can be used for unwrapping");
            this.unwrapKey = (RSAPrivateKey)key;
        }
    }

    protected void engineInit(int opmode, Key key, AlgorithmParameters algorithmParameters, SecureRandom secureRandom) throws InvalidKeyException, InvalidAlgorithmParameterException {
        KTSParameterSpec paramSpec = null;
        if (algorithmParameters != null) {
            try {
                paramSpec = algorithmParameters.getParameterSpec(KTSParameterSpec.class);
            }
            catch (Exception e) {
                throw new InvalidAlgorithmParameterException("can't handle parameter " + algorithmParameters.toString());
            }
        }
        this.engineInit(opmode, key, paramSpec, this.random);
    }

    protected byte[] engineUpdate(byte[] bytes, int i, int i1) {
        throw new IllegalStateException("Not supported in a wrapping mode");
    }

    protected int engineUpdate(byte[] bytes, int i, int i1, byte[] bytes1, int i2) throws ShortBufferException {
        throw new IllegalStateException("Not supported in a wrapping mode");
    }

    protected byte[] engineDoFinal(byte[] bytes, int i, int i1) throws IllegalBlockSizeException, BadPaddingException {
        throw new IllegalStateException("Not supported in a wrapping mode");
    }

    protected int engineDoFinal(byte[] bytes, int i, int i1, byte[] bytes1, int i2) throws ShortBufferException, IllegalBlockSizeException, BadPaddingException {
        throw new IllegalStateException("Not supported in a wrapping mode");
    }

    protected byte[] engineWrap(Key key) throws IllegalBlockSizeException, InvalidKeyException {
        byte[] encoded = key.getEncoded();
        if (encoded == null) {
            throw new InvalidKeyException("Cannot wrap key, null encoding.");
        }
        try {
            KTSGenerateKeySpec genSpec = new KTSGenerateKeySpec.Builder(this.wrapKey, this.ktsParameterSpec.getKeyAlgorithmName(), this.ktsParameterSpec.getKeySize(), this.ktsParameterSpec.getOtherInfo()).withKdfAlgorithm(this.ktsParameterSpec.getKdfAlgorithm()).withSecureRandom(this.random).withParameterSpec(this.ktsParameterSpec.getParameterSpec()).build();
            KTSKeyWithEncapsulation ktsKey = (KTSKeyWithEncapsulation)this.kemFact.generateSecret(genSpec);
            Cipher wrapCipher = Cipher.getInstance(this.ktsParameterSpec.getKeyAlgorithmName(), this.fipsProvider);
            wrapCipher.init(3, (Key)ktsKey, this.random);
            return Arrays.concatenate(ktsKey.getEncapsulation(), wrapCipher.wrap(key));
        }
        catch (InvalidKeyException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            throw new IllegalBlockSizeException("Unable to generate KTS secret: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalBlockSizeException("Unable to generate KTS secret: " + e.getMessage());
        }
    }

    protected Key engineUnwrap(byte[] wrappedKey, String wrappedKeyAlgorithm, int wrappedKeyType) throws InvalidKeyException, NoSuchAlgorithmException {
        try {
            byte[] encapsulation = new byte[(this.unwrapKey.getModulus().bitLength() + 7) / 8];
            System.arraycopy(wrappedKey, 0, encapsulation, 0, encapsulation.length);
            KTSExtractKeySpec extSpec = new KTSExtractKeySpec.Builder(this.unwrapKey, encapsulation, this.ktsParameterSpec.getKeyAlgorithmName(), this.ktsParameterSpec.getKeySize(), this.ktsParameterSpec.getOtherInfo()).withKdfAlgorithm(this.ktsParameterSpec.getKdfAlgorithm()).withParameterSpec(this.ktsParameterSpec.getParameterSpec()).build();
            KTSKeyWithEncapsulation ktsKey = (KTSKeyWithEncapsulation)this.kemFact.generateSecret(extSpec);
            Cipher wrapCipher = Cipher.getInstance(this.ktsParameterSpec.getKeyAlgorithmName(), this.fipsProvider);
            wrapCipher.init(4, (Key)ktsKey, this.random);
            byte[] encodedKey = new byte[wrappedKey.length - encapsulation.length];
            System.arraycopy(wrappedKey, encapsulation.length, encodedKey, 0, encodedKey.length);
            return wrapCipher.unwrap(encodedKey, wrappedKeyAlgorithm, wrappedKeyType);
        }
        catch (InvalidKeyException e) {
            throw e;
        }
        catch (GeneralSecurityException e) {
            if (e instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)e;
            }
            throw new NoSuchAlgorithmException("Unable to generate KTS secret: " + e.getMessage());
        }
        catch (IllegalArgumentException e) {
            throw new NoSuchAlgorithmException("Unable to generate KTS secret: " + e.getMessage());
        }
    }
}

