/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.InvalidAlgorithmParameterException;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.bouncycastle.asn1.cms.GCMParameters;
import org.bouncycastle.crypto.AuthenticationParameters;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.jcajce.provider.GcmSpecUtil;
import org.bouncycastle.jcajce.provider.MacParametersCreator;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AuthParametersCreator<T extends AuthenticationParametersWithIV>
implements ParametersCreator,
MacParametersCreator {
    private final AuthenticationParametersWithIV<AuthenticationParametersWithIV> baseParameters;

    AuthParametersCreator(AuthenticationParametersWithIV baseParameters) {
        this.baseParameters = baseParameters;
    }

    public AuthenticationParameters getBaseParameters() {
        return this.baseParameters;
    }

    public AuthenticationParameters createParameters(boolean forEncryption, AlgorithmParameterSpec spec, SecureRandom random) throws InvalidAlgorithmParameterException {
        if (spec instanceof AEADParameterSpec) {
            AEADParameterSpec ivTagSpec = (AEADParameterSpec)spec;
            return (AuthenticationParameters)((AuthenticationParametersWithIV)this.baseParameters.withIV(ivTagSpec.getNonce())).withMACSize(ivTagSpec.getMacSizeInBits());
        }
        if (spec instanceof IvParameterSpec) {
            return (AuthenticationParameters)this.baseParameters.withIV(((IvParameterSpec)spec).getIV());
        }
        if (GcmSpecUtil.isGcmSpec(spec)) {
            try {
                GCMParameters gcm = GcmSpecUtil.extractGcmParameters(spec);
                return (AuthenticationParameters)((AuthenticationParametersWithIV)this.baseParameters.withIV(gcm.getNonce())).withMACSize(gcm.getIcvLen() * 8);
            }
            catch (Exception e) {
                throw new InvalidAlgorithmParameterException("Cannot process GCMParameterSpec: " + e.getMessage(), e);
            }
        }
        if (spec instanceof RC2ParameterSpec) {
            return (AuthenticationParameters)this.baseParameters.withIV(((RC2ParameterSpec)spec).getIV());
        }
        if (spec != null) {
            throw new InvalidAlgorithmParameterException("Unknown AlgorithmParameterSpec found: " + spec.getClass().getName());
        }
        if (forEncryption && this.baseParameters.getAlgorithm().requiresAlgorithmParameters()) {
            return (AuthenticationParameters)this.baseParameters.withIV(random);
        }
        return this.baseParameters;
    }
}

