/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce;

import java.util.concurrent.atomic.AtomicBoolean;
import javax.crypto.SecretKey;
import org.bouncycastle.jcajce.ZeroizableSecretKey;
import org.bouncycastle.util.Arrays;

public final class AgreedKeyWithMacKey
implements SecretKey {
    private SecretKey secretKey;
    private byte[] macKey;
    private String macAlgorithm;
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private final AtomicBoolean isZeroed = new AtomicBoolean(false);

    public AgreedKeyWithMacKey(SecretKey secretKey) {
        this(secretKey, null, null);
    }

    public AgreedKeyWithMacKey(SecretKey secretKey, String macAlgorithm, byte[] macKey) {
        this.secretKey = secretKey;
        this.macKey = Arrays.clone(macKey);
        this.macAlgorithm = macAlgorithm;
    }

    public String getAlgorithm() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("key has been destroyed");
        }
        return this.secretKey.getAlgorithm();
    }

    public String getFormat() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("key has been destroyed");
        }
        return this.secretKey.getFormat();
    }

    public byte[] getEncoded() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("key has been destroyed");
        }
        return this.secretKey.getEncoded();
    }

    public void destroy() {
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            this.secretKey = null;
        }
    }

    public boolean isDestroyed() {
        return this.hasBeenDestroyed.get();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof SecretKey) {
            return this.secretKey.equals(o);
        }
        return false;
    }

    public int hashCode() {
        return this.secretKey.hashCode();
    }

    private byte[] getMacKeyBytes() {
        if (this.isZeroed.get()) {
            return null;
        }
        return this.macKey;
    }

    public ZeroizableSecretKey getMacKey() {
        if (this.isDestroyed()) {
            throw new IllegalStateException("key has been destroyed");
        }
        if (this.macKey == null) {
            return null;
        }
        return new ZeroizableSecretKey(){

            public void zeroize() {
                AgreedKeyWithMacKey.this.isZeroed.set(true);
                if (AgreedKeyWithMacKey.this.macKey != null) {
                    Arrays.fill(AgreedKeyWithMacKey.this.macKey, (byte)0);
                }
            }

            public void destroy() {
                this.zeroize();
            }

            public boolean isDestroyed() {
                return AgreedKeyWithMacKey.this.isZeroed.get();
            }

            public String getAlgorithm() {
                return AgreedKeyWithMacKey.this.macAlgorithm;
            }

            public String getFormat() {
                return "RAW";
            }

            public byte[] getEncoded() {
                return AgreedKeyWithMacKey.this.getMacKeyBytes();
            }
        };
    }
}

