/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.io.ByteArrayOutputStream;
import java.math.BigInteger;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKey;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.IllegalKeyException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.InvalidSignatureException;
import org.bouncycastle.crypto.InvalidWrappingException;
import org.bouncycastle.crypto.KeyUnwrapperUsingSecureRandom;
import org.bouncycastle.crypto.KeyWrapperUsingSecureRandom;
import org.bouncycastle.crypto.OperatorUsingSecureRandom;
import org.bouncycastle.crypto.OutputSignerUsingSecureRandom;
import org.bouncycastle.crypto.OutputSignerWithMessageRecovery;
import org.bouncycastle.crypto.OutputVerifier;
import org.bouncycastle.crypto.OutputVerifierWithMessageRecovery;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.RecoveredMessage;
import org.bouncycastle.crypto.SingleBlockDecryptor;
import org.bouncycastle.crypto.SingleBlockDecryptorUsingSecureRandom;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricRSAPublicKey;
import org.bouncycastle.crypto.fips.FipsRSA;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.general.FipsRegister;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.general.GuardedAsymmetricOperatorFactory;
import org.bouncycastle.crypto.general.GuardedSignatureOperatorFactory;
import org.bouncycastle.crypto.general.GuardedSignatureWithMessageRecoveryOperatorFactory;
import org.bouncycastle.crypto.general.ISO9796d2PSSSigner;
import org.bouncycastle.crypto.general.ISO9796d2Signer;
import org.bouncycastle.crypto.general.Register;
import org.bouncycastle.crypto.general.RsaDigestSigner;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.general.X931Signer;
import org.bouncycastle.crypto.internal.AsymmetricBlockCipher;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.CryptoException;
import org.bouncycastle.crypto.internal.DataLengthException;
import org.bouncycastle.crypto.internal.Digest;
import org.bouncycastle.crypto.internal.PrimeCertaintyCalculator;
import org.bouncycastle.crypto.internal.Signer;
import org.bouncycastle.crypto.internal.SignerWithRecovery;
import org.bouncycastle.crypto.internal.encodings.OAEPEncoding;
import org.bouncycastle.crypto.internal.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.internal.io.SignerOutputStream;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.crypto.internal.params.RsaKeyParameters;
import org.bouncycastle.crypto.internal.params.RsaPrivateCrtKeyParameters;
import org.bouncycastle.crypto.internal.signers.BaseRsaDigestSigner;
import org.bouncycastle.util.Arrays;

public final class RSA {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("RSA", (Enum)Variations.RAW);
    private static final GeneralAlgorithm ALGORITHM_OAEP = new GeneralAlgorithm("RSA/OAEP", (Enum)Variations.OAEP);
    private static final GeneralAlgorithm ALGORITHM_PKCS1v1_5 = new GeneralAlgorithm("RSA/PKCS1V1.5", (Enum)Variations.PKCS1v1_5);
    private static final GeneralAlgorithm ALGORITHM_X931 = new GeneralAlgorithm("RSA/X9.31", (Enum)Variations.X931);
    private static final GeneralAlgorithm ALGORITHM_PSS = new GeneralAlgorithm("RSA/PSS", (Enum)Variations.PSS);
    private static final GeneralAlgorithm ALGORITHM_ISO9796d2 = new GeneralAlgorithm("RSA/ISO9796-2", (Enum)Variations.ISO9796d2);
    private static final GeneralAlgorithm ALGORITHM_ISO9796d2PSS = new GeneralAlgorithm("RSA/ISO9796-2PSS", (Enum)Variations.ISO9796d2PSS);
    public static final RawParameters RAW = new RawParameters();
    public static final ISO9796d2SignatureParameters ISO9796d2 = new ISO9796d2SignatureParameters();
    public static final ISO9796d2PSSSignatureParameters ISO9796d2PSS = new ISO9796d2PSSSignatureParameters();
    public static final OAEPParameters WRAP_OAEP = new OAEPParameters();
    public static final PKCS1v15SignatureParameters PKCS1v1_5 = new PKCS1v15SignatureParameters();
    public static final PKCS1v15Parameters WRAP_PKCS1v1_5 = new PKCS1v15Parameters();
    public static final X931SignatureParameters X931 = new X931SignatureParameters();

    private RSA() {
    }

    private static AsymmetricBlockCipher createCipher(boolean forEncryption, AsymmetricRSAKey key, Parameters parameters, SecureRandom random) {
        CipherParameters params;
        AsymmetricRSAKey k;
        AsymmetricBlockCipher engine = (AsymmetricBlockCipher)FipsRegister.getProvider(FipsRSA.ALGORITHM).createEngine();
        if (!key.canBeUsed(AsymmetricRSAKey.Usage.ENCRYPT_OR_DECRYPT)) {
            throw new IllegalKeyException("Attempt to encrypt/decrypt with RSA modulus already used for sign/verify.");
        }
        if (key instanceof AsymmetricRSAPublicKey) {
            k = (AsymmetricRSAPublicKey)key;
            params = new RsaKeyParameters(false, k.getModulus(), ((AsymmetricRSAPublicKey)k).getPublicExponent());
        } else {
            k = (AsymmetricRSAPrivateKey)key;
            params = RSA.getPrivateKeyParameters((AsymmetricRSAPrivateKey)k);
        }
        if (((GeneralAlgorithm)parameters.getAlgorithm()).equals(ALGORITHM_OAEP)) {
            OAEPParameters oaep = (OAEPParameters)parameters;
            engine = new OAEPEncoding(engine, Register.createDigest(oaep.digestAlgorithm), Register.createDigest(oaep.mgfDigestAlgorithm), oaep.encodingParams);
        } else if (((GeneralAlgorithm)parameters.getAlgorithm()).equals(ALGORITHM_PKCS1v1_5)) {
            engine = new PKCS1Encoding(engine);
        }
        if (random != null) {
            params = new ParametersWithRandom(params, random);
        }
        engine.init(forEncryption, params);
        return engine;
    }

    private static RsaKeyParameters getPrivateKeyParameters(final AsymmetricRSAPrivateKey k) {
        return AccessController.doPrivileged(new PrivilegedAction<RsaKeyParameters>(){

            @Override
            public RsaKeyParameters run() {
                if (k.getPublicExponent().equals(BigInteger.ZERO)) {
                    return new RsaKeyParameters(true, k.getModulus(), k.getPrivateExponent());
                }
                return new RsaPrivateCrtKeyParameters(k.getModulus(), k.getPublicExponent(), k.getPrivateExponent(), k.getP(), k.getQ(), k.getDP(), k.getDQ(), k.getQInv());
            }
        });
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ISO9796d2PSSSignatureParameters
    extends SignatureParameters<ISO9796d2PSSSignatureParameters> {
        private final int saltLength;
        private final byte[] salt;

        ISO9796d2PSSSignatureParameters() {
            this(FipsSHS.Algorithm.SHA1, 20, null);
        }

        private ISO9796d2PSSSignatureParameters(DigestAlgorithm digestAlgorithm) {
            this(digestAlgorithm, Register.createDigest(digestAlgorithm).getDigestSize(), null);
        }

        private ISO9796d2PSSSignatureParameters(DigestAlgorithm digestAlgorithm, int saltLength, byte[] salt) {
            super(ALGORITHM_ISO9796d2PSS, digestAlgorithm);
            this.saltLength = saltLength;
            this.salt = salt;
        }

        public ISO9796d2PSSSignatureParameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new ISO9796d2PSSSignatureParameters(digestAlgorithm);
        }

        public ISO9796d2PSSSignatureParameters withSaltLength(int saltLength) {
            return new ISO9796d2PSSSignatureParameters(this.getDigestAlgorithm(), saltLength, null);
        }

        public ISO9796d2PSSSignatureParameters withSalt(byte[] salt) {
            return new ISO9796d2PSSSignatureParameters(this.getDigestAlgorithm(), salt.length, Arrays.clone(salt));
        }

        public byte[] getSalt() {
            return Arrays.clone(this.salt);
        }

        public int getSaltLength() {
            return this.saltLength;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class ISO9796d2SignatureParameters
    extends SignatureParameters<ISO9796d2SignatureParameters> {
        ISO9796d2SignatureParameters() {
            super(ALGORITHM_ISO9796d2, FipsSHS.Algorithm.SHA1);
        }

        private ISO9796d2SignatureParameters(DigestAlgorithm digestAlgorithm) {
            super(ALGORITHM_ISO9796d2, digestAlgorithm);
        }

        public ISO9796d2SignatureParameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new ISO9796d2SignatureParameters(digestAlgorithm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyGenParameters
    extends GeneralParameters<GeneralAlgorithm> {
        private BigInteger publicExponent;
        private int keySize;
        private int certainty;

        public KeyGenParameters(BigInteger publicExponent, int keySize) {
            this(ALGORITHM, publicExponent, keySize, PrimeCertaintyCalculator.getDefaultCertainty(keySize));
        }

        public KeyGenParameters(BigInteger publicExponent, int keySize, int certainty) {
            this(ALGORITHM, publicExponent, keySize, certainty);
        }

        public KeyGenParameters(SignatureParameters parameters, BigInteger publicExponent, int keySize) {
            this((Algorithm)parameters.getAlgorithm(), publicExponent, keySize, PrimeCertaintyCalculator.getDefaultCertainty(keySize));
        }

        public KeyGenParameters(WrapParameters parameters, BigInteger publicExponent, int keySize) {
            this((Algorithm)parameters.getAlgorithm(), publicExponent, keySize, PrimeCertaintyCalculator.getDefaultCertainty(keySize));
        }

        private KeyGenParameters(Algorithm algorithm, BigInteger publicExponent, int keySize, int certainty) {
            super((GeneralAlgorithm)algorithm);
            this.publicExponent = publicExponent;
            this.keySize = keySize;
            this.certainty = certainty;
        }

        public BigInteger getPublicExponent() {
            return this.publicExponent;
        }

        public int getKeySize() {
            return this.keySize;
        }

        public int getCertainty() {
            return this.certainty;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricRSAPublicKey, AsymmetricRSAPrivateKey> {
        private final FipsRSA.KeyPairGenerator kpGen;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom random) {
            super(keyGenParameters);
            this.kpGen = new FipsRSA.KeyPairGenerator(new FipsRSA.KeyGenParameters(keyGenParameters.publicExponent, keyGenParameters.keySize, keyGenParameters.certainty), random);
        }

        @Override
        public AsymmetricKeyPair<AsymmetricRSAPublicKey, AsymmetricRSAPrivateKey> doGenerateKeyPair() {
            AsymmetricKeyPair<AsymmetricRSAPublicKey, AsymmetricRSAPrivateKey> kp = this.kpGen.generateKeyPair();
            final AsymmetricRSAPublicKey pubKey = kp.getPublicKey();
            final AsymmetricRSAPrivateKey prvKey = kp.getPrivateKey();
            final Object algorithm = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            return AccessController.doPrivileged(new PrivilegedAction<AsymmetricKeyPair<AsymmetricRSAPublicKey, AsymmetricRSAPrivateKey>>(){

                @Override
                public AsymmetricKeyPair<AsymmetricRSAPublicKey, AsymmetricRSAPrivateKey> run() {
                    return new AsymmetricKeyPair<AsymmetricRSAPublicKey, AsymmetricRSAPrivateKey>(new AsymmetricRSAPublicKey(algorithm, pubKey.getModulus(), pubKey.getPublicExponent()), new AsymmetricRSAPrivateKey(algorithm, prvKey.getModulus(), prvKey.getPublicExponent(), prvKey.getPrivateExponent(), prvKey.getP(), prvKey.getQ(), prvKey.getDP(), prvKey.getDQ(), prvKey.getQInv()));
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyWrapOperatorFactory
    implements org.bouncycastle.crypto.KeyWrapOperatorFactory<WrapParameters, AsymmetricRSAKey> {
        public KeyWrapOperatorFactory() {
            FipsStatus.isReady();
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode");
            }
        }

        @Override
        public KeyWrapperUsingSecureRandom<WrapParameters> createKeyWrapper(AsymmetricRSAKey key, WrapParameters parameters) {
            return new KeyWrapper(key, parameters, null);
        }

        @Override
        public KeyUnwrapperUsingSecureRandom<WrapParameters> createKeyUnwrapper(AsymmetricRSAKey key, WrapParameters parameters) {
            return new KeyUnwrapper(key, parameters, null);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class KeyUnwrapper
        implements KeyUnwrapperUsingSecureRandom<WrapParameters> {
            private final AsymmetricBlockCipher keyWrapper;
            private final AsymmetricRSAKey key;
            private final WrapParameters parameters;

            public KeyUnwrapper(AsymmetricRSAKey key, WrapParameters parameters, SecureRandom random) {
                if (!key.canBeUsed(AsymmetricRSAKey.Usage.ENCRYPT_OR_DECRYPT)) {
                    throw new IllegalKeyException("Attempt to encrypt/decrypt with RSA modulus already used for sign/verify.");
                }
                this.key = key;
                this.parameters = parameters;
                this.keyWrapper = random != null ? RSA.createCipher(false, key, parameters, random) : null;
            }

            @Override
            public WrapParameters getParameters() {
                return this.parameters;
            }

            @Override
            public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidWrappingException {
                if (this.keyWrapper == null) {
                    throw new IllegalStateException("KeyUnwrapper requires a SecureRandom");
                }
                Utils.approveModeCheck(this.parameters.getAlgorithm());
                try {
                    return this.keyWrapper.processBlock(in, inOff, inLen);
                }
                catch (Exception e) {
                    throw new InvalidWrappingException("Unable to unwrap key: " + e.getMessage(), e);
                }
            }

            @Override
            public KeyUnwrapperUsingSecureRandom<WrapParameters> withSecureRandom(SecureRandom random) {
                return new KeyUnwrapper(this.key, this.parameters, random);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class KeyWrapper
        implements KeyWrapperUsingSecureRandom<WrapParameters> {
            private final AsymmetricBlockCipher keyWrapper;
            private final AsymmetricRSAKey key;
            private final WrapParameters parameters;

            public KeyWrapper(AsymmetricRSAKey key, WrapParameters parameters, SecureRandom random) {
                if (!key.canBeUsed(AsymmetricRSAKey.Usage.ENCRYPT_OR_DECRYPT)) {
                    throw new IllegalKeyException("Attempt to encrypt/decrypt with RSA modulus already used for sign/verify.");
                }
                if (parameters == null) {
                    throw new NullPointerException("Null parameters object");
                }
                this.key = key;
                this.parameters = parameters;
                this.keyWrapper = random != null ? RSA.createCipher(true, key, parameters, random) : null;
            }

            @Override
            public WrapParameters getParameters() {
                return this.parameters;
            }

            @Override
            public byte[] wrap(byte[] in, int inOff, int inLen) throws PlainInputProcessingException {
                if (this.keyWrapper == null) {
                    throw new IllegalStateException("KeyWrapper requires a SecureRandom");
                }
                Utils.approveModeCheck(this.parameters.getAlgorithm());
                try {
                    return this.keyWrapper.processBlock(in, inOff, inLen);
                }
                catch (Exception e) {
                    throw new PlainInputProcessingException("Unable to wrap key: " + e.getMessage(), e);
                }
            }

            @Override
            public KeyWrapperUsingSecureRandom<WrapParameters> withSecureRandom(SecureRandom random) {
                return new KeyWrapper(this.key, this.parameters, random);
            }
        }
    }

    private static class NullSigner
    implements Signer {
        AsymmetricBlockCipher engine = new PKCS1Encoding((AsymmetricBlockCipher)FipsRegister.getProvider(FipsRSA.ALGORITHM).createEngine());
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();

        private NullSigner() {
        }

        public void init(boolean forSigning, CipherParameters param) {
            this.engine.init(forSigning, param);
        }

        public void update(byte b) {
            this.bOut.write(b);
        }

        public void update(byte[] in, int off, int len) {
            this.bOut.write(in, off, len);
        }

        public byte[] generateSignature() throws CryptoException, DataLengthException {
            byte[] data = this.bOut.toByteArray();
            this.bOut.reset();
            return this.engine.processBlock(data, 0, data.length);
        }

        public boolean verifySignature(byte[] signature) throws InvalidSignatureException {
            byte[] input = this.bOut.toByteArray();
            this.bOut.reset();
            try {
                byte[] sig = this.engine.processBlock(signature, 0, signature.length);
                return BaseRsaDigestSigner.checkPKCS1Sig(input, sig);
            }
            catch (org.bouncycastle.crypto.internal.InvalidCipherTextException e) {
                throw new InvalidSignatureException("Unable to process signature: " + e.getMessage(), e);
            }
        }

        public void reset() {
            this.bOut = new ByteArrayOutputStream();
        }
    }

    public static final class OAEPParameters
    extends WrapParameters {
        private final DigestAlgorithm digestAlgorithm;
        private final DigestAlgorithm mgfDigestAlgorithm;
        private final byte[] encodingParams;

        OAEPParameters() {
            this(FipsSHS.Algorithm.SHA1, FipsSHS.Algorithm.SHA1, null);
        }

        private OAEPParameters(DigestAlgorithm digestAlgorithm, DigestAlgorithm mgfDigestAlgorithm, byte[] encodingParams) {
            super(ALGORITHM_OAEP);
            this.digestAlgorithm = digestAlgorithm;
            this.mgfDigestAlgorithm = mgfDigestAlgorithm;
            this.encodingParams = Arrays.clone(encodingParams);
        }

        public OAEPParameters withDigest(DigestAlgorithm digestAlgorithm) {
            return new OAEPParameters(digestAlgorithm, digestAlgorithm, this.encodingParams);
        }

        public OAEPParameters withMGFDigest(DigestAlgorithm mgfDigestAlgorithm) {
            return new OAEPParameters(this.digestAlgorithm, mgfDigestAlgorithm, this.encodingParams);
        }

        public OAEPParameters withEncodingParams(byte[] encodingParams) {
            return new OAEPParameters(this.digestAlgorithm, this.mgfDigestAlgorithm, Arrays.clone(encodingParams));
        }

        public DigestAlgorithm getDigest() {
            return this.digestAlgorithm;
        }

        public DigestAlgorithm getMGFDigest() {
            return this.mgfDigestAlgorithm;
        }

        public byte[] getEncodingParams() {
            return Arrays.clone(this.encodingParams);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends GuardedAsymmetricOperatorFactory<Parameters> {
        @Override
        public SingleBlockDecryptor<Parameters> createBlockDecryptor(AsymmetricKey key, Parameters parameters) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", (Algorithm)parameters.getAlgorithm());
            }
            return new BlockDecryptor(key, parameters, null);
        }

        @Override
        protected AsymmetricBlockCipher createCipher(boolean forEncryption, AsymmetricKey key, Parameters parameters, SecureRandom random) {
            return RSA.createCipher(forEncryption, (AsymmetricRSAKey)key, parameters, random);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class BlockDecryptor
        implements SingleBlockDecryptorUsingSecureRandom<Parameters> {
            private final AsymmetricKey key;
            private final Parameters parameters;
            private AsymmetricBlockCipher engine;

            BlockDecryptor(AsymmetricKey key, Parameters parameters, SecureRandom random) {
                this.key = key;
                this.parameters = parameters;
                if (random != null) {
                    this.engine = OperatorFactory.this.createCipher(false, key, parameters, random);
                }
            }

            @Override
            public byte[] decryptBlock(byte[] bytes, int offSet, int length) throws InvalidCipherTextException {
                if (this.engine == null) {
                    throw new IllegalStateException("RSA BlockDecryptor requires a SecureRandom");
                }
                Utils.approveModeCheck(this.parameters.getAlgorithm());
                try {
                    Utils.approveModeCheck(this.parameters.getAlgorithm());
                    return this.engine.processBlock(bytes, offSet, length);
                }
                catch (Exception e) {
                    throw new InvalidCipherTextException("Unable to decrypt block: " + e.getMessage(), e);
                }
            }

            @Override
            public Parameters getParameters() {
                return this.parameters;
            }

            @Override
            public int getInputSize() {
                Utils.approveModeCheck(this.parameters.getAlgorithm());
                if (this.engine == null) {
                    throw new IllegalStateException("RSA BlockDecryptor requires a SecureRandom");
                }
                if (GuardedAsymmetricOperatorFactory.isRawEngine(this.engine)) {
                    return this.engine.getInputBlockSize() + 1;
                }
                return this.engine.getInputBlockSize();
            }

            @Override
            public int getOutputSize() {
                Utils.approveModeCheck(this.parameters.getAlgorithm());
                if (this.engine == null) {
                    throw new IllegalStateException("RSA BlockDecryptor requires a SecureRandom");
                }
                return this.engine.getOutputBlockSize();
            }

            @Override
            public SingleBlockDecryptorUsingSecureRandom<Parameters> withSecureRandom(SecureRandom random) {
                Utils.approveModeCheck(this.parameters.getAlgorithm());
                return new BlockDecryptor(this.key, this.parameters, random);
            }
        }
    }

    public static final class PKCS1v15Parameters
    extends WrapParameters {
        PKCS1v15Parameters() {
            super(ALGORITHM_PKCS1v1_5);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PKCS1v15SignatureParameters
    extends SignatureParameters<PKCS1v15SignatureParameters> {
        PKCS1v15SignatureParameters() {
            super(ALGORITHM_PKCS1v1_5, FipsSHS.Algorithm.SHA1);
        }

        private PKCS1v15SignatureParameters(DigestAlgorithm digestAlgorithm) {
            super(ALGORITHM_PKCS1v1_5, digestAlgorithm);
        }

        public PKCS1v15SignatureParameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new PKCS1v15SignatureParameters(digestAlgorithm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Parameters
    extends GeneralParameters<GeneralAlgorithm> {
        Parameters(GeneralAlgorithm algorithm) {
            super(algorithm);
        }
    }

    public static final class RawParameters
    extends Parameters {
        RawParameters() {
            super(ALGORITHM);
        }
    }

    private static class RecoveredMessageImpl
    implements RecoveredMessage {
        private final boolean isFullMessage;
        private final byte[] content;

        public RecoveredMessageImpl(boolean isFullMessage, byte[] content) {
            this.isFullMessage = isFullMessage;
            this.content = content;
        }

        public byte[] getContent() {
            return Arrays.clone(this.content);
        }

        public boolean isFullMessage() {
            return this.isFullMessage;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SignatureOperatorFactory<T extends SignatureParameters>
    extends GuardedSignatureOperatorFactory<T> {
        @Override
        protected OutputSignerUsingSecureRandom<T> doCreateSigner(AsymmetricPrivateKey key, T parameters) {
            AsymmetricRSAPrivateKey k = (AsymmetricRSAPrivateKey)key;
            if (!k.canBeUsed(AsymmetricRSAKey.Usage.SIGN_OR_VERIFY)) {
                throw new IllegalKeyException("Attempt to sign/verify with RSA modulus already used for encrypt/decrypt.");
            }
            return new RSASigner(this, parameters, (CipherParameters)RSA.getPrivateKeyParameters(k), null);
        }

        private Signer getSigner(SignatureParameters parameters) {
            if (parameters.getAlgorithm() == ALGORITHM_PKCS1v1_5) {
                if (parameters.getDigestAlgorithm() == null) {
                    return new NullSigner();
                }
                return new RsaDigestSigner(Register.createDigest(parameters.digestAlgorithm));
            }
            if (parameters.getAlgorithm() == ALGORITHM_X931) {
                return new X931Signer(Register.createDigest(parameters.digestAlgorithm));
            }
            throw new IllegalArgumentException("Algorithm " + parameters.getAlgorithm().getName() + " not recognized");
        }

        @Override
        public OutputVerifier<T> doCreateVerifier(AsymmetricPublicKey key, final SignatureParameters parameters) {
            AsymmetricRSAPublicKey k = (AsymmetricRSAPublicKey)key;
            if (!k.canBeUsed(AsymmetricRSAKey.Usage.SIGN_OR_VERIFY)) {
                throw new IllegalKeyException("Attempt to sign/verify with RSA modulus already used for encrypt/decrypt.");
            }
            RsaKeyParameters publicKeyParameters = new RsaKeyParameters(false, k.getModulus(), k.getPublicExponent());
            final Signer rsaSigner = this.getSigner(parameters);
            rsaSigner.init(false, publicKeyParameters);
            return new OutputVerifier<T>(){

                @Override
                public T getParameters() {
                    return parameters;
                }

                @Override
                public UpdateOutputStream getVerifyingStream() {
                    return new SignerOutputStream(parameters.getAlgorithm().getName(), rsaSigner);
                }

                @Override
                public boolean isVerified(byte[] signature) throws InvalidSignatureException {
                    return rsaSigner.verifySignature(signature);
                }
            };
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class RSASigner<P extends SignatureParameters>
        implements OutputSignerUsingSecureRandom<P> {
            private final Signer signer;
            private final CipherParameters keyParameters;
            private final P parameters;
            private SecureRandom random;
            final /* synthetic */ SignatureOperatorFactory this$0;

            RSASigner(P parameters, CipherParameters keyParameters, SecureRandom random) {
                this.this$0 = var1_1;
                this.parameters = parameters;
                this.keyParameters = keyParameters;
                this.random = random;
                this.signer = ((SignatureOperatorFactory)var1_1).getSigner(parameters);
                if (random != null) {
                    this.signer.init(true, new ParametersWithRandom(keyParameters, random));
                }
            }

            @Override
            public P getParameters() {
                return this.parameters;
            }

            @Override
            public UpdateOutputStream getSigningStream() {
                this.checkInit();
                return new SignerOutputStream(((GeneralParameters)this.parameters).getAlgorithm().getName(), this.signer);
            }

            @Override
            public byte[] getSignature() throws PlainInputProcessingException {
                try {
                    return this.signer.generateSignature();
                }
                catch (Exception e) {
                    throw new PlainInputProcessingException("Unable to create signature: " + e.getMessage(), e);
                }
            }

            @Override
            public OutputSignerUsingSecureRandom<P> withSecureRandom(SecureRandom random) {
                return new RSASigner(this.this$0, this.parameters, this.keyParameters, random);
            }

            @Override
            public int getSignature(byte[] output, int off) throws PlainInputProcessingException {
                byte[] signature = this.getSignature();
                System.arraycopy(signature, 0, output, off, signature.length);
                return signature.length;
            }

            private void checkInit() {
                if (this.random == null) {
                    this.random = CryptoServicesRegistrar.getSecureRandom();
                    this.signer.init(true, new ParametersWithRandom(this.keyParameters, this.random));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class SignatureParameters<T extends SignatureParameters>
    extends GeneralParameters {
        private final DigestAlgorithm digestAlgorithm;

        SignatureParameters(GeneralAlgorithm algorithm, DigestAlgorithm digestAlgorithm) {
            super(algorithm);
            this.digestAlgorithm = digestAlgorithm;
        }

        public DigestAlgorithm getDigestAlgorithm() {
            return this.digestAlgorithm;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class SignatureWithMessageRecoveryOperatorFactory<T extends SignatureParameters>
    extends GuardedSignatureWithMessageRecoveryOperatorFactory<T> {
        @Override
        protected OutputSignerWithMessageRecovery<T> doCreateSigner(AsymmetricPrivateKey key, T parameters) {
            AsymmetricRSAPrivateKey k = (AsymmetricRSAPrivateKey)key;
            if (!k.canBeUsed(AsymmetricRSAKey.Usage.SIGN_OR_VERIFY)) {
                throw new IllegalKeyException("Attempt to sign/verify with RSA modulus already used for encrypt/decrypt.");
            }
            RsaKeyParameters privateKeyParameters = RSA.getPrivateKeyParameters(k);
            return new RSASigner(this, parameters, (CipherParameters)privateKeyParameters, null);
        }

        @Override
        protected OutputVerifierWithMessageRecovery<T> doCreateVerifier(AsymmetricPublicKey key, final SignatureParameters parameters) {
            AsymmetricRSAPublicKey k = (AsymmetricRSAPublicKey)key;
            if (!k.canBeUsed(AsymmetricRSAKey.Usage.SIGN_OR_VERIFY)) {
                throw new IllegalKeyException("Attempt to sign/verify with RSA modulus already used for encrypt/decrypt.");
            }
            RsaKeyParameters publicKeyParameters = new RsaKeyParameters(false, k.getModulus(), k.getPublicExponent());
            final SignerWithRecovery rsaSigner = this.getSigner(parameters);
            rsaSigner.init(false, publicKeyParameters);
            return new OutputVerifierWithMessageRecovery<T>(){

                @Override
                public T getParameters() {
                    return parameters;
                }

                @Override
                public UpdateOutputStream getVerifyingStream() {
                    return new SignerOutputStream(parameters.getAlgorithm().getName(), rsaSigner);
                }

                @Override
                public boolean isVerified(byte[] signature) throws InvalidSignatureException {
                    return rsaSigner.verifySignature(signature);
                }

                @Override
                public RecoveredMessage getRecoveredMessage() {
                    return new RecoveredMessageImpl(rsaSigner.hasFullMessage(), rsaSigner.getRecoveredMessage());
                }

                @Override
                public void updateWithRecoveredMessage(byte[] signature) throws InvalidSignatureException {
                    try {
                        rsaSigner.updateWithRecoveredMessage(signature);
                    }
                    catch (Exception e) {
                        throw new InvalidSignatureException("Unable to recover message: " + e.getMessage(), e);
                    }
                }
            };
        }

        private SignerWithRecovery getSigner(SignatureParameters parameters) {
            if (parameters.getAlgorithm() == ALGORITHM_ISO9796d2) {
                return new ISO9796d2Signer(Register.createDigest(parameters.digestAlgorithm));
            }
            if (parameters.getAlgorithm() == ALGORITHM_ISO9796d2PSS) {
                ISO9796d2PSSSignatureParameters params = (ISO9796d2PSSSignatureParameters)parameters;
                Digest digest = Register.createDigest(parameters.digestAlgorithm);
                byte[] fixedSalt = params.getSalt();
                if (fixedSalt != null) {
                    return new ISO9796d2PSSSigner(digest, fixedSalt);
                }
                return new ISO9796d2PSSSigner(digest, params.getSaltLength());
            }
            throw new IllegalArgumentException("Algorithm " + parameters.getAlgorithm().getName() + " not recognized");
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private static class RSASigner<T extends SignatureParameters>
        implements OutputSignerWithMessageRecovery<T>,
        OperatorUsingSecureRandom<RSASigner<T>> {
            private final SignerWithRecovery signer;
            private final CipherParameters keyParameters;
            private final T parameters;
            private SecureRandom random;
            final /* synthetic */ SignatureWithMessageRecoveryOperatorFactory this$0;

            RSASigner(T parameters, CipherParameters keyParameters, SecureRandom random) {
                this.this$0 = var1_1;
                this.parameters = parameters;
                this.keyParameters = keyParameters;
                this.random = random;
                this.signer = ((SignatureWithMessageRecoveryOperatorFactory)var1_1).getSigner(parameters);
                if (random != null) {
                    this.signer.init(true, new ParametersWithRandom(keyParameters, random));
                }
            }

            @Override
            public T getParameters() {
                return this.parameters;
            }

            @Override
            public UpdateOutputStream getSigningStream() {
                this.checkInit();
                return new SignerOutputStream(((GeneralParameters)this.parameters).getAlgorithm().getName(), this.signer);
            }

            @Override
            public byte[] getSignature() throws PlainInputProcessingException {
                try {
                    return this.signer.generateSignature();
                }
                catch (Exception e) {
                    throw new PlainInputProcessingException("Unable to create signature: " + e.getMessage(), e);
                }
            }

            @Override
            public int getSignature(byte[] output, int off) throws PlainInputProcessingException {
                byte[] sig = this.getSignature();
                System.arraycopy(sig, 0, output, off, sig.length);
                return sig.length;
            }

            @Override
            public RecoveredMessage getRecoveredMessage() {
                return new RecoveredMessageImpl(this.signer.hasFullMessage(), this.signer.getRecoveredMessage());
            }

            @Override
            public RSASigner<T> withSecureRandom(SecureRandom random) {
                return new RSASigner(this.this$0, this.parameters, this.keyParameters, random);
            }

            private void checkInit() {
                if (this.random == null) {
                    this.random = CryptoServicesRegistrar.getSecureRandom();
                    this.signer.init(true, new ParametersWithRandom(this.keyParameters, this.random));
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Variations {
        RAW,
        PKCS1v1_5,
        PSS,
        X931,
        ISO9796d2,
        ISO9796d2PSS,
        OAEP;

    }

    public static class WrapParameters
    extends Parameters {
        WrapParameters(GeneralAlgorithm algorithm) {
            super(algorithm);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class X931SignatureParameters
    extends SignatureParameters<X931SignatureParameters> {
        public X931SignatureParameters() {
            super(ALGORITHM_X931, FipsSHS.Algorithm.SHA1);
        }

        public X931SignatureParameters(DigestAlgorithm digestAlgorithm) {
            super(ALGORITHM_X931, digestAlgorithm);
        }

        public X931SignatureParameters withDigestAlgorithm(DigestAlgorithm digestAlgorithm) {
            return new X931SignatureParameters(digestAlgorithm);
        }
    }
}

