/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.ParametersWithIV;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.util.Arrays;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneralParametersWithIV<T extends GeneralParameters>
extends GeneralParameters<GeneralAlgorithm>
implements ParametersWithIV<T> {
    protected final int blockSize;
    protected final byte[] iv;

    GeneralParametersWithIV(GeneralAlgorithm algorithm, int blockSize, byte[] iv) {
        super(algorithm);
        this.blockSize = blockSize;
        this.iv = iv;
    }

    @Override
    public byte[] getIV() {
        return Arrays.clone(this.iv);
    }

    @Override
    public T withIV(SecureRandom random) {
        return this.create((GeneralAlgorithm)this.getAlgorithm(), ((GeneralAlgorithm)this.getAlgorithm()).createDefaultIvIfNecessary(this.blockSize, random));
    }

    @Override
    public T withIV(byte[] iv) {
        return this.create((GeneralAlgorithm)this.getAlgorithm(), Arrays.clone(iv));
    }

    abstract T create(GeneralAlgorithm var1, byte[] var2);
}

