/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AuthenticationParametersWithIV;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParametersWithIV;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class GeneralAuthParameters<T extends GeneralAuthParameters>
extends GeneralParametersWithIV<T>
implements AuthenticationParametersWithIV<T> {
    protected final int macLenInBits;

    protected GeneralAuthParameters(GeneralAlgorithm algorithm, int blockSize, byte[] iv, int macSizeInBits) {
        super(algorithm, blockSize, iv);
        this.macLenInBits = macSizeInBits;
    }

    @Override
    public int getMACSizeInBits() {
        return this.macLenInBits;
    }

    @Override
    public T withIV(SecureRandom random, int ivLen) {
        return (T)this.create((GeneralAlgorithm)this.getAlgorithm(), ((GeneralAlgorithm)this.getAlgorithm()).createIvIfNecessary(ivLen, random));
    }

    @Override
    public T withMACSize(int macSizeInBits) {
        return this.create((GeneralAlgorithm)this.getAlgorithm(), this.getIV(), macSizeInBits);
    }

    @Override
    protected T create(GeneralAlgorithm algorithm, byte[] iv) {
        return this.create(algorithm, iv, this.getMACSizeInBits());
    }

    abstract T create(GeneralAlgorithm var1, byte[] var2, int var3);
}

