/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.general;

import java.security.SecureRandom;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.InvalidWrappingException;
import org.bouncycastle.crypto.KeyUnwrapperUsingSecureRandom;
import org.bouncycastle.crypto.KeyWrapperUsingSecureRandom;
import org.bouncycastle.crypto.PlainInputProcessingException;
import org.bouncycastle.crypto.SingleBlockDecryptor;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.DHDomainParameters;
import org.bouncycastle.crypto.fips.FipsDH;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.FipsStatus;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.crypto.general.ElGamalEngine;
import org.bouncycastle.crypto.general.ElGamalParameters;
import org.bouncycastle.crypto.general.ElGamalPrivateKeyParameters;
import org.bouncycastle.crypto.general.ElGamalPublicKeyParameters;
import org.bouncycastle.crypto.general.GeneralAlgorithm;
import org.bouncycastle.crypto.general.GeneralParameters;
import org.bouncycastle.crypto.general.GuardedAsymmetricKeyPairGenerator;
import org.bouncycastle.crypto.general.GuardedAsymmetricOperatorFactory;
import org.bouncycastle.crypto.general.Register;
import org.bouncycastle.crypto.general.Utils;
import org.bouncycastle.crypto.internal.AsymmetricBlockCipher;
import org.bouncycastle.crypto.internal.CipherParameters;
import org.bouncycastle.crypto.internal.encodings.OAEPEncoding;
import org.bouncycastle.crypto.internal.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.internal.params.ParametersWithRandom;
import org.bouncycastle.util.Arrays;

public final class ElGamal {
    public static final GeneralAlgorithm ALGORITHM = new GeneralAlgorithm("ELGAMAL", (Enum)Variations.RAW);
    private static final GeneralAlgorithm PKCS1v1_5 = new GeneralAlgorithm("ELGAMAL/PKCS1V1.5", (Enum)Variations.PKCS1v1_5);
    private static final GeneralAlgorithm ALGORITHM_OAEP = new GeneralAlgorithm("ELGAMAL/OAEP", (Enum)Variations.OAEP);
    public static final RawParameters RAW = new RawParameters();
    public static final OAEPParameters WRAP_OAEP = new OAEPParameters();
    public static final PKCS1v15Parameters WRAP_PKCS1v1_5 = new PKCS1v15Parameters();

    private ElGamal() {
    }

    private static AsymmetricBlockCipher createCipher(boolean forEncryption, AsymmetricKey key, Parameters parameters, SecureRandom random) {
        CipherParameters params;
        AsymmetricDHKey k;
        AsymmetricBlockCipher engine = new ElGamalEngine();
        if (key instanceof AsymmetricDHPublicKey) {
            k = (AsymmetricDHPublicKey)key;
            params = new ElGamalPublicKeyParameters(((AsymmetricDHPublicKey)k).getY(), new ElGamalParameters(k.getDomainParameters().getP(), k.getDomainParameters().getG(), k.getDomainParameters().getL()));
        } else {
            k = (AsymmetricDHPrivateKey)key;
            params = new ElGamalPrivateKeyParameters(((AsymmetricDHPrivateKey)k).getX(), new ElGamalParameters(((AsymmetricDHPrivateKey)k).getDomainParameters().getP(), ((AsymmetricDHPrivateKey)k).getDomainParameters().getG(), ((AsymmetricDHPrivateKey)k).getDomainParameters().getL()));
        }
        if (parameters.getAlgorithm().equals(PKCS1v1_5)) {
            engine = new PKCS1Encoding(engine);
        } else if (parameters.getAlgorithm().equals(ALGORITHM_OAEP)) {
            OAEPParameters oeapParams = (OAEPParameters)parameters;
            engine = new OAEPEncoding(engine, Register.createDigest(oeapParams.digestAlgorithm), Register.createDigest(oeapParams.mgfDigestAlgorithm), oeapParams.encodingParams);
        }
        if (random != null) {
            params = new ParametersWithRandom(params, random);
        }
        engine.init(forEncryption, params);
        return engine;
    }

    public static final class KeyGenParameters
    extends GeneralParameters {
        private DHDomainParameters domainParameters;

        public KeyGenParameters(DHDomainParameters domainParameters) {
            super(ALGORITHM);
            this.domainParameters = domainParameters;
        }

        public KeyGenParameters(Parameters parameters, DHDomainParameters domainParameters) {
            super(parameters.getAlgorithm());
            this.domainParameters = domainParameters;
        }

        public DHDomainParameters getDomainParameters() {
            return this.domainParameters;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyPairGenerator
    extends GuardedAsymmetricKeyPairGenerator<KeyGenParameters, AsymmetricDHPublicKey, AsymmetricDHPrivateKey> {
        private final FipsDH.KeyPairGenerator kpGen;

        public KeyPairGenerator(KeyGenParameters keyGenParameters, SecureRandom random) {
            super(keyGenParameters);
            this.kpGen = new FipsDH.KeyPairGenerator(new FipsDH.KeyGenParameters(keyGenParameters.domainParameters), random);
        }

        @Override
        protected AsymmetricKeyPair<AsymmetricDHPublicKey, AsymmetricDHPrivateKey> doGenerateKeyPair() {
            AsymmetricKeyPair<AsymmetricDHPublicKey, AsymmetricDHPrivateKey> kp = this.kpGen.generateKeyPair();
            Object algorithm = ((KeyGenParameters)this.getParameters()).getAlgorithm();
            AsymmetricDHPublicKey pubK = kp.getPublicKey();
            AsymmetricDHPrivateKey priK = kp.getPrivateKey();
            return new AsymmetricKeyPair<AsymmetricDHPublicKey, AsymmetricDHPrivateKey>(new AsymmetricDHPublicKey((Algorithm)algorithm, pubK.getDomainParameters(), pubK.getY()), new AsymmetricDHPrivateKey((Algorithm)algorithm, priK.getDomainParameters(), priK.getX()));
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class KeyWrapOperatorFactory
    implements org.bouncycastle.crypto.KeyWrapOperatorFactory<WrapParameters, AsymmetricDHKey> {
        public KeyWrapOperatorFactory() {
            FipsStatus.isReady();
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("Attempt to create unapproved factory in approved only mode");
            }
        }

        @Override
        public KeyWrapperUsingSecureRandom<WrapParameters> createKeyWrapper(AsymmetricDHKey key, WrapParameters parameters) {
            return new KeyWrapper(key, parameters, null);
        }

        @Override
        public KeyUnwrapperUsingSecureRandom<WrapParameters> createKeyUnwrapper(AsymmetricDHKey key, WrapParameters parameters) {
            return new KeyUnwrapper(key, parameters, null);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class KeyUnwrapper
        implements KeyUnwrapperUsingSecureRandom<WrapParameters> {
            private final AsymmetricBlockCipher keyWrapper;
            private final AsymmetricDHKey key;
            private final WrapParameters parameters;

            public KeyUnwrapper(AsymmetricDHKey key, WrapParameters parameters, SecureRandom random) {
                if (!(parameters instanceof Parameters)) {
                    throw new IllegalArgumentException("Unknown parameters object: " + parameters.getClass().getName());
                }
                this.key = key;
                this.parameters = parameters;
                this.keyWrapper = random != null ? ElGamal.createCipher(false, key, (Parameters)((Object)parameters), random) : null;
            }

            @Override
            public WrapParameters getParameters() {
                return this.parameters;
            }

            @Override
            public byte[] unwrap(byte[] in, int inOff, int inLen) throws InvalidWrappingException {
                if (this.keyWrapper == null) {
                    throw new IllegalStateException("KeyUnwrapper requires a SecureRandom");
                }
                Utils.approveModeCheck(this.parameters.getAlgorithm());
                try {
                    return this.keyWrapper.processBlock(in, inOff, inLen);
                }
                catch (Exception e) {
                    throw new InvalidWrappingException("Unable to unwrap key: " + e.getMessage(), e);
                }
            }

            @Override
            public KeyUnwrapperUsingSecureRandom<WrapParameters> withSecureRandom(SecureRandom random) {
                return new KeyUnwrapper(this.key, this.parameters, random);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        private class KeyWrapper
        implements KeyWrapperUsingSecureRandom<WrapParameters> {
            private final AsymmetricBlockCipher keyWrapper;
            private final AsymmetricDHKey key;
            private final WrapParameters parameters;

            public KeyWrapper(AsymmetricDHKey key, WrapParameters parameters, SecureRandom random) {
                if (!(parameters instanceof Parameters)) {
                    throw new IllegalArgumentException("Unknown parameters object: " + parameters.getClass().getName());
                }
                this.key = key;
                this.parameters = parameters;
                this.keyWrapper = random != null ? ElGamal.createCipher(true, key, (Parameters)((Object)parameters), random) : null;
            }

            @Override
            public WrapParameters getParameters() {
                return this.parameters;
            }

            @Override
            public byte[] wrap(byte[] in, int inOff, int inLen) throws PlainInputProcessingException {
                if (this.keyWrapper == null) {
                    throw new IllegalStateException("KeyWrapper requires a SecureRandom");
                }
                Utils.approveModeCheck(this.parameters.getAlgorithm());
                try {
                    return this.keyWrapper.processBlock(in, inOff, inLen);
                }
                catch (Exception e) {
                    throw new PlainInputProcessingException("Unable to wrap key: " + e.getMessage(), e);
                }
            }

            @Override
            public KeyWrapperUsingSecureRandom<WrapParameters> withSecureRandom(SecureRandom random) {
                return new KeyWrapper(this.key, this.parameters, random);
            }
        }
    }

    public static final class OAEPParameters
    extends Parameters
    implements WrapParameters {
        private final DigestAlgorithm digestAlgorithm;
        private final DigestAlgorithm mgfDigestAlgorithm;
        private final byte[] encodingParams;

        OAEPParameters() {
            this(FipsSHS.Algorithm.SHA1, FipsSHS.Algorithm.SHA1, null);
        }

        private OAEPParameters(DigestAlgorithm digestAlgorithm, DigestAlgorithm mgfDigestAlgorithm, byte[] encodingParams) {
            super(ALGORITHM_OAEP);
            this.digestAlgorithm = digestAlgorithm;
            this.mgfDigestAlgorithm = mgfDigestAlgorithm;
            this.encodingParams = Arrays.clone(encodingParams);
        }

        public OAEPParameters withDigest(DigestAlgorithm digestAlgorithm) {
            return new OAEPParameters(digestAlgorithm, digestAlgorithm, this.encodingParams);
        }

        public OAEPParameters withMGFDigest(DigestAlgorithm mgfDigestAlgorithm) {
            return new OAEPParameters(this.digestAlgorithm, mgfDigestAlgorithm, this.encodingParams);
        }

        public OAEPParameters withEncodingParams(byte[] encodingParams) {
            return new OAEPParameters(this.digestAlgorithm, this.mgfDigestAlgorithm, Arrays.clone(encodingParams));
        }

        public DigestAlgorithm getDigest() {
            return this.digestAlgorithm;
        }

        public DigestAlgorithm getMGFDigest() {
            return this.mgfDigestAlgorithm;
        }

        public byte[] getEncodingParams() {
            return Arrays.clone(this.encodingParams);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class OperatorFactory
    extends GuardedAsymmetricOperatorFactory<Parameters> {
        @Override
        public SingleBlockDecryptor<Parameters> createBlockDecryptor(AsymmetricKey key, final Parameters parameters) {
            if (CryptoServicesRegistrar.isInApprovedOnlyMode()) {
                throw new FipsUnapprovedOperationError("Attempt to create unapproved algorithm in approved only mode", (Algorithm)parameters.getAlgorithm());
            }
            final AsymmetricBlockCipher engine = this.createCipher(false, key, parameters, (SecureRandom)null);
            return new SingleBlockDecryptor<Parameters>(){

                @Override
                public byte[] decryptBlock(byte[] bytes, int offSet, int length) throws InvalidCipherTextException {
                    try {
                        Utils.approveModeCheck(parameters.getAlgorithm());
                        return engine.processBlock(bytes, offSet, length);
                    }
                    catch (org.bouncycastle.crypto.internal.InvalidCipherTextException e) {
                        throw new InvalidCipherTextException(e.getMessage(), e);
                    }
                }

                @Override
                public Parameters getParameters() {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return parameters;
                }

                @Override
                public int getInputSize() {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    if (GuardedAsymmetricOperatorFactory.isRawEngine(engine)) {
                        return engine.getInputBlockSize() + 1;
                    }
                    return engine.getInputBlockSize();
                }

                @Override
                public int getOutputSize() {
                    Utils.approveModeCheck(parameters.getAlgorithm());
                    return engine.getOutputBlockSize();
                }
            };
        }

        @Override
        protected AsymmetricBlockCipher createCipher(boolean forEncryption, AsymmetricKey key, Parameters parameters, SecureRandom random) {
            return ElGamal.createCipher(forEncryption, key, parameters, random);
        }
    }

    public static final class PKCS1v15Parameters
    extends Parameters
    implements WrapParameters {
        PKCS1v15Parameters() {
            super(PKCS1v1_5);
        }
    }

    public static class Parameters
    extends GeneralParameters {
        Parameters(GeneralAlgorithm algorithm) {
            super(algorithm);
        }
    }

    public static final class RawParameters
    extends Parameters {
        RawParameters() {
            super(ALGORITHM);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Variations {
        RAW,
        PKCS1v1_5,
        OAEP;

    }

    public static interface WrapParameters
    extends org.bouncycastle.crypto.Parameters {
    }
}

