/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import org.bouncycastle.crypto.fips.DhKeyGeneratorHelper;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.internal.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.internal.KeyGenerationParameters;
import org.bouncycastle.crypto.internal.params.DhKeyGenerationParameters;
import org.bouncycastle.crypto.internal.params.DhParameters;
import org.bouncycastle.crypto.internal.params.DhPrivateKeyParameters;
import org.bouncycastle.crypto.internal.params.DhPublicKeyParameters;

class DhKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DhKeyGenerationParameters param;

    DhKeyPairGenerator() {
    }

    public void init(KeyGenerationParameters param) {
        this.param = (DhKeyGenerationParameters)param;
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DhKeyGeneratorHelper helper = DhKeyGeneratorHelper.INSTANCE;
        DhParameters dhp = this.param.getParameters();
        BigInteger x = helper.calculatePrivate(dhp, this.param.getRandom());
        BigInteger y = helper.calculatePublic(dhp, x);
        return new AsymmetricCipherKeyPair(new DhPublicKeyParameters(y, dhp), new DhPrivateKeyParameters(x, dhp));
    }
}

