/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.internal.params.DhParameters;
import org.bouncycastle.util.BigIntegers;

class DhKeyGeneratorHelper {
    static final DhKeyGeneratorHelper INSTANCE = new DhKeyGeneratorHelper();
    private static final BigInteger ONE = BigInteger.valueOf(1L);
    private static final BigInteger TWO = BigInteger.valueOf(2L);

    private DhKeyGeneratorHelper() {
    }

    BigInteger calculatePrivate(DhParameters dhParams, SecureRandom random) {
        BigInteger q;
        int limit = dhParams.getL();
        if (limit != 0) {
            return new BigInteger(limit, random).setBit(limit - 1);
        }
        BigInteger min = TWO;
        int m = dhParams.getM();
        if (m != 0) {
            min = ONE.shiftLeft(m - 1);
        }
        if ((q = dhParams.getQ()) == null) {
            q = dhParams.getP();
        }
        BigInteger max = q.subtract(TWO);
        return BigIntegers.createRandomInRange(min, max, random);
    }

    BigInteger calculatePublic(DhParameters dhParams, BigInteger x) {
        return dhParams.getG().modPow(x, dhParams.getP());
    }
}

