/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import java.io.IOException;
import java.math.BigInteger;
import java.util.concurrent.atomic.AtomicBoolean;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.DSAParameter;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDSAKey;
import org.bouncycastle.crypto.asymmetric.DSADomainParameters;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.crypto.internal.Permissions;

public final class AsymmetricDSAPrivateKey
extends AsymmetricDSAKey
implements AsymmetricPrivateKey {
    private final AtomicBoolean hasBeenDestroyed = new AtomicBoolean(false);
    private int hashCode;
    private BigInteger x;

    public AsymmetricDSAPrivateKey(Algorithm algorithm, DSADomainParameters params, BigInteger x) {
        super(algorithm, params);
        this.x = x;
        this.hashCode = this.calculateHashCode();
    }

    public AsymmetricDSAPrivateKey(Algorithm algorithm, byte[] enc) {
        this(algorithm, PrivateKeyInfo.getInstance(enc));
    }

    public AsymmetricDSAPrivateKey(Algorithm algorithm, PrivateKeyInfo privateKeyInfo) {
        super(algorithm, privateKeyInfo.getPrivateKeyAlgorithm());
        this.x = AsymmetricDSAPrivateKey.parsePrivateKey(privateKeyInfo);
        this.hashCode = this.calculateHashCode();
    }

    private static BigInteger parsePrivateKey(PrivateKeyInfo info) {
        try {
            return ASN1Integer.getInstance(info.parsePrivateKey()).getValue();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Unable to parse DSA private key: " + e.getMessage(), e);
        }
    }

    public final Algorithm getAlgorithm() {
        KeyUtils.checkDestroyed(this);
        return super.getAlgorithm();
    }

    public final DSADomainParameters getDomainParameters() {
        KeyUtils.checkDestroyed(this);
        return super.getDomainParameters();
    }

    public final byte[] getEncoded() {
        DSADomainParameters dsaDomainParameters = this.getDomainParameters();
        return KeyUtils.getEncodedPrivateKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_dsa, new DSAParameter(dsaDomainParameters.getP(), dsaDomainParameters.getQ(), dsaDomainParameters.getG())), new ASN1Integer(this.getX()));
    }

    public final BigInteger getX() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        KeyUtils.checkDestroyed(this);
        return this.x;
    }

    public void destroy() {
        this.checkApprovedOnlyModeStatus();
        KeyUtils.checkPermission(Permissions.CanOutputPrivateKey);
        if (!this.hasBeenDestroyed.getAndSet(true)) {
            this.x = null;
            this.hashCode = -1;
            super.zeroize();
        }
    }

    public boolean isDestroyed() {
        this.checkApprovedOnlyModeStatus();
        return this.hasBeenDestroyed.get();
    }

    public int hashCode() {
        return this.hashCode;
    }

    private int calculateHashCode() {
        int result = this.x.hashCode();
        result = 31 * result + this.getDomainParameters().hashCode();
        return result;
    }

    protected void finalize() throws Throwable {
        this.destroy();
        super.finalize();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AsymmetricDSAPrivateKey)) {
            return false;
        }
        AsymmetricDSAPrivateKey other = (AsymmetricDSAPrivateKey)o;
        if (this.isDestroyed() || other.isDestroyed()) {
            return false;
        }
        return this.x.equals(other.x) && this.getDomainParameters().equals(other.getDomainParameters());
    }
}

