/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.system.plugin.release.util;

import java.io.StringWriter;

import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DOMSerializer {

    public static String serializeNode(Node node) throws Exception {
        
  
//        as of xerces 2.9.1, code below failed to serialize a line
//        break between xml decl and root element 'project'. so ...
//        we'll go old school which is deprecated after 2.8.1        
//
//        Transformer t = TransformerFactory.newInstance().newTransformer();
//        t.setOutputProperty(OutputKeys.METHOD, "xml");
//        StringWriter temp = new StringWriter();
//        t.transform(new DOMSource(node), new StreamResult(temp));
        
        OutputFormat format = new OutputFormat();
        format.setEncoding("UTF-8");
        format.setLineSeparator(System.getProperty("line.separator"));
        format.setIndenting(true);
        format.setIndent(2);
        StringWriter temp = new StringWriter();
        XMLSerializer output = new XMLSerializer(temp, format);
        output.serialize((Document)node);
        return temp.toString();
        
    }

}
