/**
 * Copyright 2008 Bluestem Software LLC.  All Rights Reserved.
 * 
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

package org.bluestemsoftware.open.eoa.system.plugin.release;

import java.util.HashSet;
import java.util.Set;

import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.bluestemsoftware.open.eoa.system.plugin.release.util.SCM;

/**
 * Issues an svn status and then svn update command. Note that this is an aggregator plugin
 * which implies that child projects are ignored. The plugin should be executed from working
 * copy root which has trunks defined via svn:externals property. The status and update
 * commands will recurse into trunks defined via externals property.
 * 
 * @aggregator
 * @goal update
 */
public class ReleaseUpdateMojo extends AbstractMojo {

    /**
     * The maven project.
     * 
     * @parameter expression="${project}"
     * @required
     * @readonly
     * @description "the maven project to use"
     */
    private MavenProject project;

    public void execute() throws MojoExecutionException {

        // before updating the version tag, we need to make sure that no
        // uncommitted changes exist. ignore changes to poms which may
        // have been modified, i.e. to manually update dependency versions,
        // and our build batch file which may also need tweaking.

        Set<String> ignore = new HashSet<String>();
        ignore.add("pom.xml");
        ignore.add("build.bat");
        SCM.status(project, getLog(), ignore);

        // update the project's source tree by issuing an scm update
        // command

        SCM.update(project, getLog());

    }

}
