/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory.downloader;

import com.subgraph.orchid.CircuitManager;
import com.subgraph.orchid.ConsensusDocument;
import com.subgraph.orchid.Descriptor;
import com.subgraph.orchid.Directory;
import com.subgraph.orchid.DirectoryCircuit;
import com.subgraph.orchid.DirectoryDownloader;
import com.subgraph.orchid.KeyCertificate;
import com.subgraph.orchid.OpenFailedException;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.RouterDescriptor;
import com.subgraph.orchid.RouterMicrodescriptor;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.circuits.TorInitializationTracker;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.directory.downloader.DirectoryDocumentRequestor;
import com.subgraph.orchid.directory.downloader.DirectoryDownloadTask;
import com.subgraph.orchid.directory.downloader.DirectoryRequestFailedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;

public class DirectoryDownloaderImpl
implements DirectoryDownloader {
    private static final Logger logger = Logger.getLogger(DirectoryDownloaderImpl.class.getName());
    private final TorConfig config;
    private final TorInitializationTracker initializationTracker;
    private CircuitManager circuitManager;
    private boolean isStarted;
    private boolean isStopped;
    private DirectoryDownloadTask downloadTask;
    private Thread downloadTaskThread;

    public DirectoryDownloaderImpl(TorConfig config, TorInitializationTracker initializationTracker) {
        this.config = config;
        this.initializationTracker = initializationTracker;
    }

    public void setCircuitManager(CircuitManager circuitManager) {
        this.circuitManager = circuitManager;
    }

    @Override
    public synchronized void start(Directory directory) {
        if (this.isStarted) {
            logger.warning("Directory downloader already running");
            return;
        }
        if (this.circuitManager == null) {
            throw new IllegalStateException("Must set CircuitManager instance with setCircuitManager() before starting.");
        }
        this.downloadTask = new DirectoryDownloadTask(this.config, directory, this);
        this.downloadTaskThread = new Thread(this.downloadTask);
        this.downloadTaskThread.start();
        this.isStarted = true;
    }

    @Override
    public synchronized void stop() {
        if (!this.isStarted || this.isStopped) {
            return;
        }
        this.downloadTask.stop();
        this.downloadTaskThread.interrupt();
    }

    @Override
    public RouterDescriptor downloadBridgeDescriptor(Router bridge) throws DirectoryRequestFailedException {
        DirectoryDocumentRequestor requestor = new DirectoryDocumentRequestor(this.openBridgeCircuit(bridge));
        return requestor.downloadBridgeDescriptor(bridge);
    }

    @Override
    public ConsensusDocument downloadCurrentConsensus(boolean useMicrodescriptors) throws DirectoryRequestFailedException {
        return this.downloadCurrentConsensus(useMicrodescriptors, this.openCircuit());
    }

    @Override
    public ConsensusDocument downloadCurrentConsensus(boolean useMicrodescriptors, DirectoryCircuit circuit) throws DirectoryRequestFailedException {
        DirectoryDocumentRequestor requestor = new DirectoryDocumentRequestor(circuit, this.initializationTracker);
        return requestor.downloadCurrentConsensus(useMicrodescriptors);
    }

    @Override
    public List<KeyCertificate> downloadKeyCertificates(Set<ConsensusDocument.RequiredCertificate> required) throws DirectoryRequestFailedException {
        return this.downloadKeyCertificates(required, this.openCircuit());
    }

    @Override
    public List<KeyCertificate> downloadKeyCertificates(Set<ConsensusDocument.RequiredCertificate> required, DirectoryCircuit circuit) throws DirectoryRequestFailedException {
        DirectoryDocumentRequestor requestor = new DirectoryDocumentRequestor(circuit, this.initializationTracker);
        return requestor.downloadKeyCertificates(required);
    }

    @Override
    public List<RouterDescriptor> downloadRouterDescriptors(Set<HexDigest> fingerprints) throws DirectoryRequestFailedException {
        return this.downloadRouterDescriptors(fingerprints, this.openCircuit());
    }

    @Override
    public List<RouterDescriptor> downloadRouterDescriptors(Set<HexDigest> fingerprints, DirectoryCircuit circuit) throws DirectoryRequestFailedException {
        DirectoryDocumentRequestor requestor = new DirectoryDocumentRequestor(circuit, this.initializationTracker);
        List<RouterDescriptor> ds = requestor.downloadRouterDescriptors(fingerprints);
        return this.removeUnrequestedDescriptors(fingerprints, ds);
    }

    @Override
    public List<RouterMicrodescriptor> downloadRouterMicrodescriptors(Set<HexDigest> fingerprints) throws DirectoryRequestFailedException {
        return this.downloadRouterMicrodescriptors(fingerprints, this.openCircuit());
    }

    @Override
    public List<RouterMicrodescriptor> downloadRouterMicrodescriptors(Set<HexDigest> fingerprints, DirectoryCircuit circuit) throws DirectoryRequestFailedException {
        DirectoryDocumentRequestor requestor = new DirectoryDocumentRequestor(circuit, this.initializationTracker);
        List<RouterMicrodescriptor> ds = requestor.downloadRouterMicrodescriptors(fingerprints);
        return this.removeUnrequestedDescriptors(fingerprints, ds);
    }

    private <T extends Descriptor> List<T> removeUnrequestedDescriptors(Set<HexDigest> requested, List<T> received) {
        ArrayList<Descriptor> result = new ArrayList<Descriptor>();
        int unrequestedCount = 0;
        for (Descriptor d : received) {
            if (requested.contains(d.getDescriptorDigest())) {
                result.add(d);
                continue;
            }
            ++unrequestedCount;
        }
        if (unrequestedCount > 0) {
            logger.warning("Discarding " + unrequestedCount + " received descriptor(s) with fingerprints that did not match requested descriptors");
        }
        return result;
    }

    private DirectoryCircuit openCircuit() throws DirectoryRequestFailedException {
        try {
            return this.circuitManager.openDirectoryCircuit();
        }
        catch (OpenFailedException e) {
            throw new DirectoryRequestFailedException("Failed to open directory circuit", e);
        }
    }

    private DirectoryCircuit openBridgeCircuit(Router bridge) throws DirectoryRequestFailedException {
        try {
            return this.circuitManager.openDirectoryCircuitTo(Arrays.asList(bridge));
        }
        catch (OpenFailedException e) {
            throw new DirectoryRequestFailedException("Failed to open directory circuit to bridge " + bridge, e);
        }
    }
}

