/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory;

import com.subgraph.orchid.Directory;
import com.subgraph.orchid.GuardEntry;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.directory.StateFile;
import java.util.Date;

public class GuardEntryImpl
implements GuardEntry {
    private static final String NL = System.getProperty("line.separator");
    private final Directory directory;
    private final StateFile stateFile;
    private final String nickname;
    private final String identity;
    private final Object lock = new Object();
    private String version;
    private Date createdTime;
    private boolean isAdded;
    private Date unlistedSince;
    private Date downSince;
    private Date lastConnect;

    GuardEntryImpl(Directory directory, StateFile stateFile, String nickname, String identity) {
        this.directory = directory;
        this.stateFile = stateFile;
        this.nickname = nickname;
        this.identity = identity;
    }

    void setAddedFlag() {
        this.isAdded = true;
    }

    void setVersion(String version) {
        this.version = version;
    }

    void setCreatedTime(Date date) {
        this.createdTime = date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setUnlistedSince(Date date) {
        Object object = this.lock;
        synchronized (object) {
            this.unlistedSince = date;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setDownSince(Date downSince, Date lastTried) {
        Object object = this.lock;
        synchronized (object) {
            this.downSince = downSince;
            this.lastConnect = lastTried;
        }
    }

    @Override
    public boolean isAdded() {
        return this.isAdded;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void markAsDown() {
        Object object = this.lock;
        synchronized (object) {
            Date now = new Date();
            if (this.downSince == null) {
                this.downSince = now;
            } else {
                this.lastConnect = now;
            }
        }
        if (this.isAdded) {
            this.stateFile.writeFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearDownSince() {
        Object object = this.lock;
        synchronized (object) {
            this.downSince = null;
            this.lastConnect = null;
        }
        if (this.isAdded) {
            this.stateFile.writeFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearUnlistedSince() {
        Object object = this.lock;
        synchronized (object) {
            this.unlistedSince = null;
        }
        if (this.isAdded) {
            this.stateFile.writeFile();
        }
    }

    @Override
    public String getNickname() {
        return this.nickname;
    }

    @Override
    public String getIdentity() {
        return this.identity;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getCreatedTime() {
        Object object = this.lock;
        synchronized (object) {
            return this.dup(this.createdTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getDownSince() {
        Object object = this.lock;
        synchronized (object) {
            return this.dup(this.downSince);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getLastConnectAttempt() {
        Object object = this.lock;
        synchronized (object) {
            return this.dup(this.lastConnect);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date getUnlistedSince() {
        Object object = this.lock;
        synchronized (object) {
            return this.dup(this.unlistedSince);
        }
    }

    private Date dup(Date date) {
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String writeToString() {
        StringBuilder sb = new StringBuilder();
        Object object = this.lock;
        synchronized (object) {
            this.appendEntryGuardLine(sb);
            this.appendEntryGuardAddedBy(sb);
            if (this.downSince != null) {
                this.appendEntryGuardDownSince(sb);
            }
            if (this.unlistedSince != null) {
                this.appendEntryGuardUnlistedSince(sb);
            }
        }
        return sb.toString();
    }

    private void appendEntryGuardLine(StringBuilder sb) {
        sb.append("EntryGuard");
        sb.append(" ");
        sb.append(this.nickname);
        sb.append(" ");
        sb.append(this.identity);
        sb.append(NL);
    }

    private void appendEntryGuardAddedBy(StringBuilder sb) {
        sb.append("EntryGuardAddedBy");
        sb.append(" ");
        sb.append(this.identity);
        sb.append(" ");
        sb.append(this.version);
        sb.append(" ");
        sb.append(this.formatDate(this.createdTime));
        sb.append(NL);
    }

    private void appendEntryGuardDownSince(StringBuilder sb) {
        if (this.downSince == null) {
            return;
        }
        sb.append("EntryGuardDownSince");
        sb.append(" ");
        sb.append(this.formatDate(this.downSince));
        if (this.lastConnect != null) {
            sb.append(" ");
            sb.append(this.formatDate(this.lastConnect));
        }
        sb.append(NL);
    }

    private void appendEntryGuardUnlistedSince(StringBuilder sb) {
        if (this.unlistedSince == null) {
            return;
        }
        sb.append("EntryGuardUnlistedSince");
        sb.append(" ");
        sb.append(this.formatDate(this.unlistedSince));
        sb.append(NL);
    }

    private String formatDate(Date date) {
        return this.stateFile.formatDate(date);
    }

    @Override
    public Router getRouterForEntry() {
        HexDigest id = HexDigest.createFromString(this.identity);
        return this.directory.getRouterByIdentity(id);
    }

    @Override
    public boolean testCurrentlyUsable() {
        boolean isUsable;
        Router router = this.getRouterForEntry();
        boolean bl = isUsable = router != null && router.isValid() && router.isPossibleGuard() && router.isRunning();
        if (isUsable) {
            this.markUsable();
            return true;
        }
        this.markUnusable();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markUsable() {
        Object object = this.lock;
        synchronized (object) {
            if (this.unlistedSince != null) {
                this.unlistedSince = null;
                if (this.isAdded) {
                    this.stateFile.writeFile();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void markUnusable() {
        Object object = this.lock;
        synchronized (object) {
            if (this.unlistedSince == null) {
                this.unlistedSince = new Date();
                if (this.isAdded) {
                    this.stateFile.writeFile();
                }
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.identity == null ? 0 : this.identity.hashCode());
        result = 31 * result + (this.nickname == null ? 0 : this.nickname.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GuardEntryImpl other = (GuardEntryImpl)obj;
        if (this.identity == null ? other.identity != null : !this.identity.equals(other.identity)) {
            return false;
        }
        return !(this.nickname == null ? other.nickname != null : !this.nickname.equals(other.nickname));
    }
}

