/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.directory;

import com.subgraph.orchid.Descriptor;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.misc.GuardedBy;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DescriptorCacheData<T extends Descriptor> {
    private static final long EXPIRY_PERIOD = 604800000L;
    @GuardedBy(value="this")
    private final Map<HexDigest, T> descriptorMap = new HashMap<HexDigest, T>();
    @GuardedBy(value="this")
    private final List<T> allDescriptors = new ArrayList<T>();

    synchronized T findByDigest(HexDigest digest) {
        return (T)((Descriptor)this.descriptorMap.get(digest));
    }

    synchronized List<T> getAllDescriptors() {
        return new ArrayList<T>(this.allDescriptors);
    }

    synchronized boolean addDescriptor(T d) {
        if (this.descriptorMap.containsKey(d.getDescriptorDigest())) {
            return false;
        }
        this.descriptorMap.put(d.getDescriptorDigest(), d);
        this.allDescriptors.add(d);
        return true;
    }

    synchronized void clear() {
        this.descriptorMap.clear();
        this.allDescriptors.clear();
    }

    synchronized int cleanExpired() {
        Set<T> expired = this.getExpiredSet();
        if (expired.isEmpty()) {
            return 0;
        }
        this.clear();
        int dropped = 0;
        for (Descriptor d : this.allDescriptors) {
            if (expired.contains(d)) {
                dropped += d.getBodyLength();
                continue;
            }
            this.addDescriptor(d);
        }
        return dropped;
    }

    private Set<T> getExpiredSet() {
        long now = System.currentTimeMillis();
        HashSet<Descriptor> expired = new HashSet<Descriptor>();
        for (Descriptor d : this.allDescriptors) {
            if (!this.isExpired(d, now)) continue;
            expired.add(d);
        }
        return expired;
    }

    private boolean isExpired(T d, long now) {
        return d.getLastListed() != 0L && d.getLastListed() < now - 604800000L;
    }
}

