/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.data.exitpolicy;

import com.subgraph.orchid.TorParsingException;
import com.subgraph.orchid.data.IPv4Address;
import com.subgraph.orchid.data.exitpolicy.Network;
import com.subgraph.orchid.data.exitpolicy.PortRange;

public class PolicyRule {
    private static final String WILDCARD = "*";
    private final boolean isAcceptRule;
    private final Network network;
    private final PortRange portRange;

    public static PolicyRule createAcceptFromString(String rule) {
        return PolicyRule.createRule(rule, true);
    }

    public static PolicyRule createRejectFromString(String rule) {
        return PolicyRule.createRule(rule, false);
    }

    private static PolicyRule createRule(String rule, boolean isAccept) {
        String[] args = rule.split(":");
        if (args.length != 2) {
            throw new TorParsingException("Could not parse exit policy rule: " + rule);
        }
        return new PolicyRule(PolicyRule.parseNetwork(args[0]), PolicyRule.parsePortRange(args[1]), isAccept);
    }

    private static Network parseNetwork(String network) {
        if (network.equals(WILDCARD)) {
            return Network.ALL_ADDRESSES;
        }
        return Network.createFromString(network);
    }

    private static PortRange parsePortRange(String portRange) {
        if (portRange.equals(WILDCARD)) {
            return PortRange.ALL_PORTS;
        }
        return PortRange.createFromString(portRange);
    }

    private PolicyRule(Network network, PortRange portRange, boolean isAccept) {
        this.network = network;
        this.portRange = portRange;
        this.isAcceptRule = isAccept;
    }

    public boolean matchesPort(int port) {
        if (!this.network.equals(Network.ALL_ADDRESSES)) {
            return false;
        }
        return this.portRange.rangeContains(port);
    }

    public boolean matchesDestination(IPv4Address address, int port) {
        if (!this.network.contains(address)) {
            return false;
        }
        return this.portRange.rangeContains(port);
    }

    public boolean isAcceptRule() {
        return this.isAcceptRule;
    }

    public String toString() {
        String keyword = this.isAcceptRule ? "accept" : "reject";
        return keyword + " " + this.network + ":" + this.portRange;
    }
}

