/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.data;

import com.subgraph.orchid.Tor;
import com.subgraph.orchid.TorException;
import com.subgraph.orchid.crypto.TorMessageDigest;
import com.subgraph.orchid.data.Base32;
import com.subgraph.orchid.encoders.Base64;
import com.subgraph.orchid.encoders.Hex;
import java.util.Arrays;
import java.util.List;

public class HexDigest {
    private final byte[] digestBytes;
    private final boolean isDigest256;

    public static HexDigest createFromStringList(List<String> strings) {
        StringBuilder builder = new StringBuilder();
        for (String chunk : strings) {
            builder.append(chunk);
        }
        return HexDigest.createFromString(builder.toString());
    }

    public static HexDigest createFromBase32String(String b32) {
        return new HexDigest(Base32.base32Decode(b32));
    }

    public static HexDigest createFromString(String fingerprint) {
        String[] parts = fingerprint.split(" ");
        if (parts.length > 1) {
            return HexDigest.createFromStringList(Arrays.asList(parts));
        }
        byte[] digestData = Hex.decode(fingerprint);
        return new HexDigest(digestData);
    }

    public static HexDigest createFromDigestBytes(byte[] data) {
        return new HexDigest(data);
    }

    public static HexDigest createDigestForData(byte[] data) {
        TorMessageDigest digest = new TorMessageDigest();
        digest.update(data);
        return new HexDigest(digest.getDigestBytes());
    }

    private HexDigest(byte[] data) {
        if (data.length != 20 && data.length != 32) {
            throw new TorException("Digest data is not the correct length " + data.length + " != (" + 20 + " or " + 32 + ")");
        }
        this.digestBytes = new byte[data.length];
        this.isDigest256 = this.digestBytes.length == 32;
        System.arraycopy(data, 0, this.digestBytes, 0, data.length);
    }

    public boolean isDigest256() {
        return this.isDigest256;
    }

    public byte[] getRawBytes() {
        return Arrays.copyOf(this.digestBytes, this.digestBytes.length);
    }

    public String toString() {
        return new String(Hex.encode(this.digestBytes));
    }

    public String toSpacedString() {
        String original = this.toString();
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < original.length(); ++i) {
            if (i > 0 && i % 4 == 0) {
                builder.append(' ');
            }
            builder.append(original.charAt(i));
        }
        return builder.toString();
    }

    public String toBase32() {
        return Base32.base32Encode(this.digestBytes);
    }

    public String toBase64(boolean stripTrailingEquals) {
        String b64 = new String(Base64.encode(this.digestBytes), Tor.getDefaultCharset());
        if (stripTrailingEquals) {
            return this.stripTrailingEquals(b64);
        }
        return b64;
    }

    private String stripTrailingEquals(String s) {
        int idx;
        for (idx = s.length(); idx > 0 && s.charAt(idx - 1) == '='; --idx) {
        }
        return s.substring(0, idx);
    }

    public boolean equals(Object o) {
        if (!(o instanceof HexDigest)) {
            return false;
        }
        HexDigest other = (HexDigest)o;
        return Arrays.equals(other.digestBytes, this.digestBytes);
    }

    public int hashCode() {
        int hash = 0;
        for (int i = 0; i < 4; ++i) {
            hash <<= 8;
            hash |= this.digestBytes[i] & 0xFF;
        }
        return hash;
    }
}

