/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.crypto;

import com.subgraph.orchid.TorException;
import com.subgraph.orchid.crypto.HybridEncryption;
import com.subgraph.orchid.crypto.TorKeyAgreement;
import com.subgraph.orchid.crypto.TorKeyDerivation;
import com.subgraph.orchid.crypto.TorPublicKey;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import java.util.Arrays;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;

public class TorTapKeyAgreement
implements TorKeyAgreement {
    public static final int DH_LEN = 128;
    public static final int DH_SEC_LEN = 40;
    private static final BigInteger P1024 = new BigInteger("00FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE65381FFFFFFFFFFFFFFFF", 16);
    private static final BigInteger G = new BigInteger("2");
    private static final int PRIVATE_KEY_SIZE = 320;
    private static final DHParameterSpec DH_PARAMETER_SPEC = new DHParameterSpec(P1024, G, 320);
    private final KeyAgreement dh;
    private final KeyPair keyPair = this.generateKeyPair();
    private final TorPublicKey onionKey;

    public TorTapKeyAgreement(TorPublicKey onionKey) {
        this.dh = this.createDH();
        this.onionKey = onionKey;
    }

    public TorTapKeyAgreement() {
        this(null);
    }

    public BigInteger getPublicValue() {
        DHPublicKey pubKey = (DHPublicKey)this.keyPair.getPublic();
        return pubKey.getY();
    }

    public byte[] getPublicKeyBytes() {
        byte[] output = new byte[128];
        byte[] yBytes = this.getPublicValue().toByteArray();
        if (yBytes[0] == 0 && yBytes.length == 129) {
            System.arraycopy(yBytes, 1, output, 0, 128);
        } else if (yBytes.length <= 128) {
            int offset = 128 - yBytes.length;
            System.arraycopy(yBytes, 0, output, offset, yBytes.length);
        } else {
            throw new IllegalStateException("Public value is longer than DH_LEN but not because of sign bit");
        }
        return output;
    }

    public static boolean isValidPublicValue(BigInteger publicValue) {
        if (publicValue.signum() < 1 || publicValue.equals(BigInteger.ONE)) {
            return false;
        }
        return publicValue.compareTo(P1024.subtract(BigInteger.ONE)) < 0;
    }

    public byte[] getSharedSecret(BigInteger otherPublic) {
        try {
            KeyFactory factory = KeyFactory.getInstance("DH");
            DHPublicKeySpec pub = new DHPublicKeySpec(otherPublic, P1024, G);
            PublicKey key = factory.generatePublic(pub);
            this.dh.doPhase(key, true);
            return this.dh.generateSecret();
        }
        catch (GeneralSecurityException e) {
            throw new TorException(e);
        }
    }

    private final KeyAgreement createDH() {
        try {
            KeyAgreement dh = KeyAgreement.getInstance("DH");
            dh.init(this.keyPair.getPrivate());
            return dh;
        }
        catch (GeneralSecurityException e) {
            throw new TorException(e);
        }
    }

    private final KeyPair generateKeyPair() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("DH");
            keyGen.initialize(DH_PARAMETER_SPEC);
            return keyGen.generateKeyPair();
        }
        catch (GeneralSecurityException e) {
            throw new TorException(e);
        }
    }

    @Override
    public byte[] createOnionSkin() {
        byte[] yBytes = this.getPublicKeyBytes();
        HybridEncryption hybrid = new HybridEncryption();
        return hybrid.encrypt(yBytes, this.onionKey);
    }

    @Override
    public boolean deriveKeysFromHandshakeResponse(byte[] handshakeResponse, byte[] keyMaterialOut, byte[] verifyHashOut) {
        ByteBuffer bb = ByteBuffer.wrap(handshakeResponse);
        byte[] dhPublic = new byte[128];
        byte[] keyHash = new byte[20];
        bb.get(dhPublic);
        bb.get(keyHash);
        BigInteger peerPublic = new BigInteger(1, dhPublic);
        return this.deriveKeysFromDHPublicAndHash(peerPublic, keyHash, keyMaterialOut, verifyHashOut);
    }

    public boolean deriveKeysFromDHPublicAndHash(BigInteger peerPublic, byte[] keyHash, byte[] keyMaterialOut, byte[] verifyHashOut) {
        if (!TorTapKeyAgreement.isValidPublicValue(peerPublic)) {
            throw new TorException("Illegal DH public value");
        }
        byte[] sharedSecret = this.getSharedSecret(peerPublic);
        TorKeyDerivation kdf = new TorKeyDerivation(sharedSecret);
        kdf.deriveKeys(keyMaterialOut, verifyHashOut);
        return Arrays.equals(verifyHashOut, keyHash);
    }
}

