/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.crypto;

import com.subgraph.orchid.crypto.TorKeyAgreement;
import com.subgraph.orchid.crypto.TorKeyDerivation;
import com.subgraph.orchid.crypto.TorRandom;
import java.nio.ByteBuffer;
import java.util.Arrays;

public class TorCreateFastKeyAgreement
implements TorKeyAgreement {
    private final byte[] xValue;
    private byte[] yValue;

    public TorCreateFastKeyAgreement() {
        TorRandom random = new TorRandom();
        this.xValue = random.getBytes(20);
    }

    public byte[] getPublicValue() {
        return Arrays.copyOf(this.xValue, this.xValue.length);
    }

    public void setOtherValue(byte[] yValue) {
        if (yValue == null || yValue.length != 20) {
            throw new IllegalArgumentException();
        }
        this.yValue = Arrays.copyOf(yValue, yValue.length);
    }

    public byte[] getDerivedValue() {
        if (this.yValue == null) {
            throw new IllegalStateException("Must call setOtherValue() first");
        }
        byte[] result = new byte[40];
        System.arraycopy(this.xValue, 0, result, 0, 20);
        System.arraycopy(this.yValue, 0, result, 20, 20);
        return result;
    }

    @Override
    public byte[] createOnionSkin() {
        return this.getPublicValue();
    }

    @Override
    public boolean deriveKeysFromHandshakeResponse(byte[] handshakeResponse, byte[] keyMaterialOut, byte[] verifyHashOut) {
        ByteBuffer bb = ByteBuffer.wrap(handshakeResponse);
        byte[] peerValue = new byte[20];
        byte[] keyHash = new byte[20];
        bb.get(peerValue);
        bb.get(keyHash);
        this.setOtherValue(peerValue);
        byte[] seed = this.getDerivedValue();
        TorKeyDerivation kdf = new TorKeyDerivation(seed);
        kdf.deriveKeys(keyMaterialOut, verifyHashOut);
        return Arrays.equals(verifyHashOut, keyHash);
    }
}

