/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.crypto;

public class Curve25519 {
    final int CRYPTO_BYTES = 32;
    final int CRYPTO_SCALARBYTES = 32;
    static byte[] basev = new byte[]{9, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static int[] minusp = new int[]{19, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 128};

    public static int crypto_scalarmult_base(byte[] q, byte[] n) {
        byte[] basevp = basev;
        return Curve25519.crypto_scalarmult(q, n, basevp);
    }

    static void add(int[] outv, int outvoffset, int[] a, int aoffset, int[] b, int boffset) {
        int u = 0;
        for (int j = 0; j < 31; ++j) {
            outv[outvoffset + j] = (u += a[aoffset + j] + b[boffset + j]) & 0xFF;
            u >>>= 8;
        }
        outv[outvoffset + 31] = u += a[aoffset + 31] + b[boffset + 31];
    }

    static void sub(int[] outv, int outvoffset, int[] a, int aoffset, int[] b, int boffset) {
        int u = 218;
        for (int j = 0; j < 31; ++j) {
            outv[outvoffset + j] = (u += a[aoffset + j] + 65280 - b[boffset + j]) & 0xFF;
            u >>>= 8;
        }
        outv[outvoffset + 31] = u += a[aoffset + 31] - b[boffset + 31];
    }

    static void squeeze(int[] a, int aoffset) {
        int j;
        int u = 0;
        for (j = 0; j < 31; ++j) {
            a[aoffset + j] = (u += a[aoffset + j]) & 0xFF;
            u >>>= 8;
        }
        a[aoffset + 31] = (u += a[aoffset + 31]) & 0x7F;
        u = 19 * (u >>> 7);
        for (j = 0; j < 31; ++j) {
            a[aoffset + j] = (u += a[aoffset + j]) & 0xFF;
            u >>>= 8;
        }
        a[aoffset + 31] = u += a[aoffset + 31];
    }

    static void freeze(int[] a, int aoffset) {
        int[] aorig = new int[32];
        for (int j = 0; j < 32; ++j) {
            aorig[j] = a[aoffset + j];
        }
        int[] minuspp = minusp;
        Curve25519.add(a, 0, a, 0, minuspp, 0);
        int negative = -(a[aoffset + 31] >>> 7 & 1);
        for (int j = 0; j < 32; ++j) {
            int n = aoffset + j;
            a[n] = a[n] ^ negative & (aorig[j] ^ a[aoffset + j]);
        }
    }

    static void mult(int[] outv, int outvoffset, int[] a, int aoffset, int[] b, int boffset) {
        for (int i = 0; i < 32; ++i) {
            int j;
            int u = 0;
            for (j = 0; j <= i; ++j) {
                u += a[aoffset + j] * b[boffset + i - j];
            }
            for (j = i + 1; j < 32; ++j) {
                u += 38 * a[aoffset + j] * b[boffset + i + 32 - j];
            }
            outv[outvoffset + i] = u;
        }
        Curve25519.squeeze(outv, outvoffset);
    }

    static void mult121665(int[] outv, int[] a) {
        int j;
        int u = 0;
        for (j = 0; j < 31; ++j) {
            outv[j] = (u += 121665 * a[j]) & 0xFF;
            u >>>= 8;
        }
        outv[31] = (u += 121665 * a[31]) & 0x7F;
        u = 19 * (u >>> 7);
        for (j = 0; j < 31; ++j) {
            outv[j] = (u += outv[j]) & 0xFF;
            u >>>= 8;
        }
        outv[j] = u += outv[j];
    }

    static void square(int[] outv, int outvoffset, int[] a, int aoffset) {
        for (int i = 0; i < 32; ++i) {
            int j;
            int u = 0;
            for (j = 0; j < i - j; ++j) {
                u += a[aoffset + j] * a[aoffset + i - j];
            }
            for (j = i + 1; j < i + 32 - j; ++j) {
                u += 38 * a[aoffset + j] * a[aoffset + i + 32 - j];
            }
            u *= 2;
            if ((i & 1) == 0) {
                u += a[aoffset + i / 2] * a[aoffset + i / 2];
                u += 38 * a[aoffset + i / 2 + 16] * a[aoffset + i / 2 + 16];
            }
            outv[outvoffset + i] = u;
        }
        Curve25519.squeeze(outv, outvoffset);
    }

    static void select(int[] p, int[] q, int[] r, int[] s, int b) {
        int bminus1 = b - 1;
        for (int j = 0; j < 64; ++j) {
            int t = bminus1 & (r[j] ^ s[j]);
            p[j] = s[j] ^ t;
            q[j] = r[j] ^ t;
        }
    }

    static void mainloop(int[] work, byte[] e) {
        int j;
        int[] xzm1 = new int[64];
        int[] xzm = new int[64];
        int[] xzmb = new int[64];
        int[] xzm1b = new int[64];
        int[] xznb = new int[64];
        int[] xzn1b = new int[64];
        int[] a0 = new int[64];
        int[] a1 = new int[64];
        int[] b0 = new int[64];
        int[] b1 = new int[64];
        int[] c1 = new int[64];
        int[] r = new int[32];
        int[] s = new int[32];
        int[] t = new int[32];
        int[] u = new int[32];
        for (j = 0; j < 32; ++j) {
            xzm1[j] = work[j];
        }
        xzm1[32] = 1;
        for (j = 33; j < 64; ++j) {
            xzm1[j] = 0;
        }
        xzm[0] = 1;
        for (j = 1; j < 64; ++j) {
            xzm[j] = 0;
        }
        int[] xzmbp = xzmb;
        int[] a0p = a0;
        int[] xzm1bp = xzm1b;
        int[] a1p = a1;
        int[] b0p = b0;
        int[] b1p = b1;
        int[] c1p = c1;
        int[] xznbp = xznb;
        int[] up = u;
        int[] xzn1bp = xzn1b;
        int[] workp = work;
        int[] sp = s;
        int[] rp = r;
        for (int pos = 254; pos >= 0; --pos) {
            int b = (e[pos / 8] & 0xFF) >>> (pos & 7);
            Curve25519.select(xzmb, xzm1b, xzm, xzm1, b &= 1);
            Curve25519.add(a0, 0, xzmb, 0, xzmbp, 32);
            Curve25519.sub(a0p, 32, xzmb, 0, xzmbp, 32);
            Curve25519.add(a1, 0, xzm1b, 0, xzm1bp, 32);
            Curve25519.sub(a1p, 32, xzm1b, 0, xzm1bp, 32);
            Curve25519.square(b0p, 0, a0p, 0);
            Curve25519.square(b0p, 32, a0p, 32);
            Curve25519.mult(b1p, 0, a1p, 0, a0p, 32);
            Curve25519.mult(b1p, 32, a1p, 32, a0p, 0);
            Curve25519.add(c1, 0, b1, 0, b1p, 32);
            Curve25519.sub(c1p, 32, b1, 0, b1p, 32);
            Curve25519.square(rp, 0, c1p, 32);
            Curve25519.sub(sp, 0, b0, 0, b0p, 32);
            Curve25519.mult121665(t, s);
            Curve25519.add(u, 0, t, 0, b0p, 0);
            Curve25519.mult(xznbp, 0, b0p, 0, b0p, 32);
            Curve25519.mult(xznbp, 32, sp, 0, up, 0);
            Curve25519.square(xzn1bp, 0, c1p, 0);
            Curve25519.mult(xzn1bp, 32, rp, 0, workp, 0);
            Curve25519.select(xzm, xzm1, xznb, xzn1b, b);
        }
        for (int j2 = 0; j2 < 64; ++j2) {
            work[j2] = xzm[j2];
        }
    }

    static void recip(int[] outv, int outvoffset, int[] z, int zoffset) {
        int i;
        int[] z2 = new int[32];
        int[] z9 = new int[32];
        int[] z11 = new int[32];
        int[] z2_5_0 = new int[32];
        int[] z2_10_0 = new int[32];
        int[] z2_20_0 = new int[32];
        int[] z2_50_0 = new int[32];
        int[] z2_100_0 = new int[32];
        int[] t0 = new int[32];
        int[] t1 = new int[32];
        int[] z2p = z2;
        Curve25519.square(z2p, 0, z, zoffset);
        Curve25519.square(t1, 0, z2, 0);
        Curve25519.square(t0, 0, t1, 0);
        int[] z9p = z9;
        int[] t0p = t0;
        Curve25519.mult(z9p, 0, t0p, 0, z, zoffset);
        Curve25519.mult(z11, 0, z9, 0, z2, 0);
        Curve25519.square(t0, 0, z11, 0);
        Curve25519.mult(z2_5_0, 0, t0, 0, z9, 0);
        Curve25519.square(t0, 0, z2_5_0, 0);
        Curve25519.square(t1, 0, t0, 0);
        Curve25519.square(t0, 0, t1, 0);
        Curve25519.square(t1, 0, t0, 0);
        Curve25519.square(t0, 0, t1, 0);
        Curve25519.mult(z2_10_0, 0, t0, 0, z2_5_0, 0);
        Curve25519.square(t0, 0, z2_10_0, 0);
        Curve25519.square(t1, 0, t0, 0);
        for (i = 2; i < 10; i += 2) {
            Curve25519.square(t0, 0, t1, 0);
            Curve25519.square(t1, 0, t0, 0);
        }
        Curve25519.mult(z2_20_0, 0, t1, 0, z2_10_0, 0);
        Curve25519.square(t0, 0, z2_20_0, 0);
        Curve25519.square(t1, 0, t0, 0);
        for (i = 2; i < 20; i += 2) {
            Curve25519.square(t0, 0, t1, 0);
            Curve25519.square(t1, 0, t0, 0);
        }
        Curve25519.mult(t0, 0, t1, 0, z2_20_0, 0);
        Curve25519.square(t1, 0, t0, 0);
        Curve25519.square(t0, 0, t1, 0);
        for (i = 2; i < 10; i += 2) {
            Curve25519.square(t1, 0, t0, 0);
            Curve25519.square(t0, 0, t1, 0);
        }
        Curve25519.mult(z2_50_0, 0, t0, 0, z2_10_0, 0);
        Curve25519.square(t0, 0, z2_50_0, 0);
        Curve25519.square(t1, 0, t0, 0);
        for (i = 2; i < 50; i += 2) {
            Curve25519.square(t0, 0, t1, 0);
            Curve25519.square(t1, 0, t0, 0);
        }
        Curve25519.mult(z2_100_0, 0, t1, 0, z2_50_0, 0);
        Curve25519.square(t1, 0, z2_100_0, 0);
        Curve25519.square(t0, 0, t1, 0);
        for (i = 2; i < 100; i += 2) {
            Curve25519.square(t1, 0, t0, 0);
            Curve25519.square(t0, 0, t1, 0);
        }
        Curve25519.mult(t1, 0, t0, 0, z2_100_0, 0);
        Curve25519.square(t0, 0, t1, 0);
        Curve25519.square(t1, 0, t0, 0);
        for (i = 2; i < 50; i += 2) {
            Curve25519.square(t0, 0, t1, 0);
            Curve25519.square(t1, 0, t0, 0);
        }
        Curve25519.mult(t0, 0, t1, 0, z2_50_0, 0);
        Curve25519.square(t1, 0, t0, 0);
        Curve25519.square(t0, 0, t1, 0);
        Curve25519.square(t1, 0, t0, 0);
        Curve25519.square(t0, 0, t1, 0);
        Curve25519.square(t1, 0, t0, 0);
        int[] t1p = t1;
        int[] z11p = z11;
        Curve25519.mult(outv, outvoffset, t1p, 0, z11p, 0);
    }

    public static int crypto_scalarmult(byte[] q, byte[] n, byte[] p) {
        int i;
        int[] work = new int[96];
        byte[] e = new byte[32];
        for (i = 0; i < 32; ++i) {
            e[i] = n[i];
        }
        e[0] = (byte)(e[0] & 0xF8);
        e[31] = (byte)(e[31] & 0x7F);
        e[31] = (byte)(e[31] | 0x40);
        for (i = 0; i < 32; ++i) {
            work[i] = p[i] & 0xFF;
        }
        Curve25519.mainloop(work, e);
        Curve25519.recip(work, 32, work, 32);
        Curve25519.mult(work, 64, work, 0, work, 32);
        Curve25519.freeze(work, 64);
        for (i = 0; i < 32; ++i) {
            q[i] = (byte)work[64 + i];
        }
        return 0;
    }
}

