/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.config;

import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.config.TorConfigBridgeLine;
import com.subgraph.orchid.config.TorConfigHSAuth;
import com.subgraph.orchid.config.TorConfigInterval;
import com.subgraph.orchid.config.TorConfigParser;
import com.subgraph.orchid.data.HexDigest;
import com.subgraph.orchid.data.IPv4Address;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;

public class TorConfigProxy
implements InvocationHandler {
    private final Map<String, Object> configValues = new HashMap<String, Object>();
    private final List<TorConfigBridgeLine> bridges = new ArrayList<TorConfigBridgeLine>();
    private final TorConfigParser parser;

    public TorConfigProxy() {
        this.configValues.put("Bridges", this.bridges);
        this.parser = new TorConfigParser();
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (method.getName().startsWith("set")) {
            this.invokeSetMethod(method, args);
            return null;
        }
        if (method.getName().startsWith("get")) {
            if (args == null) {
                return this.invokeGetMethod(method);
            }
            return this.invokeGetMethodWithArgs(method, args);
        }
        if (method.getName().startsWith("add")) {
            this.invokeAddMethod(method, args);
            return null;
        }
        throw new IllegalArgumentException();
    }

    void invokeSetMethod(Method method, Object[] args) {
        String name = this.getVariableNameForMethod(method);
        TorConfig.ConfigVar annotation = this.getAnnotationForVariable(name);
        if (annotation != null && annotation.type() == TorConfig.ConfigVarType.INTERVAL) {
            this.setIntervalValue(name, args);
        } else {
            this.configValues.put(name, args[0]);
        }
    }

    private void setIntervalValue(String varName, Object[] args) {
        if (!(args[0] instanceof Long) || !(args[1] instanceof TimeUnit)) {
            throw new IllegalArgumentException();
        }
        long time = (Long)args[0];
        TimeUnit unit = (TimeUnit)((Object)args[1]);
        TorConfigInterval interval = new TorConfigInterval(time, unit);
        this.configValues.put(varName, interval);
    }

    private Object invokeGetMethodWithArgs(Method method, Object[] args) {
        String varName = this.getVariableNameForMethod(method);
        if (this.getVariableType(varName) == TorConfig.ConfigVarType.HS_AUTH) {
            return this.invokeHSAuthGet(varName, args);
        }
        throw new IllegalArgumentException();
    }

    private Object invokeGetMethod(Method method) {
        String varName = this.getVariableNameForMethod(method);
        Object value = this.getVariableValue(varName);
        if (value instanceof TorConfigInterval) {
            TorConfigInterval interval = (TorConfigInterval)value;
            return interval.getMilliseconds();
        }
        return value;
    }

    private Object invokeHSAuthGet(String varName, Object[] args) {
        if (!(args[0] instanceof String)) {
            throw new IllegalArgumentException();
        }
        TorConfigHSAuth hsAuth = this.getHSAuth(varName);
        return hsAuth.get((String)args[0]);
    }

    private void invokeAddMethod(Method method, Object[] args) {
        String name = this.getVariableNameForMethod(method);
        TorConfig.ConfigVarType type = this.getVariableType(name);
        switch (type) {
            case HS_AUTH: {
                this.invokeHSAuthAdd(name, args);
                break;
            }
            case BRIDGE_LINE: {
                this.invokeBridgeAdd(args);
                break;
            }
            default: {
                throw new UnsupportedOperationException("addX configuration methods only supported for HS_AUTH or BRIDGE_LINE type");
            }
        }
    }

    private void invokeBridgeAdd(Object[] args) {
        if (args.length >= 2 && args[0] instanceof IPv4Address && args[1] instanceof Integer) {
            if (args.length == 2) {
                this.bridges.add(new TorConfigBridgeLine((IPv4Address)args[0], (Integer)args[1], null));
                return;
            }
            if (args.length == 3 && args[2] instanceof HexDigest) {
                this.bridges.add(new TorConfigBridgeLine((IPv4Address)args[0], (Integer)args[1], (HexDigest)args[2]));
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    private void invokeHSAuthAdd(String name, Object[] args) {
        if (args.length != 2 || !(args[0] instanceof String) || !(args[1] instanceof String)) {
            throw new IllegalArgumentException();
        }
        TorConfigHSAuth hsAuth = this.getHSAuth(name);
        hsAuth.add((String)args[0], (String)args[1]);
    }

    private TorConfigHSAuth getHSAuth(String keyName) {
        if (!this.configValues.containsKey(keyName)) {
            this.configValues.put(keyName, new TorConfigHSAuth());
        }
        return (TorConfigHSAuth)this.configValues.get(keyName);
    }

    private Object getVariableValue(String varName) {
        if (this.configValues.containsKey(varName)) {
            return this.configValues.get(varName);
        }
        return this.getDefaultVariableValue(varName);
    }

    private Object getDefaultVariableValue(String varName) {
        String defaultValue = this.getDefaultValueString(varName);
        TorConfig.ConfigVarType type = this.getVariableType(varName);
        if (defaultValue == null || type == null) {
            return null;
        }
        return this.parser.parseValue(defaultValue, type);
    }

    private String getDefaultValueString(String varName) {
        TorConfig.ConfigVar var = this.getAnnotationForVariable(varName);
        if (var == null) {
            return null;
        }
        return var.defaultValue();
    }

    private TorConfig.ConfigVarType getVariableType(String varName) {
        if ("Bridge".equals(varName)) {
            return TorConfig.ConfigVarType.BRIDGE_LINE;
        }
        TorConfig.ConfigVar var = this.getAnnotationForVariable(varName);
        if (var == null) {
            return null;
        }
        return var.type();
    }

    private String getVariableNameForMethod(Method method) {
        String methodName = method.getName();
        if (methodName.startsWith("get") || methodName.startsWith("set") || methodName.startsWith("add")) {
            return methodName.substring(3);
        }
        throw new IllegalArgumentException();
    }

    private TorConfig.ConfigVar getAnnotationForVariable(String varName) {
        String getName = "get" + varName;
        for (Method m : TorConfig.class.getDeclaredMethods()) {
            if (!getName.equals(m.getName())) continue;
            return m.getAnnotation(TorConfig.ConfigVar.class);
        }
        return null;
    }
}

