/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.path;

import com.subgraph.orchid.ConsensusDocument;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.circuits.path.CircuitNodeChooser;

class CircuitNodeChooserWeightParameters {
    private static final int VAR_WG = 0;
    private static final int VAR_WM = 1;
    private static final int VAR_WE = 2;
    private static final int VAR_WD = 3;
    private static final int VAR_WGB = 4;
    private static final int VAR_WMB = 5;
    private static final int VAR_WEB = 6;
    private static final int VAR_WDB = 7;
    private static final int VAR_COUNT = 8;
    private static final String ZERO = "zero";
    private static final String ONE = "one";
    private final double[] vars;
    private final boolean isValid;

    static CircuitNodeChooserWeightParameters create(ConsensusDocument consensus, CircuitNodeChooser.WeightRule rule) {
        String[] tags;
        double[] vars = new double[8];
        long scale = consensus.getWeightScaleParameter();
        if (!CircuitNodeChooserWeightParameters.populateVars(consensus, scale, tags = CircuitNodeChooserWeightParameters.getTagsForWeightRule(rule), vars)) {
            return new CircuitNodeChooserWeightParameters(new double[8], false);
        }
        return new CircuitNodeChooserWeightParameters(vars, true);
    }

    static boolean populateVars(ConsensusDocument consensus, long scale, String[] tags, double[] vars) {
        int i = 0;
        while (i < 8) {
            vars[i] = CircuitNodeChooserWeightParameters.tagToVarValue(consensus, scale, tags[i]);
            if (vars[i] < 0.0) {
                return false;
            }
            int n = i++;
            vars[n] = vars[n] / (double)scale;
        }
        return true;
    }

    static double tagToVarValue(ConsensusDocument consensus, long scale, String tag) {
        if (tag.equals(ZERO)) {
            return 0.0;
        }
        if (tag.equals(ONE)) {
            return 1.0;
        }
        return consensus.getBandwidthWeight(tag);
    }

    static String[] getTagsForWeightRule(CircuitNodeChooser.WeightRule rule) {
        switch (rule) {
            case WEIGHT_FOR_GUARD: {
                return new String[]{"Wgg", "Wgm", ZERO, "Wgd", "Wgb", "Wmb", "Web", "Wdb"};
            }
            case WEIGHT_FOR_MID: {
                return new String[]{"Wmg", "Wmm", "Wme", "Wmd", "Wgb", "Wmb", "Web", "Wdb"};
            }
            case WEIGHT_FOR_EXIT: {
                return new String[]{"Wee", "Wem", "Wed", "Weg", "Wgb", "Wmb", "Web", "Wdb"};
            }
            case WEIGHT_FOR_DIR: {
                return new String[]{"Wbe", "Wbm", "Wbd", "Wbg", ONE, ONE, ONE, ONE};
            }
            case NO_WEIGHTING: {
                return new String[]{ONE, ONE, ONE, ONE, ONE, ONE, ONE, ONE};
            }
        }
        throw new IllegalArgumentException("Unhandled WeightRule type: " + (Object)((Object)rule));
    }

    private CircuitNodeChooserWeightParameters(double[] vars, boolean isValid) {
        this.vars = vars;
        this.isValid = isValid;
    }

    boolean isValid() {
        return this.isValid;
    }

    double getWg() {
        return this.vars[0];
    }

    double getWm() {
        return this.vars[1];
    }

    double getWe() {
        return this.vars[2];
    }

    double getWd() {
        return this.vars[3];
    }

    double getWgb() {
        return this.vars[4];
    }

    double getWmb() {
        return this.vars[5];
    }

    double getWeb() {
        return this.vars[6];
    }

    double getWdb() {
        return this.vars[7];
    }

    double calculateWeightedBandwidth(Router router) {
        long bw = this.kbToBytes(router.getEstimatedBandwidth());
        double w = this.calculateWeight(router.isExit() && !router.isBadExit(), router.isPossibleGuard(), router.getDirectoryPort() != 0);
        return w * (double)bw + 0.5;
    }

    long kbToBytes(long kb) {
        return kb > 9223372036854775L ? Long.MAX_VALUE : kb * 1000L;
    }

    private double calculateWeight(boolean isExit, boolean isGuard, boolean isDir) {
        if (isGuard && isExit) {
            return isDir ? this.getWdb() * this.getWd() : this.getWd();
        }
        if (isGuard) {
            return isDir ? this.getWgb() * this.getWg() : this.getWg();
        }
        if (isExit) {
            return isDir ? this.getWeb() * this.getWe() : this.getWe();
        }
        return isDir ? this.getWmb() * this.getWm() : this.getWm();
    }
}

