/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.hs;

import com.subgraph.orchid.Directory;
import com.subgraph.orchid.HiddenServiceCircuit;
import com.subgraph.orchid.OpenFailedException;
import com.subgraph.orchid.Stream;
import com.subgraph.orchid.StreamConnectFailedException;
import com.subgraph.orchid.TorConfig;
import com.subgraph.orchid.TorException;
import com.subgraph.orchid.circuits.CircuitManagerImpl;
import com.subgraph.orchid.circuits.hs.HSDescriptor;
import com.subgraph.orchid.circuits.hs.HSDescriptorDirectory;
import com.subgraph.orchid.circuits.hs.HSDescriptorDownloader;
import com.subgraph.orchid.circuits.hs.HSDirectories;
import com.subgraph.orchid.circuits.hs.HiddenService;
import com.subgraph.orchid.circuits.hs.RendezvousCircuitBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public class HiddenServiceManager {
    private static final int RENDEZVOUS_RETRY_COUNT = 5;
    private static final int HS_STREAM_TIMEOUT = 20000;
    private static final Logger logger = Logger.getLogger(HiddenServiceManager.class.getName());
    private final Map<String, HiddenService> hiddenServices;
    private final TorConfig config;
    private final Directory directory;
    private final HSDirectories hsDirectories;
    private final CircuitManagerImpl circuitManager;

    public HiddenServiceManager(TorConfig config, Directory directory, CircuitManagerImpl circuitManager) {
        this.config = config;
        this.directory = directory;
        this.hiddenServices = new HashMap<String, HiddenService>();
        this.hsDirectories = new HSDirectories(directory);
        this.circuitManager = circuitManager;
    }

    public Stream getStreamTo(String onion, int port) throws OpenFailedException, InterruptedException, TimeoutException {
        HiddenService hs = this.getHiddenServiceForOnion(onion);
        HiddenServiceCircuit circuit = this.getCircuitTo(hs);
        try {
            return circuit.openStream(port, 20000L);
        }
        catch (StreamConnectFailedException e) {
            throw new OpenFailedException("Failed to open stream to hidden service " + hs.getOnionAddressForLogging() + " reason " + e.getReason());
        }
    }

    private synchronized HiddenServiceCircuit getCircuitTo(HiddenService hs) throws OpenFailedException {
        if (hs.getCircuit() == null) {
            HiddenServiceCircuit c = this.openCircuitTo(hs);
            if (c == null) {
                throw new OpenFailedException("Failed to open circuit to " + hs.getOnionAddressForLogging());
            }
            hs.setCircuit(c);
        }
        return hs.getCircuit();
    }

    private HiddenServiceCircuit openCircuitTo(HiddenService hs) throws OpenFailedException {
        HSDescriptor descriptor = this.getDescriptorFor(hs);
        for (int i = 0; i < 5; ++i) {
            HiddenServiceCircuit c = this.openRendezvousCircuit(hs, descriptor);
            if (c == null) continue;
            return c;
        }
        throw new OpenFailedException("Failed to open circuit to " + hs.getOnionAddressForLogging());
    }

    HSDescriptor getDescriptorFor(HiddenService hs) throws OpenFailedException {
        if (hs.hasCurrentDescriptor()) {
            return hs.getDescriptor();
        }
        HSDescriptor descriptor = this.downloadDescriptorFor(hs);
        if (descriptor == null) {
            String msg = "Failed to download HS descriptor for " + hs.getOnionAddressForLogging();
            logger.info(msg);
            throw new OpenFailedException(msg);
        }
        hs.setDescriptor(descriptor);
        return descriptor;
    }

    private HSDescriptor downloadDescriptorFor(HiddenService hs) {
        logger.fine("Downloading HS descriptor for " + hs.getOnionAddressForLogging());
        List<HSDescriptorDirectory> dirs = this.hsDirectories.getDirectoriesForHiddenService(hs);
        HSDescriptorDownloader downloader = new HSDescriptorDownloader(hs, this.circuitManager, dirs);
        return downloader.downloadDescriptor();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HiddenService getHiddenServiceForOnion(String onion) throws OpenFailedException {
        String key = onion.endsWith(".onion") ? onion.substring(0, onion.length() - 6) : onion;
        Map<String, HiddenService> map = this.hiddenServices;
        synchronized (map) {
            if (!this.hiddenServices.containsKey(key)) {
                this.hiddenServices.put(key, this.createHiddenServiceFor(key));
            }
            return this.hiddenServices.get(key);
        }
    }

    private HiddenService createHiddenServiceFor(String key) throws OpenFailedException {
        try {
            byte[] decoded = HiddenService.decodeOnion(key);
            return new HiddenService(this.config, decoded);
        }
        catch (TorException e) {
            String target = this.config.getSafeLogging() ? "[scrubbed]" : key + ".onion";
            throw new OpenFailedException("Failed to decode onion address " + target + " : " + e.getMessage());
        }
    }

    private HiddenServiceCircuit openRendezvousCircuit(HiddenService hs, HSDescriptor descriptor) {
        RendezvousCircuitBuilder builder = new RendezvousCircuitBuilder(this.directory, this.circuitManager, hs, descriptor);
        try {
            return builder.call();
        }
        catch (Exception e) {
            return null;
        }
    }
}

