/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits.hs;

import com.subgraph.orchid.ConsensusDocument;
import com.subgraph.orchid.Directory;
import com.subgraph.orchid.Router;
import com.subgraph.orchid.circuits.hs.HSDescriptorDirectory;
import com.subgraph.orchid.circuits.hs.HiddenService;
import com.subgraph.orchid.crypto.TorRandom;
import com.subgraph.orchid.data.HexDigest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class HSDirectories {
    private static final int DIR_CLUSTER_SZ = 3;
    private final Directory directory;
    private final TorRandom random;
    private ConsensusDocument currentConsensus;
    private List<Router> hsDirectories;

    HSDirectories(Directory directory) {
        this.directory = directory;
        this.hsDirectories = new ArrayList<Router>();
        this.random = new TorRandom();
    }

    List<HSDescriptorDirectory> getDirectoriesForHiddenService(HiddenService hs) {
        ArrayList<HSDescriptorDirectory> dirs = new ArrayList<HSDescriptorDirectory>(6);
        for (HexDigest id : hs.getAllCurrentDescriptorIds()) {
            for (Router r : this.getDirectoriesForDescriptorId(id)) {
                dirs.add(new HSDescriptorDirectory(id, r));
            }
        }
        return dirs;
    }

    private List<Router> getDirectoriesForDescriptorId(HexDigest descriptorId) {
        String hexId = descriptorId.toString();
        this.refreshFromDirectory();
        int idx = this.getIndexForDescriptorId(hexId);
        return this.selectDirectoriesAtIndex(idx);
    }

    private int getIndexForDescriptorId(String hexId) {
        for (int i = 0; i < this.hsDirectories.size(); ++i) {
            String routerId = this.getHexIdForIndex(i);
            if (routerId.compareTo(hexId) <= 0) continue;
            return i;
        }
        return 0;
    }

    private String getHexIdForIndex(int idx) {
        Router r = this.hsDirectories.get(idx);
        return r.getIdentityHash().toString();
    }

    private List<Router> selectDirectoriesAtIndex(int idx) {
        if (idx < 0 || idx >= this.hsDirectories.size()) {
            throw new IllegalArgumentException("idx = " + idx);
        }
        if (this.hsDirectories.size() < 3) {
            throw new IllegalStateException();
        }
        ArrayList<Router> dirs = new ArrayList<Router>(3);
        for (int i = 0; i < 3; ++i) {
            dirs.add(this.hsDirectories.get(idx));
            if (++idx != this.hsDirectories.size()) continue;
            idx = 0;
        }
        this.randomShuffle(dirs);
        return dirs;
    }

    private void refreshFromDirectory() {
        ConsensusDocument consensus = this.directory.getCurrentConsensusDocument();
        if (this.currentConsensus == consensus) {
            return;
        }
        this.currentConsensus = consensus;
        this.hsDirectories.clear();
        for (Router r : this.directory.getAllRouters()) {
            if (!r.isHSDirectory()) continue;
            this.hsDirectories.add(r);
        }
        Collections.sort(this.hsDirectories, new Comparator<Router>(){

            @Override
            public int compare(Router r1, Router r2) {
                String s1 = r1.getIdentityHash().toString();
                String s2 = r2.getIdentityHash().toString();
                return s1.compareTo(s2);
            }
        });
    }

    private void randomShuffle(List<Router> dirs) {
        for (int i = 0; i < dirs.size(); ++i) {
            this.swap(dirs, i, this.random.nextInt(dirs.size()));
        }
    }

    private void swap(List<Router> dirs, int idx1, int idx2) {
        if (idx1 != idx2) {
            Router r1 = dirs.get(idx1);
            Router r2 = dirs.get(idx2);
            dirs.set(idx1, r2);
            dirs.set(idx2, r1);
        }
    }
}

