/*
 * Decompiled with CFR 0.152.
 */
package com.subgraph.orchid.circuits;

import com.subgraph.orchid.ExitCircuit;
import com.subgraph.orchid.Stream;
import com.subgraph.orchid.StreamConnectFailedException;
import com.subgraph.orchid.circuits.StreamExitRequest;
import java.util.concurrent.TimeoutException;
import java.util.logging.Logger;

public class OpenExitStreamTask
implements Runnable {
    private static final Logger logger = Logger.getLogger(OpenExitStreamTask.class.getName());
    private final ExitCircuit circuit;
    private final StreamExitRequest exitRequest;

    OpenExitStreamTask(ExitCircuit circuit, StreamExitRequest exitRequest) {
        this.circuit = circuit;
        this.exitRequest = exitRequest;
    }

    @Override
    public void run() {
        logger.fine("Attempting to open stream to " + this.exitRequest);
        try {
            this.exitRequest.setCompletedSuccessfully(this.tryOpenExitStream());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            this.exitRequest.setInterrupted();
        }
        catch (TimeoutException e) {
            this.circuit.markForClose();
            this.exitRequest.setCompletedTimeout();
        }
        catch (StreamConnectFailedException e) {
            if (!e.isReasonRetryable()) {
                this.exitRequest.setExitFailed();
                this.circuit.recordFailedExitTarget(this.exitRequest);
            }
            this.circuit.markForClose();
            this.exitRequest.setStreamOpenFailure(e.getReason());
        }
    }

    private Stream tryOpenExitStream() throws InterruptedException, TimeoutException, StreamConnectFailedException {
        if (this.exitRequest.isAddressTarget()) {
            return this.circuit.openExitStream(this.exitRequest.getAddress(), this.exitRequest.getPort(), this.exitRequest.getStreamTimeout());
        }
        return this.circuit.openExitStream(this.exitRequest.getHostname(), this.exitRequest.getPort(), this.exitRequest.getStreamTimeout());
    }
}

