/*
 * Decompiled with CFR 0.152.
 */
package org.biouno.unochoice.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.model.ParameterDefinition;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.Project;
import hudson.security.ACL;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import hudson.tasks.BuildWrapper;
import hudson.util.DescribableList;
import hudson.util.ReflectionUtils;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.acegisecurity.Authentication;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.StringUtils;
import org.biouno.unochoice.AbstractUnoChoiceParameter;

public class Utils {
    protected static final Logger LOGGER = Logger.getLogger(Utils.class.getName());

    private Utils() {
    }

    public static boolean isSelected(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        String text = obj.toString();
        return StringUtils.isNotBlank((String)text) && (text.endsWith(":selected") || text.endsWith(":selected:disabled"));
    }

    @NonNull
    public static String escapeSelected(@Nullable Object obj) {
        if (obj == null) {
            return "";
        }
        String text = obj.toString();
        if (StringUtils.isBlank((String)text)) {
            return "";
        }
        if (Utils.isSelected(text)) {
            return text.replaceAll(":selected$", "").replaceAll(":selected:disabled$", ":disabled");
        }
        return text;
    }

    public static boolean isDisabled(@Nullable Object obj) {
        if (obj == null) {
            return false;
        }
        String text = obj.toString();
        return StringUtils.isNotBlank((String)text) && (text.endsWith(":disabled") || text.endsWith(":disabled:selected"));
    }

    @NonNull
    public static String escapeDisabled(@Nullable Object obj) {
        if (obj == null) {
            return "";
        }
        String text = obj.toString();
        if (StringUtils.isBlank((String)text)) {
            return "";
        }
        if (Utils.isDisabled(text)) {
            return text.replaceAll(":disabled$", "").replaceAll(":disabled:selected$", ":selected");
        }
        return text;
    }

    @NonNull
    public static String escapeSelectedAndDisabled(@Nullable Object obj) {
        if (obj == null) {
            return "";
        }
        String text = obj.toString();
        if (StringUtils.isBlank((String)text)) {
            return "";
        }
        if (Utils.isSelected(text) || Utils.isDisabled(text)) {
            return Utils.escapeSelected(Utils.escapeDisabled(text));
        }
        return text;
    }

    @NonNull
    public static String createRandomParameterName(@Nullable String prefix, @Nullable String suffix) {
        Object paramName = "";
        if (StringUtils.isNotBlank((String)prefix)) {
            paramName = prefix + "-";
        }
        paramName = (String)paramName + System.nanoTime();
        if (StringUtils.isNotBlank((String)suffix)) {
            paramName = (String)paramName + "-" + suffix;
        }
        return paramName;
    }

    @NonNull
    public static Map<String, String> getSystemEnv() {
        return System.getenv();
    }

    @Deprecated
    @CheckForNull
    public static Project<?, ?> getProjectByName(@NonNull String projectName) {
        Authentication auth = Jenkins.getAuthentication();
        for (Project p : Items.allItems((Authentication)ACL.SYSTEM, (ItemGroup)Jenkins.getInstance(), Project.class)) {
            if (!p.getName().equals(projectName) || !p.getACL().hasPermission(auth, Item.READ)) continue;
            return p;
        }
        return null;
    }

    @CheckForNull
    public static Project findProjectByParameterUUID(@NonNull String parameterUUID) {
        Authentication auth = Jenkins.getAuthentication();
        for (Project p : Items.allItems((Authentication)ACL.SYSTEM, (ItemGroup)Jenkins.get(), Project.class)) {
            if (!Utils.isParameterDefinitionOf(parameterUUID, p) || !p.getACL().hasPermission(auth, Item.READ)) continue;
            return p;
        }
        return null;
    }

    private static boolean isParameterDefinitionOf(@NonNull String parameterUUID, @NonNull Project<?, ?> project) {
        ArrayList<ParameterDefinition> parameterDefinitions = new ArrayList<ParameterDefinition>(Utils.getProjectParameterDefinitions(project));
        for (List<ParameterDefinition> params : Utils.getBuildWrapperParameterDefinitions(project).values()) {
            parameterDefinitions.addAll(params);
        }
        for (ParameterDefinition pd : parameterDefinitions) {
            AbstractUnoChoiceParameter parameterDefinition;
            String uuid;
            if (!(pd instanceof AbstractUnoChoiceParameter) || !ObjectUtils.equals((Object)parameterUUID, (Object)(uuid = (parameterDefinition = (AbstractUnoChoiceParameter)pd).getRandomName()))) continue;
            return true;
        }
        return false;
    }

    @NonNull
    public static List<ParameterDefinition> getProjectParameterDefinitions(@NonNull Project<?, ?> project) {
        List parameterDefinitions;
        ParametersDefinitionProperty parametersDefinitionProperty = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
        if (parametersDefinitionProperty != null && (parameterDefinitions = parametersDefinitionProperty.getParameterDefinitions()) != null) {
            return parameterDefinitions;
        }
        return Collections.emptyList();
    }

    @NonNull
    public static Map<String, Object> getGlobalNodeProperties() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        Jenkins instance = Jenkins.get();
        DescribableList globalNodeProperties = instance.getGlobalNodeProperties();
        if (globalNodeProperties != null) {
            for (NodeProperty nodeProperty : globalNodeProperties) {
                if (!(nodeProperty instanceof EnvironmentVariablesNodeProperty)) continue;
                EnvironmentVariablesNodeProperty envNodeProperty = (EnvironmentVariablesNodeProperty)nodeProperty;
                map.putAll((Map<String, Object>)envNodeProperty.getEnvVars());
            }
        }
        return map;
    }

    @NonNull
    public static Map<BuildWrapper, List<ParameterDefinition>> getBuildWrapperParameterDefinitions(@NonNull Project<?, ?> project) {
        DescribableList buildWrappersList = project.getBuildWrappersList();
        LinkedHashMap<BuildWrapper, ArrayList<ParameterDefinition>> result = new LinkedHashMap<BuildWrapper, ArrayList<ParameterDefinition>>();
        ArrayList<Object> value = new ArrayList<ParameterDefinition>();
        for (BuildWrapper buildWrapper : buildWrappersList) {
            PropertyDescriptor[] propertyDescriptors;
            try {
                propertyDescriptors = Introspector.getBeanInfo(buildWrapper.getClass()).getPropertyDescriptors();
            }
            catch (IntrospectionException e) {
                if (!LOGGER.isLoggable(Level.FINE)) continue;
                LOGGER.log(Level.FINE, String.format("Introspector.getBeanInfo failed for build wrapper class: [%s]", buildWrapper.getClass().getCanonicalName()), e);
                continue;
            }
            for (PropertyDescriptor propertyDescriptor : propertyDescriptors) {
                try {
                    Utils.addParameterDefinitionsTo(value, buildWrapper, propertyDescriptor);
                }
                catch (RuntimeException e) {
                    if (!LOGGER.isLoggable(Level.FINE)) continue;
                    LOGGER.log(Level.FINE, String.format("Failed to add parameter [%s] to the ParameterDefinition list", propertyDescriptor.getName()), e);
                }
            }
            if (value.isEmpty()) continue;
            result.put(buildWrapper, value);
            value = new ArrayList();
        }
        return result.isEmpty() ? Collections.emptyMap() : result;
    }

    private static void addParameterDefinitionsTo(List<ParameterDefinition> target, Object bean, PropertyDescriptor pd) {
        Object[] array;
        if (ParameterDefinition.class.isAssignableFrom(pd.getPropertyType())) {
            ParameterDefinition param = (ParameterDefinition)Utils.read(bean, pd);
            if (param != null) {
                target.add(param);
            }
            return;
        }
        List<Object> iterable = null;
        if (Iterable.class.isAssignableFrom(pd.getPropertyType())) {
            iterable = (List<Object>)Utils.read(bean, pd);
        } else if (Object[].class.isAssignableFrom(pd.getPropertyType()) && (array = (Object[])Utils.read(bean, pd)) != null) {
            iterable = Arrays.asList(array);
        }
        if (iterable == null) {
            return;
        }
        for (Object t : iterable) {
            if (!(t instanceof ParameterDefinition)) continue;
            target.add((ParameterDefinition)t);
        }
    }

    private static <T> T read(Object bean, PropertyDescriptor pd) {
        Method accessor = pd.getReadMethod();
        if (accessor != null && accessor.getParameterTypes().length == 0) {
            Object result = ReflectionUtils.invokeMethod((Method)accessor, (Object)bean);
            return (T)result;
        }
        Field field = ReflectionUtils.findField(bean.getClass(), (String)pd.getName());
        if (field != null) {
            Object value = ReflectionUtils.getField((Field)field, (Object)bean);
            if (pd.getPropertyType().isInstance(value)) {
                Object result = value;
                return (T)result;
            }
        }
        return null;
    }
}

