/*
 * Decompiled with CFR 0.152.
 */
package org.biouno.unochoice.model;

import edu.umd.cs.findbugs.annotations.Nullable;
import groovy.lang.Binding;
import hudson.Extension;
import hudson.PluginManager;
import hudson.Util;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import jenkins.model.Jenkins;
import org.biouno.unochoice.model.AbstractScript;
import org.biouno.unochoice.model.ScriptDescriptor;
import org.biouno.unochoice.util.SafeHtmlExtendedMarkupFormatter;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.scriptsecurity.sandbox.groovy.SecureGroovyScript;
import org.jenkinsci.plugins.scriptsecurity.scripts.ApprovalContext;
import org.kohsuke.stapler.DataBoundConstructor;

public class GroovyScript
extends AbstractScript {
    private static final long serialVersionUID = -3741105849416473898L;
    private static final Logger LOGGER = Logger.getLogger(GroovyScript.class.getName());
    @Deprecated
    private transient String script;
    private SecureGroovyScript secureScript;
    @Deprecated
    @Nullable
    private transient String fallbackScript;
    @Nullable
    private SecureGroovyScript secureFallbackScript;

    @Deprecated
    public GroovyScript(String script, String fallbackScript) {
        this(new SecureGroovyScript(script, false, null), new SecureGroovyScript(fallbackScript, false, null));
    }

    @DataBoundConstructor
    public GroovyScript(SecureGroovyScript script, SecureGroovyScript fallbackScript) {
        if (script != null) {
            this.secureScript = script.configuringWithNonKeyItem();
        }
        if (fallbackScript != null) {
            this.secureFallbackScript = fallbackScript.configuringWithNonKeyItem();
        }
    }

    private Object readResolve() {
        if (this.secureScript == null && this.script != null) {
            this.secureScript = new SecureGroovyScript(this.script, false, null).configuring(ApprovalContext.create());
        }
        if (this.secureFallbackScript == null && this.fallbackScript != null) {
            this.secureFallbackScript = new SecureGroovyScript(this.fallbackScript, false, null).configuring(ApprovalContext.create());
        }
        return this;
    }

    public SecureGroovyScript getScript() {
        return this.secureScript;
    }

    public SecureGroovyScript getFallbackScript() {
        return this.secureFallbackScript;
    }

    @Override
    public Object eval() {
        return this.eval(Collections.emptyMap());
    }

    @Override
    public Object eval(Map<String, String> parameters) throws RuntimeException {
        if (this.secureScript == null) {
            return null;
        }
        Jenkins instance = Jenkins.getInstanceOrNull();
        ClassLoader cl = null;
        if (instance != null) {
            try {
                PluginManager pluginManager = instance.getPluginManager();
                cl = pluginManager.uberClassLoader;
            }
            catch (Exception e) {
                LOGGER.log(Level.FINEST, e.getMessage(), e);
            }
        }
        if (cl == null) {
            cl = Thread.currentThread().getContextClassLoader();
        }
        Binding context = new Binding();
        Map<String, String> envVars = System.getenv();
        for (Map.Entry<String, String> parameter : parameters.entrySet()) {
            String value = parameter.getValue();
            if (value == null) continue;
            if (value instanceof String) {
                value = Util.replaceMacro((String)value, envVars);
            }
            context.setVariable(parameter.getKey(), (Object)value);
        }
        try {
            Object returnValue = this.secureScript.evaluate(cl, context, null);
            if (this.secureScript.isSandbox()) {
                returnValue = this.resolveTypeAndSanitize(returnValue);
            }
            return returnValue;
        }
        catch (Exception re) {
            if (this.secureFallbackScript != null) {
                try {
                    LOGGER.log(Level.FINEST, "Fallback to default script...", re);
                    Object returnValue = this.secureFallbackScript.evaluate(cl, context, null);
                    if (this.secureFallbackScript.isSandbox()) {
                        returnValue = this.resolveTypeAndSanitize(returnValue);
                    }
                    return returnValue;
                }
                catch (Exception e2) {
                    LOGGER.log(Level.WARNING, "Error executing fallback script", e2);
                    throw new RuntimeException("Failed to evaluate fallback script: " + e2.getMessage(), e2);
                }
            }
            LOGGER.log(Level.WARNING, "No fallback script configured for '%s'");
            throw new RuntimeException("Failed to evaluate script: " + re.getMessage(), re);
        }
    }

    private Object resolveTypeAndSanitize(Object returnValue) {
        if (returnValue instanceof CharSequence) {
            return this.sanitizeString(returnValue);
        }
        if (returnValue instanceof List) {
            List list = (List)returnValue;
            return list.stream().map(this::sanitizeString).collect(Collectors.toList());
        }
        if (returnValue instanceof Map) {
            Map map = (Map)returnValue;
            LinkedHashMap returnMap = new LinkedHashMap(map.size());
            map.forEach((key, value) -> {
                String newKey = this.sanitizeString(key);
                String newValue = this.sanitizeString(value);
                returnMap.put(newKey, newValue);
            });
            return returnMap;
        }
        throw new RuntimeException("Return type of Groovy script must be a valid String, List, or Map");
    }

    private String sanitizeString(Object input) {
        if (input == null) {
            return null;
        }
        try {
            return SafeHtmlExtendedMarkupFormatter.INSTANCE.translate(input.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Failed to sanitize input due to: %s", e.getMessage()), e);
        }
    }

    public String toString() {
        String secureScriptText = this.secureScript != null ? this.secureScript.getScript() : "";
        String fallbackScriptText = this.secureFallbackScript != null ? this.secureFallbackScript.getScript() : "";
        return "GroovyScript [script=" + secureScriptText + ", fallbackScript=" + fallbackScriptText + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.secureFallbackScript == null ? 0 : this.secureFallbackScript.hashCode());
        result = 31 * result + (this.secureScript == null ? 0 : this.secureScript.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        GroovyScript other = (GroovyScript)obj;
        if (this.secureFallbackScript == null ? other.secureFallbackScript != null : !this.secureFallbackScript.equals(other.secureFallbackScript)) {
            return false;
        }
        if (this.secureScript == null) {
            return other.secureScript == null;
        }
        return this.secureScript.equals(other.secureScript);
    }

    @Extension
    @Symbol(value={"groovyScript"})
    public static class DescriptorImpl
    extends ScriptDescriptor {
        public String getDisplayName() {
            return "Groovy Script";
        }
    }
}

