/*
 * Decompiled with CFR 0.152.
 */
package org.biouno.unochoice;

import hudson.DescriptorExtensionList;
import hudson.model.FileParameterValue;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.SimpleParameterDefinition;
import hudson.model.StringParameterValue;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import jenkins.model.Jenkins;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.sf.json.util.JSONUtils;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.lang.StringUtils;
import org.biouno.unochoice.UnoChoiceParameter;
import org.biouno.unochoice.util.Utils;
import org.kohsuke.stapler.StaplerRequest;

public abstract class AbstractUnoChoiceParameter
extends SimpleParameterDefinition
implements UnoChoiceParameter {
    protected static final Logger LOGGER = Logger.getLogger(AbstractUnoChoiceParameter.class.getName());
    private static final long serialVersionUID = -6027543114170652870L;
    public static final String PARAMETER_TYPE_SINGLE_SELECT = "PT_SINGLE_SELECT";
    public static final String PARAMETER_TYPE_MULTI_SELECT = "PT_MULTI_SELECT";
    public static final String PARAMETER_TYPE_CHECK_BOX = "PT_CHECKBOX";
    public static final String PARAMETER_TYPE_RADIO = "PT_RADIO";
    public static final String ELEMENT_TYPE_TEXT_BOX = "ET_TEXT_BOX";
    public static final String ELEMENT_TYPE_ORDERED_LIST = "ET_ORDERED_LIST";
    public static final String ELEMENT_TYPE_UNORDERED_LIST = "ET_UNORDERED_LIST";
    public static final String ELEMENT_TYPE_FORMATTED_HTML = "ET_FORMATTED_HTML";
    public static final String ELEMENT_TYPE_FORMATTED_HIDDEN_HTML = "ET_FORMATTED_HIDDEN_HTML";
    public static final int DEFAULT_MAX_VISIBLE_ITEM_COUNT = 10;
    private final String randomName;

    @Deprecated
    protected AbstractUnoChoiceParameter(String name, String description) {
        super(name, description);
        this.randomName = Utils.createRandomParameterName("choice-parameter", "");
    }

    protected AbstractUnoChoiceParameter(String name, String description, String randomName) {
        super(name, description);
        this.randomName = StringUtils.isBlank((String)randomName) ? Utils.createRandomParameterName("choice-parameter", "") : randomName;
    }

    public String getRandomName() {
        return this.randomName;
    }

    public ParameterValue createValue(String value) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.entering(AbstractUnoChoiceParameter.class.getName(), "createValue", value);
        }
        String description = this.getDescription();
        String name = this.getName();
        StringParameterValue parameterValue = new StringParameterValue(name, value, description);
        return parameterValue;
    }

    public ParameterValue createValue(StaplerRequest request, JSONObject json) {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.entering(AbstractUnoChoiceParameter.class.getName(), "createValue", new Object[]{request, json});
        }
        if (json.containsKey((Object)"file")) {
            FileItem src;
            try {
                src = request.getFileItem(json.getString("file"));
            }
            catch (ServletException e) {
                LOGGER.log(Level.SEVERE, "Fatal error while reading uploaded file: " + e.getMessage(), e);
                return null;
            }
            catch (IOException e) {
                LOGGER.log(Level.SEVERE, "IO error while reading uploaded file: " + e.getMessage(), e);
                return null;
            }
            if (src == null) {
                return null;
            }
            FileParameterValue p = new FileParameterValue(this.getName(), src);
            p.setDescription(this.getDescription());
            return p;
        }
        JSONObject parameterJsonModel = new JSONObject(false);
        Object value = json.get("value");
        Object name = json.get("name");
        String valueAsText = JSONUtils.isArray((Object)value) ? ((JSONArray)value).join(",", true) : (value == null ? "" : String.valueOf(value));
        parameterJsonModel.put("name", name);
        parameterJsonModel.put("value", (Object)valueAsText);
        StringParameterValue parameterValue = (StringParameterValue)request.bindJSON(StringParameterValue.class, parameterJsonModel);
        parameterValue.setDescription(this.getDescription());
        return parameterValue;
    }

    public abstract String getChoiceType();

    public ParameterDefinition.ParameterDescriptor getDescriptor() {
        ParameterDefinition.ParameterDescriptor desc = (ParameterDefinition.ParameterDescriptor)Jenkins.get().getDescriptor(this.getClass());
        if (desc != null) {
            return desc;
        }
        throw new RuntimeException("Missing parameter description!");
    }

    public static DescriptorExtensionList<ParameterDefinition, ParameterDefinition.ParameterDescriptor> all() {
        return Jenkins.get().getDescriptorList(ParameterDefinition.class);
    }
}

