/*
 * Decompiled with CFR 0.152.
 */
package org.beryx.jlink;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.io.File;
import org.beryx.jlink.BaseTask;
import org.beryx.jlink.JlinkPlugin;
import org.beryx.jlink.JlinkTask;
import org.beryx.jlink.data.JPackageData;
import org.beryx.jlink.data.JPackageTaskData;
import org.beryx.jlink.impl.JPackageTaskImpl;
import org.beryx.jlink.util.PathUtil;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.runtime.typehandling.ShortTypeHandling;
import org.gradle.api.file.Directory;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.InputDirectory;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.TaskAction;

public class JPackageTask
extends BaseTask {
    private static final Logger LOGGER;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;

    public JPackageTask() {
        this.dependsOn(new Object[]{JlinkPlugin.getTASK_NAME_JPACKAGE_IMAGE()});
        String string = "Creates an installable image using the jpackage tool";
        ScriptBytecodeAdapter.setGroovyObjectProperty((Object)string, JPackageTask.class, (GroovyObject)this, (String)"description");
    }

    @Input
    public String getModuleName() {
        return ShortTypeHandling.castToString((Object)this.getExtension().getModuleName().get());
    }

    @Input
    public String getMainClass() {
        return ShortTypeHandling.castToString((Object)this.getExtension().getMainClass().get());
    }

    @InputDirectory
    public Directory getJlinkJarsDir() {
        return ((ProjectInternal)this.getProject()).getLayout().getProjectDirectory().dir(PathUtil.getJlinkJarsDirPath(this.getJlinkBasePath()));
    }

    @Input
    public String getImageName() {
        return ShortTypeHandling.castToString(this.getExtension().getImageName());
    }

    @OutputDirectory
    public Directory getImageDir() {
        return (Directory)ScriptBytecodeAdapter.castToType((Object)this.getExtension().getImageDir().get(), Directory.class);
    }

    @Nested
    public JPackageData getJpackageData() {
        return (JPackageData)ScriptBytecodeAdapter.castToType((Object)this.getExtension().getJpackageData().get(), JPackageData.class);
    }

    @TaskAction
    public void jpackageTaskAction() {
        JPackageTaskData taskData = new JPackageTaskData();
        String string = this.getJlinkBasePath();
        taskData.setJlinkBasePath(string);
        File file = DefaultTypeTransformation.booleanUnbox((Object)this.getImageName()) ? this.getImageDirFromName() : this.getImageDir().getAsFile();
        taskData.setImageDir(file);
        String string2 = this.getModuleName();
        taskData.setModuleName(string2);
        JPackageData jPackageData = this.getJpackageData();
        taskData.setJpackageData(jPackageData);
        String string3 = this.getMainClass();
        String string4 = DefaultTypeTransformation.booleanUnbox((Object)string3) ? string3 : this.getDefaultMainClass();
        taskData.setMainClass(string4);
        File file2 = this.getJlinkJarsDir().getAsFile();
        taskData.setJlinkJarsDir(file2);
        JlinkTask jlinkTask = (JlinkTask)((Object)ScriptBytecodeAdapter.castToType((Object)((ProjectInternal)this.getProject()).getTasks().getByName(JlinkPlugin.getTASK_NAME_JLINK()), JlinkTask.class));
        taskData.configureRuntimeImageDir(jlinkTask);
        JPackageTaskImpl taskImpl = new JPackageTaskImpl(this.getProject(), taskData);
        taskImpl.execute();
    }

    @Internal
    public File getImageDirFromName() {
        return ((ProjectInternal)this.getProject()).file((Object)new GStringImpl(new Object[]{((ProjectInternal)this.getProject()).getBuildDir(), this.getImageName()}, new String[]{"", "/", ""}));
    }

    @Internal
    public String getDefaultMainClass() {
        String mainClass = (String)ScriptBytecodeAdapter.asType((Object)DefaultGroovyMethods.getAt((Object)this.getProject(), (String)"mainClassName"), String.class);
        int pos = mainClass.lastIndexOf("/");
        if (pos < 0) {
            return mainClass;
        }
        String mainClassModule = mainClass.substring(0, pos);
        if (ScriptBytecodeAdapter.compareNotEqual((Object)mainClassModule, (Object)this.getModuleName())) {
            LOGGER.warn(ShortTypeHandling.castToString((Object)new GStringImpl(new Object[]{mainClassModule, this.getModuleName()}, new String[]{"The module name specified in 'mainClassName' (", ") has not the expected value (", ")."})));
        }
        return mainClass.substring(pos + 1);
    }

    @Override
    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (((Object)((Object)this)).getClass() != JPackageTask.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
        }
        return classInfo.getMetaClass();
    }

    static {
        Logger logger;
        LOGGER = logger = Logging.getLogger(JPackageTask.class);
    }
}

