/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.scheduling;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import net.fortuna.ical4j.model.DateTime;
import net.fortuna.ical4j.model.Period;
import org.bedework.base.exc.BedeworkAccessException;
import org.bedework.base.exc.BedeworkException;
import org.bedework.base.response.GetEntityResponse;
import org.bedework.caldav.util.filter.EntityTypeFilter;
import org.bedework.caldav.util.filter.FilterBase;
import org.bedework.caldav.util.filter.OrFilter;
import org.bedework.calfacade.BwAttendee;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwDateTime;
import org.bedework.calfacade.BwDuration;
import org.bedework.calfacade.BwEvent;
import org.bedework.calfacade.BwEventObj;
import org.bedework.calfacade.BwFreeBusyComponent;
import org.bedework.calfacade.BwOrganizer;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.Participant;
import org.bedework.calfacade.RecurringRetrievalMode;
import org.bedework.calfacade.ScheduleResult;
import org.bedework.calfacade.SchedulingInfo;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calfacade.util.EventPeriod;
import org.bedework.calfacade.util.EventPeriods;
import org.bedework.calfacade.util.Granulator;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.scheduling.OutBoxHandler;
import org.bedework.calsvci.CalendarsI;
import org.bedework.calsvci.SchedulingI;
import org.bedework.util.calendar.IcalDefs;
import org.bedework.webdav.servlet.shared.WebdavException;

public abstract class FreeAndBusyHandler
extends OutBoxHandler {
    private static final int fbtb = 0;
    private static final int fbtf = 1;
    private static final int fbtbu = 2;
    private static final int fbtbt = 3;
    private static final int[][] typeTable = new int[][]{{0, 0, 0, 0}, {0, 1, 2, 3}, {0, 2, 2, 2}, {0, 3, 2, 3}};

    FreeAndBusyHandler(CalSvc svci) {
        super(svci);
    }

    public BwEvent getFreeBusy(Collection<BwCalendar> fbset, BwPrincipal<?> who, BwDateTime start, BwDateTime end, BwOrganizer org, String uid, String exceptUid) {
        CalendarsI colHandler = this.getSvc().getCalendarsHandler();
        Collection<BwCalendar> cals = null;
        if (fbset != null) {
            cals = this.addToFreeBusySet(cals, fbset);
        } else if (this.getPrincipal().equals(who)) {
            cals = this.getFreebusySet();
        } else {
            try {
                this.getSpecialCalendar(who, 5, true, 4);
            }
            catch (BedeworkAccessException ignored) {
                this.getSpecialCalendar(who, 5, true, 13);
            }
            cals = this.addToFreeBusySet(cals, colHandler.getChildren(colHandler.getHome(who, true)));
        }
        if (cals == null) {
            throw new BedeworkAccessException();
        }
        BwEventObj fb = new BwEventObj();
        fb.setEntityType(4);
        fb.setOwnerHref(who.getPrincipalRef());
        fb.setDtstart(start);
        fb.setDtend(end);
        fb.setEndType('E');
        if (uid == null) {
            fb.assignGuid(this.getSvc().getSystemProperties().getSystemid());
        } else {
            fb.setUid(uid);
        }
        fb.setDtstamps(this.getCurrentTimestamp());
        String uri = this.getSvc().getDirectories().principalToCaladdr(who);
        BwAttendee att = new BwAttendee();
        att.setAttendeeUri(uri);
        fb.addAttendee(att);
        fb.setOrganizer((BwOrganizer)org.clone());
        TreeSet<EventInfo> events = new TreeSet<EventInfo>();
        OrFilter filter = new OrFilter();
        try {
            filter.addChild((FilterBase)EntityTypeFilter.makeEntityTypeFilter(null, (String)"event", (boolean)false));
            filter.addChild((FilterBase)EntityTypeFilter.makeEntityTypeFilter(null, (String)"freeAndBusy", (boolean)false));
        }
        catch (WebdavException t) {
            throw new BedeworkException((Throwable)t);
        }
        String userHref = who.getPrincipalRef();
        for (BwCalendar bwCalendar : cals) {
            if (!bwCalendar.getAffectsFreeBusy()) continue;
            RecurringRetrievalMode rrm = new RecurringRetrievalMode(RecurringRetrievalMode.Rmode.expanded, start, end);
            Collection<EventInfo> evs = this.getEvents(Collections.singleton(bwCalendar), (FilterBase)filter, start, end, rrm, true);
            for (EventInfo ei : evs) {
                int pstat;
                BwEvent ev = ei.getEvent();
                if (exceptUid != null && exceptUid.equals(ev.getUid()) || !bwCalendar.getIgnoreTransparency() && "TRANSPARENT".equals(ev.getPeruserTransparency(userHref)) || "CANCELLED".equals(ev.getStatus()) || ev.getAttendeeSchedulingObject().booleanValue() && (att = ev.findAttendee(uri)) != null && ((pstat = IcalDefs.checkPartstat((String)att.getPartstat())) == 2 || pstat == 0)) continue;
                events.add(ei);
            }
        }
        try {
            BwFreeBusyComponent bwFreeBusyComponent;
            BwFreeBusyComponent bwFreeBusyComponent2;
            EventPeriods eventPeriods = new EventPeriods(start, end);
            for (EventInfo ei : events) {
                int type;
                BwEvent ev = ei.getEvent();
                if (ev.getEntityType() == 0) {
                    if ("CANCELLED".equals(ev.getStatus())) continue;
                    type = 0;
                    if (ev.getAttendeeSchedulingObject().booleanValue() && (att = ev.findAttendee(uri)) != null && IcalDefs.checkPartstat((String)att.getPartstat()) == 3) {
                        type = 3;
                    }
                    if ("TENTATIVE".equals(ev.getStatus())) {
                        type = 3;
                    } else if ("BUSY-UNAVAILABLE".equals(ev.getStatus())) {
                        type = 2;
                    }
                    eventPeriods.addPeriod(ev.getDtstart(), ev.getDtend(), type);
                    continue;
                }
                if (ev.getEntityType() != 4) continue;
                List fbcs = ev.getFreeBusyPeriods();
                for (BwFreeBusyComponent fbc : fbcs) {
                    type = fbc.getType();
                    for (Period p : fbc.getPeriods()) {
                        eventPeriods.addPeriod(p.getStart(), p.getEnd(), type);
                    }
                }
            }
            BwFreeBusyComponent bwFreeBusyComponent3 = eventPeriods.makeFreeBusyComponent(0);
            if (bwFreeBusyComponent3 != null) {
                fb.addFreeBusyPeriod(bwFreeBusyComponent3);
            }
            if ((bwFreeBusyComponent2 = eventPeriods.makeFreeBusyComponent(2)) != null) {
                fb.addFreeBusyPeriod(bwFreeBusyComponent2);
            }
            if ((bwFreeBusyComponent = eventPeriods.makeFreeBusyComponent(3)) != null) {
                fb.addFreeBusyPeriod(bwFreeBusyComponent);
            }
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            throw new BedeworkException(t);
        }
        return fb;
    }

    public Collection<BwCalendar> getFreebusySet() {
        ArrayList<BwCalendar> fbset = new ArrayList<BwCalendar>();
        fbset.add(this.getSvc().getCalendarsHandler().getHome());
        return this.addToFreeBusySet(null, fbset);
    }

    private Collection<BwCalendar> addToFreeBusySet(Collection<BwCalendar> cals, Collection<BwCalendar> fbset) {
        Collection<BwCalendar> resCals = cals == null ? new ArrayList<BwCalendar>() : cals;
        for (BwCalendar cal : fbset) {
            if (cal.getCalType() == 1) {
                if (!cal.getAffectsFreeBusy()) continue;
                resCals.add(cal);
                continue;
            }
            if (cal.getCalType() == 7) {
                if (!cal.getAffectsFreeBusy() || (cal = this.getCols().resolveAlias(cal, true, true)).getCalType() != 1) continue;
                resCals.add(cal);
                continue;
            }
            this.addToFreeBusySet(resCals, this.getSvc().getCalendarsHandler().getChildren(cal));
        }
        return resCals;
    }

    public SchedulingI.FbResponses aggregateFreeBusy(ScheduleResult sr, BwDateTime start, BwDateTime end, BwDuration granularity) {
        SchedulingI.FbResponses resps = new SchedulingI.FbResponses();
        if (start.getDateType() || end.getDateType()) {
            throw new BedeworkException("org.bedework.error.scheduling.badgranulatordt");
        }
        resps.setResponses(new ArrayList());
        SchedulingI.FbGranulatedResponse allResponses = new SchedulingI.FbGranulatedResponse();
        allResponses.setStart(start);
        allResponses.setEnd(end);
        resps.setAggregatedResponse(allResponses);
        for (ScheduleResult.ScheduleRecipientResult srr : sr.recipientResults.values()) {
            SchedulingI.FbGranulatedResponse fb = new SchedulingI.FbGranulatedResponse();
            resps.getResponses().add(fb);
            fb.setRespCode(srr.getStatus());
            fb.setNoResponse(srr.freeBusy == null);
            fb.setRecipient(srr.recipient);
            if (!fb.okResponse()) continue;
            SchedulingInfo freeBusySi = srr.freeBusy.getSchedulingInfo();
            GetEntityResponse freeBusyPart = freeBusySi.getOnlyParticipant();
            if (freeBusyPart.isOk()) {
                fb.setAttendee(((Participant)freeBusyPart.getEntity()).getAttendee());
            }
            this.granulateFreeBusy(fb, srr.freeBusy, start, end, granularity);
            if (fb.getStart() == null) continue;
            boolean first = false;
            if (allResponses.eps.isEmpty()) {
                first = true;
            }
            Iterator allIt = allResponses.eps.iterator();
            for (EventPeriod respEp : fb.eps) {
                EventPeriod allEp;
                if (first) {
                    allResponses.eps.add(respEp);
                    allEp = respEp;
                    continue;
                }
                allEp = (EventPeriod)allIt.next();
                if (!allEp.getStart().equals((Object)respEp.getStart()) || !allEp.getEnd().equals((Object)respEp.getEnd())) {
                    throw new BedeworkException("org.bedework.error.scheduling.badresponse");
                }
                if (respEp.getType() == 0 || respEp.getType() == 2) {
                    allEp.setNumBusy(allEp.getNumBusy() + 1);
                } else if (respEp.getType() == 3) {
                    allEp.setNumTentative(allEp.getNumTentative() + 1);
                }
                allEp.setType(typeTable[allEp.getType()][respEp.getType()]);
            }
        }
        return resps;
    }

    public SchedulingI.FbGranulatedResponse granulateFreeBusy(BwEvent fb, BwDateTime start, BwDateTime end, BwDuration granularity) {
        SchedulingI.FbGranulatedResponse fbresp = new SchedulingI.FbGranulatedResponse();
        this.granulateFreeBusy(fbresp, fb, start, end, granularity);
        return fbresp;
    }

    private void granulateFreeBusy(SchedulingI.FbGranulatedResponse fbresp, BwEvent fb, BwDateTime start, BwDateTime end, BwDuration granularity) {
        ArrayList<EventPeriod> respeps;
        DateTime endDt;
        DateTime startDt;
        try {
            startDt = new DateTime(start.getDate());
            endDt = new DateTime(end.getDate());
        }
        catch (ParseException pe) {
            throw new BedeworkException((Throwable)pe);
        }
        if (fb.getDtstart().after(start)) {
            // empty if block
        }
        if (fb.getDtend().before(end)) {
            // empty if block
        }
        fbresp.setStart(start);
        fbresp.setEnd(end);
        ArrayList<EventPeriod> periods = new ArrayList<EventPeriod>();
        if (fb.getFreeBusyPeriods() != null) {
            for (BwFreeBusyComponent fbcomp : fb.getFreeBusyPeriods()) {
                for (Period p : fbcomp.getPeriods()) {
                    DateTime pstart = p.getStart();
                    DateTime pend = p.getEnd();
                    if (!pend.isUtc()) {
                        pend.setUtc(true);
                    }
                    if (pend.after((Date)endDt)) {
                        pend = endDt;
                    }
                    if (pstart.before((Date)startDt)) {
                        pstart = startDt;
                    }
                    if (!pend.after((Date)pstart)) continue;
                    periods.add(new EventPeriod(pstart, pend, fbcomp.getType()));
                }
            }
        }
        Granulator.GetPeriodsPars gpp = new Granulator.GetPeriodsPars();
        gpp.periods = periods;
        gpp.startDt = start;
        gpp.dur = granularity;
        fbresp.eps = respeps = new ArrayList<EventPeriod>();
        int limit = 10000;
        while (gpp.endDt == null || gpp.endDt.before(end)) {
            DateTime pedt;
            DateTime psdt;
            if (limit < 0) {
                throw new BedeworkException("org.bedework.svci.limit.exceeded");
            }
            --limit;
            Collection periodEvents = Granulator.getPeriodsEvents((Granulator.GetPeriodsPars)gpp);
            try {
                psdt = new DateTime(gpp.startDt.getDtval());
                pedt = new DateTime(gpp.endDt.getDtval());
            }
            catch (ParseException pe) {
                throw new BedeworkException((Throwable)pe);
            }
            psdt.setUtc(true);
            pedt.setUtc(true);
            EventPeriod ep = new EventPeriod(psdt, pedt, 0);
            this.setFreeBusyType(ep, periodEvents);
            respeps.add(ep);
        }
    }

    private void setFreeBusyType(EventPeriod ep, Collection<?> periodEvents) {
        int fbtype = 1;
        int busy = 0;
        int tentative = 0;
        for (Object o : periodEvents) {
            int type = ((EventPeriod)o).getType();
            if (type == 0) {
                fbtype = 0;
                ++busy;
            }
            if (type == 2) {
                fbtype = 0;
                ++busy;
            }
            if (type != 3) continue;
            fbtype = 3;
            ++tentative;
        }
        ep.setNumBusy(busy);
        ep.setNumTentative(tentative);
        ep.setType(fbtype);
    }
}

