/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.notifications;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import org.bedework.base.exc.BedeworkException;
import org.bedework.calfacade.configs.NotificationProperties;
import org.bedework.calsvc.notifications.NotifyMessage;
import org.bedework.calsvc.notifications.SubscribeMessage;
import org.bedework.util.http.PooledHttpClient;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;

public class NotificationClient
implements Logged {
    final NotificationProperties np;
    private static final ObjectMapper om = new ObjectMapper();
    private PooledHttpClient cl;
    private final BwLogger logger = new BwLogger();

    public NotificationClient(NotificationProperties np) {
        this.np = np;
    }

    public void informNotifier(String principalHref, String resourceName) {
        NotifyMessage nm = new NotifyMessage(this.np.getNotifierId(), this.np.getNotifierToken());
        nm.setHref(principalHref);
        nm.setResourceName(resourceName);
        this.sendRequest(nm, "notification/");
    }

    public void subscribe(String principalHref, List<String> emails, String userToken) {
        SubscribeMessage sm = new SubscribeMessage(this.np.getNotifierId(), this.np.getNotifierToken(), userToken, principalHref, emails);
        this.sendRequest(sm, "subscribe/");
    }

    public void unsubscribe(String principalHref, List<String> emails) {
        SubscribeMessage sm = new SubscribeMessage(this.np.getNotifierId(), this.np.getNotifierToken(), null, principalHref, emails);
        this.sendRequest(sm, "unsubscribe/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendRequest(Object req, String path) {
        if (this.np.getNotifierURI() == null) {
            return;
        }
        NotificationClient notificationClient = this;
        synchronized (notificationClient) {
            try {
                StringWriter sw = new StringWriter();
                om.writeValue((Writer)sw, req);
                int status = this.getClient().postJson(path, sw.toString());
                if (status != 200) {
                    this.warn("Unable to post notification");
                }
            }
            catch (Throwable t) {
                if (this.debug()) {
                    this.error(t);
                }
                this.error("Unable to contact notification engine " + t.getLocalizedMessage());
            }
            finally {
                try {
                    this.getClient().release();
                }
                catch (Throwable t) {
                    this.warn("Error on close " + t.getLocalizedMessage());
                }
            }
        }
    }

    private PooledHttpClient getClient() {
        if (this.cl != null) {
            return this.cl;
        }
        try {
            this.cl = new PooledHttpClient(new URI(this.np.getNotifierURI()));
            return this.cl;
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            throw new BedeworkException(t);
        }
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

