/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc.directory;

import java.util.Collection;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.svc.BwAuthUser;
import org.bedework.calfacade.svc.UserAuth;
import org.bedework.util.logging.BwLogger;
import org.bedework.util.logging.Logged;

public class UserAuthUWDbImpl
implements Logged,
UserAuth {
    protected UserAuth.CallBack cb;
    private BwLogger logger = new BwLogger();

    public void initialise(UserAuth.CallBack cb) {
        this.cb = cb;
    }

    public void addUser(BwAuthUser val) {
        if (val.isUnauthorized()) {
            return;
        }
        this.cb.add(val);
    }

    public boolean getUserMaintOK() {
        return true;
    }

    public void updateUser(BwAuthUser val) {
        if (val.isUnauthorized()) {
            this.cb.delete(val);
            return;
        }
        this.cb.update(val);
    }

    public BwAuthUser getUser(String account) {
        BwPrincipal p;
        if (this.debug()) {
            this.debug("getUserEntry for " + account);
        }
        if ((p = this.cb.getPrincipal(account)) == null) {
            return null;
        }
        return this.cb.getAuthUser(p.getPrincipalRef());
    }

    public Collection<BwAuthUser> getAll() {
        return this.cb.getAll();
    }

    public BwLogger getLogger() {
        if (this.logger.getLoggedClass() == null && this.logger.getLoggedName() == null) {
            this.logger.setLoggedClass(this.getClass());
        }
        return this.logger;
    }
}

