/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.Collection;
import java.util.TreeSet;
import org.bedework.base.exc.BedeworkAccessException;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.base.BwOwnedDbentity;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.calfacade.svc.BwView;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvci.ViewsI;

class Views
extends CalSvcDb
implements ViewsI {
    Views(CalSvc svci) {
        super(svci);
    }

    public boolean add(BwView val, boolean makeDefault) {
        if (val == null) {
            return false;
        }
        BwPreferences prefs = this.getPrefs();
        this.checkOwnerOrSuper(prefs);
        if (!prefs.addView(val)) {
            return false;
        }
        if (makeDefault) {
            prefs.setPreferredView(val.getName());
        }
        this.getSvc().getPrefsHandler().update(prefs);
        return true;
    }

    public boolean remove(BwView val) {
        if (val == null) {
            return false;
        }
        BwPreferences prefs = this.getPrefs();
        this.checkOwnerOrSuper(prefs);
        Collection views = prefs.getViews();
        if (views == null || !views.contains(val)) {
            return false;
        }
        String name = val.getName();
        views.remove(val);
        if (name.equals(prefs.getPreferredView())) {
            prefs.setPreferredView(null);
        }
        this.getSvc().getPrefsHandler().update(prefs);
        return true;
    }

    public BwView find(String val) {
        BwPreferences prefs;
        if (val == null && (val = (prefs = this.getPrefs()).getPreferredView()) == null) {
            return null;
        }
        if (!val.startsWith("/")) {
            Collection<BwView> views = this.getAll();
            for (BwView view : views) {
                if (!view.getName().equals(val)) continue;
                return view;
            }
            return null;
        }
        String[] pathEls = val.split("/");
        if (pathEls.length != 5 || !".bedework".equals(pathEls[2]) || !"views".equals(pathEls[3])) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (!"user".equals(pathEls[0])) {
            return null;
        }
        sb.append("/principals/users/");
        sb.append(pathEls[1]);
        BwPrincipal pr = this.getPrincipal(sb.toString());
        if (pr == null) {
            return null;
        }
        Collection<BwView> views = this.getAll(pr);
        String viewName = pathEls[4];
        for (BwView view : views) {
            if (!view.getName().equals(viewName)) continue;
            return view;
        }
        return null;
    }

    public boolean addCollection(String name, String path) {
        BwPreferences prefs = this.getPrefs();
        this.checkOwnerOrSuper(prefs);
        BwView view = this.find(name);
        if (view == null) {
            return false;
        }
        view.addCollectionPath(path);
        this.getSvc().getPrefsHandler().update(prefs);
        return true;
    }

    public boolean removeCollection(String name, String path) {
        BwPreferences prefs = this.getPrefs(this.getPrincipal());
        this.checkOwnerOrSuper(prefs);
        BwView view = this.find(name);
        if (view == null) {
            return false;
        }
        view.removeCollectionPath(path);
        this.getSvc().getPrefsHandler().update(prefs);
        return true;
    }

    public Collection<BwView> getAll() {
        TreeSet c = this.getPrefs().getViews();
        if (c == null) {
            c = new TreeSet();
        }
        return c;
    }

    public Collection<BwView> getAll(BwPrincipal pr) {
        TreeSet c = this.getPrefs(pr).getViews();
        if (c == null) {
            c = new TreeSet();
        }
        return c;
    }

    private void checkOwnerOrSuper(Object o) {
        if (this.isGuest()) {
            throw new BedeworkAccessException();
        }
        if (this.isSuper()) {
            return;
        }
        if (!(o instanceof BwOwnedDbentity)) {
            throw new BedeworkAccessException();
        }
        BwOwnedDbentity ent = (BwOwnedDbentity)o;
        if (this.getPrincipal().getPrincipalRef().equals(ent.getOwnerHref())) {
            return;
        }
        throw new BedeworkAccessException();
    }
}

