/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.ArrayList;
import java.util.Collection;
import org.bedework.base.exc.BedeworkException;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwSystem;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvci.SysparsI;

class Syspars
extends CalSvcDb
implements SysparsI {
    private Collection<String> rootUsers;

    Syspars(CalSvc svci) {
        super(svci);
    }

    public BwSystem get() {
        return new BwSystem();
    }

    public BwSystem get(String name) {
        return new BwSystem();
    }

    public Collection<String> getRootUsers() {
        if (this.rootUsers != null) {
            return this.rootUsers;
        }
        this.rootUsers = new ArrayList<String>();
        String rus = this.getSvc().getSystemProperties().getRootUsers();
        if (rus == null) {
            return this.rootUsers;
        }
        try {
            int pos = 0;
            while (pos < rus.length()) {
                int nextPos = rus.indexOf(",", pos);
                if (nextPos < 0) {
                    this.rootUsers.add(rus.substring(pos));
                    break;
                }
                this.rootUsers.add(rus.substring(pos, nextPos));
                pos = nextPos + 1;
            }
        }
        catch (Throwable t) {
            throw new BedeworkException("org.bedework.exception.badrootuserslist", rus);
        }
        return this.rootUsers;
    }

    public boolean isRootUser(BwPrincipal val) {
        if (val == null || val.getUnauthenticated()) {
            return false;
        }
        if (val.getKind() != 1) {
            return false;
        }
        Collection<String> rus = this.getRootUsers();
        return rus.contains(val.getAccount());
    }

    public boolean present() {
        return false;
    }
}

