/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.Collection;
import org.bedework.base.exc.BedeworkException;
import org.bedework.base.response.GetEntitiesResponse;
import org.bedework.base.response.GetEntityResponse;
import org.bedework.base.response.Response;
import org.bedework.calfacade.BwLocation;
import org.bedework.calfacade.BwString;
import org.bedework.calfacade.filter.SimpleFilterParser;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.EventPropertiesImpl;
import org.bedework.calsvci.Locations;
import org.bedework.util.calendar.PropertyIndex;

public class LocationsImpl
extends EventPropertiesImpl<BwLocation>
implements Locations {
    public LocationsImpl(CalSvc svci) {
        super(svci);
    }

    public void init(boolean adminCanEditAllPublic) {
        super.init(BwLocation.class.getCanonicalName(), adminCanEditAllPublic);
    }

    @Override
    String getDocType() {
        return "location";
    }

    public GetEntityResponse<BwLocation> fetchLocationByKey(String keyName, String keyVal) {
        return this.getIndexer().fetchLocationByKey(keyName, keyVal);
    }

    public GetEntityResponse<BwLocation> fetchLocationByCombined(String val, boolean persisted) {
        GetEntityResponse resp = new GetEntityResponse();
        try {
            BwLocation loc = this.getIndexer().fetchLocation(val, new PropertyIndex.PropertyInfoIndex[]{PropertyIndex.PropertyInfoIndex.LOC_COMBINED_VALUES});
            if (loc == null) {
                return (GetEntityResponse)Response.notOk((Response)resp, (Response.Status)Response.Status.notFound);
            }
            if (!persisted) {
                resp.setEntity((Object)loc);
            } else {
                resp.setEntity((Object)((BwLocation)this.getPersistent(loc.getUid())));
            }
            return (GetEntityResponse)Response.ok((Response)resp, null);
        }
        catch (BedeworkException be) {
            return (GetEntityResponse)Response.error((Response)resp, (Throwable)be);
        }
    }

    @Override
    Collection<BwLocation> fetchAllIndexed(boolean publick, String ownerHref) {
        return this.filterDeleted(this.getIndexer(publick, ownerHref).fetchAllLocations());
    }

    @Override
    BwLocation fetchIndexedByUid(String uid) {
        return this.getIndexer().fetchLocation(uid, new PropertyIndex.PropertyInfoIndex[]{PropertyIndex.PropertyInfoIndex.UID});
    }

    @Override
    BwLocation fetchIndexed(String href) {
        return this.getIndexer().fetchLocation(href, new PropertyIndex.PropertyInfoIndex[]{PropertyIndex.PropertyInfoIndex.HREF});
    }

    @Override
    GetEntityResponse<BwLocation> findPersistent(BwLocation val, String ownerHref) {
        return this.findPersistent(val.getAddress(), ownerHref);
    }

    @Override
    public boolean exists(Response resp, BwLocation val) {
        GetEntityResponse getResp = this.findPersistent(val.getFinderKeyValue(), val.getOwnerHref());
        if (getResp.isError()) {
            Response.fromResponse((Response)resp, getResp);
            return false;
        }
        return getResp.isOk();
    }

    public BwLocation find(BwString val) {
        return this.getIndexer("location").fetchLocation(val.getValue(), new PropertyIndex.PropertyInfoIndex[]{PropertyIndex.PropertyInfoIndex.ADDRESS, PropertyIndex.PropertyInfoIndex.VALUE});
    }

    public GetEntitiesResponse<BwLocation> find(String fexpr, int from, int size) {
        SimpleFilterParser.ParseResult pr = this.getSvc().getFilterParser().parse(fexpr, false, null);
        if (!pr.ok) {
            return (GetEntitiesResponse)Response.error((Response)new GetEntitiesResponse(), (String)pr.message);
        }
        return this.getIndexer().findLocations(pr.filter, from, size);
    }
}

