/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.bedework.access.AccessPrincipal;
import org.bedework.access.CurrentAccess;
import org.bedework.base.exc.BedeworkAccessException;
import org.bedework.base.exc.BedeworkException;
import org.bedework.base.exc.BedeworkForbidden;
import org.bedework.base.response.GetEntityResponse;
import org.bedework.base.response.Response;
import org.bedework.calcorei.CoreCalendarsI;
import org.bedework.caldav.util.sharing.InviteType;
import org.bedework.caldav.util.sharing.UserType;
import org.bedework.calfacade.AliasesInfo;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwCategory;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.CollectionAliases;
import org.bedework.calfacade.base.BwShareableDbentity;
import org.bedework.calfacade.base.ShareableEntity;
import org.bedework.calfacade.configs.BasicSystemProperties;
import org.bedework.calfacade.svc.BwAuthUser;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.calfacade.svc.EventInfo;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvc.Events;
import org.bedework.calsvc.Preferences;
import org.bedework.calsvci.CalendarsI;
import org.bedework.calsvci.ResourcesI;
import org.bedework.calsvci.SynchI;
import org.bedework.util.caching.FlushMap;
import org.bedework.util.misc.Util;
import org.bedework.util.timezones.DateTimeUtil;
import org.bedework.util.xml.tagdefs.AppleServerTags;

class Calendars
extends CalSvcDb
implements CalendarsI {
    private final Map<String, List<BwCalendar>> vpathCache = new HashMap<String, List<BwCalendar>>();
    private long lastVpathFlush = System.currentTimeMillis();
    private long vpathCalls;
    private long vpathHits;
    private final long vpathFlushPeriod = 600000L;
    private final int maxVpathCached = 250;
    private static final Map<String, AliasesInfo> aliasesInfoMap = new FlushMap(100, 1800000L, 1000);

    Calendars(CalSvc svci) {
        super(svci);
    }

    public String getPublicCalendarsRootPath() {
        return BasicSystemProperties.publicCalendarRootPath;
    }

    public BwCalendar getPublicCalendars() {
        return this.getCal().getCollectionIdx(this.getSvc().getIndexer(true, "collection"), BasicSystemProperties.publicCalendarRootPath, 1, true);
    }

    public BwCalendar getPrimaryPublicPath() {
        try {
            return this.findPrimary(this.getPublicCalendars());
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    private BwCalendar findPrimary(BwCalendar root) {
        if (root.getAlias()) {
            return null;
        }
        BwCalendar col = this.resolveAlias(root, true, false);
        if (col == null) {
            return null;
        }
        if (col.getCalType() == 1) {
            if (col.getPrimaryCollection()) {
                return col;
            }
            return null;
        }
        if (root.getCalendarCollection()) {
            return null;
        }
        for (BwCalendar ch : this.getChildren(root)) {
            BwCalendar res = this.findPrimary(ch);
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public String getHomePath() {
        boolean isApprover;
        if (this.isGuest()) {
            return BasicSystemProperties.publicCalendarRootPath;
        }
        if (!this.isPublicAdmin()) {
            if (this.getSvc().getPars().getPublicSubmission()) {
                return Util.buildPath((boolean)false, (String[])new String[]{this.getSvc().getSystemProperties().getSubmissionRoot()});
            }
            return this.getSvc().getPrincipalInfo().getCalendarHomePath();
        }
        if (!this.getSvc().getSystemProperties().getWorkflowEnabled()) {
            return BasicSystemProperties.publicCalendarRootPath;
        }
        BwAuthUser au = this.getSvc().getUserAuth().getUser(this.getPars().getAuthUser());
        boolean bl = isApprover = this.isSuper() || au != null && au.isApproverUser();
        if (isApprover) {
            return BasicSystemProperties.publicCalendarRootPath;
        }
        return Util.buildPath((boolean)false, (String[])new String[]{this.getSvc().getSystemProperties().getWorkflowRoot()});
    }

    public BwCalendar getHome() {
        String home = this.getHomePath();
        BwCalendar cal = this.getCal().getCalendar(home, 1, true);
        if (cal == null) {
            this.warn("No home directory: " + home);
        }
        return cal;
    }

    public BwCalendar getHome(BwPrincipal principal, boolean freeBusy) {
        int priv = freeBusy ? 4 : 1;
        return this.getCal().getCollectionIdx(this.getSvc().getIndexer(false, "collection"), this.getSvc().getPrincipalInfo().getCalendarHomePath((AccessPrincipal)principal), priv, true);
    }

    public BwCalendar getHomeDb(BwPrincipal principal, boolean freeBusy) {
        int priv = freeBusy ? 4 : 1;
        return this.getCal().getCalendar(this.getSvc().getPrincipalInfo().getCalendarHomePath((AccessPrincipal)principal), priv, true);
    }

    public Collection<BwCalendar> decomposeVirtualPath(String vpath) {
        BwPrincipal pr;
        String cacheKey;
        List<BwCalendar> cols;
        ++this.vpathCalls;
        if (this.debug() && this.vpathCalls % 250L == 0L) {
            this.debug("Vpath calls: " + this.vpathCalls);
            this.debug(" Vpath hits: " + this.vpathHits);
            this.debug(" Vpath size: " + this.vpathCache.size());
        }
        if (System.currentTimeMillis() - this.lastVpathFlush > 600000L) {
            this.vpathCache.clear();
            this.lastVpathFlush = System.currentTimeMillis();
        }
        if (this.vpathCache.size() > 250) {
            this.info("Flushing vpath cache - reached max size of 250");
            this.vpathCache.clear();
        }
        if ((cols = this.vpathCache.get(cacheKey = (pr = this.getPrincipal()).getUnauthenticated() ? "*|" + vpath : pr.getPrincipalRef() + "|" + vpath)) != null) {
            ++this.vpathHits;
            return cols;
        }
        cols = new ArrayList<BwCalendar>();
        BwCalendar startCol = this.getIdx(vpath);
        if (startCol != null && !startCol.getAlias()) {
            cols.add(startCol);
            this.vpathCache.put(cacheKey, cols);
            return cols;
        }
        String[] pathEls = this.normalizeUri(vpath).split("/");
        if (pathEls.length == 0) {
            this.vpathCache.put(cacheKey, cols);
            return cols;
        }
        startCol = null;
        String startPath = "";
        int pathi = 1;
        while (pathi < pathEls.length) {
            startPath = Util.buildPath((boolean)false, (String[])new String[]{startPath, "/", pathEls[pathi]});
            ++pathi;
            try {
                startCol = this.getIdx(startPath);
            }
            catch (BedeworkAccessException ignored) {
                startCol = null;
            }
            if (startCol == null) continue;
            if (!this.debug()) break;
            this.debug("Start vpath collection:" + startCol.getPath());
            break;
        }
        if (startCol == null) {
            return null;
        }
        BwCalendar curCol = startCol;
        while (true) {
            cols.add(curCol);
            if (this.debug()) {
                this.debug("      vpath collection:" + curCol.getPath());
            }
            if (curCol.getInternalAlias()) {
                BwCalendar nextCol = this.resolveAliasIdx(curCol, false, false);
                if (nextCol == null) {
                    curCol.setDisabled(true);
                    curCol.setLastRefreshStatus("400");
                    return null;
                }
                curCol = nextCol;
                continue;
            }
            if (pathi >= pathEls.length) break;
            if (curCol.getCalType() != 0) {
                return null;
            }
            BwCalendar col = this.getIdx(Util.buildPath((boolean)false, (String[])new String[]{curCol.getPath(), "/", pathEls[pathi]}));
            if (col == null) {
                return null;
            }
            ++pathi;
            curCol = col;
        }
        curCol.setAliasOrigin(startCol);
        this.vpathCache.put(cacheKey, cols);
        return cols;
    }

    public Collection<BwCalendar> getChildren(BwCalendar col) {
        if (col.getCalType() == 7) {
            this.resolveAlias(col, true, false);
        }
        return this.getCal().getCalendars(col.getAliasedEntity(), null);
    }

    public Collection<BwCalendar> getChildrenIdx(BwCalendar col) {
        if (col.getCalType() == 7) {
            this.resolveAliasIdx(col, true, false);
        }
        return this.getCal().getCalendars(col.getAliasedEntity(), this.getIndexer("collection"));
    }

    public Set<BwCalendar> getAddContentCollections(boolean includeAliases, boolean isApprover) {
        TreeSet<BwCalendar> cals = new TreeSet<BwCalendar>();
        this.getAddContentCalendarCollections(includeAliases, isApprover, this.getHome(), cals);
        return cals;
    }

    public boolean isEmpty(BwCalendar val) {
        return this.getSvc().getCal().isEmpty(val);
    }

    public BwCalendar get(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("bwcal://")) {
            path = path.substring("bwcal://".length());
        }
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return this.getCal().getCalendar(path, 25, false);
    }

    public BwCalendar getIdx(String path) {
        if (path == null) {
            return null;
        }
        if (path.startsWith("bwcal://")) {
            path = path.substring("bwcal://".length());
        }
        if (path.length() > 1 && path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        return this.getCal().getCollectionIdx(this.getIndexer("collection"), path, 25, true);
    }

    public BwCalendar getSpecial(int calType, boolean create) {
        return this.getSpecial(null, calType, create);
    }

    public BwCalendar getSpecial(String principal, int calType, boolean create) {
        BwPrincipal pr = principal == null ? this.getPrincipal() : this.getPrincipal(principal);
        CoreCalendarsI.GetSpecialCalendarResult gscr = this.getSpecialCalendar(pr, calType, create);
        if (!gscr.noUserHome) {
            return gscr.cal;
        }
        this.getSvc().getUsersHandler().add(this.getPrincipal().getAccount());
        return this.getSpecialCalendar((BwPrincipal)pr, (int)calType, (boolean)create).cal;
    }

    public void setPreferred(BwCalendar val) {
        BwPreferences prefs = this.getPrefs();
        prefs.setDefaultCalendarPath(val.getPath());
        this.getSvc().getPrefsHandler().update(prefs);
    }

    public String getPreferred(String entityType) {
        int calType;
        switch (entityType) {
            case "VEVENT": {
                String path = this.getPrefs().getDefaultCalendarPath();
                if (path != null) {
                    return path;
                }
                calType = 1;
                break;
            }
            case "VTODO": {
                calType = 15;
                break;
            }
            case "VPOLL": {
                calType = 12;
                break;
            }
            default: {
                return null;
            }
        }
        CoreCalendarsI.GetSpecialCalendarResult gscr = this.getSpecialCalendar(this.getPrincipal(), calType, true);
        return gscr.cal.getPath();
    }

    public BwCalendar add(BwCalendar val, String parentPath) {
        SynchI synch;
        if (this.getSvc().getPrincipalInfo().getSubscriptionsOnly() && val.getCalType() != 7) {
            throw new BedeworkForbidden("User has read only access");
        }
        this.updateOK(val);
        this.getSvc().setupSharableEntity((ShareableEntity)val, this.getPrincipal().getPrincipalRef());
        if (val.getPwNeedsEncrypt() || val.getExternalSub() && val.getRemotePw() != null) {
            this.encryptPw(val);
        }
        val = this.getCal().add(val, parentPath);
        ((Preferences)this.getSvc().getPrefsHandler()).updateAdminPrefs(false, val, null, null, null);
        if (val.getExternalSub() && !(synch = this.getSvc().getSynch()).subscribe(val)) {
            throw new BedeworkException("org.bedework.exception.subscriptionfailed");
        }
        return val;
    }

    public void rename(BwCalendar val, String newName) {
        this.getSvc().getCal().renameCalendar(val, newName);
    }

    public void move(BwCalendar val, BwCalendar newParent) {
        this.getSvc().getCal().moveCalendar(val, newParent);
    }

    public void update(BwCalendar val) {
        if (!val.getCalendarCollection() && this.isPublicAdmin()) {
            ((Preferences)this.getSvc().getPrefsHandler()).updateAdminPrefs(true, val, null, null, null);
        }
        if (val.getPwNeedsEncrypt()) {
            this.encryptPw(val);
        }
        this.getCal().updateCalendar(val);
    }

    public boolean delete(BwCalendar val, boolean emptyIt, boolean sendSchedulingMessage) {
        return this.delete(val, emptyIt, false, sendSchedulingMessage, true);
    }

    public boolean isUserRoot(BwCalendar cal) {
        if (cal == null || cal.getPath() == null) {
            return false;
        }
        String[] ss = cal.getPath().split("/");
        int pathLength = ss.length - 1;
        return pathLength == 2 && ss[1].equals("user");
    }

    public BwCalendar resolveAlias(BwCalendar val, boolean resolveSubAlias, boolean freeBusy) {
        return this.getCal().resolveAlias(val, resolveSubAlias, freeBusy, null);
    }

    public GetEntityResponse<CollectionAliases> getAliasInfo(BwCalendar val) {
        return this.getCal().getAliasInfo(val);
    }

    public BwCalendar resolveAliasIdx(BwCalendar val, boolean resolveSubAlias, boolean freeBusy) {
        return this.getCal().resolveAlias(val, resolveSubAlias, freeBusy, this.getIndexer("collection"));
    }

    public AliasesInfo getAliasesInfo(String collectionHref, String entityName) {
        AliasesInfo ai = aliasesInfoMap.get(AliasesInfo.makeKey((String)collectionHref, (String)entityName));
        if (ai != null) {
            return ai;
        }
        ai = this.getAliasesInfo(collectionHref);
        if (ai == null) {
            return null;
        }
        if (!ai.getShared()) {
            return ai;
        }
        AliasesInfo mapAi = aliasesInfoMap.get(AliasesInfo.makeKey((String)collectionHref, (String)entityName));
        if (mapAi != null) {
            return mapAi;
        }
        Events eventsH = (Events)this.getSvc().getEventsHandler();
        boolean isVisible = eventsH.isVisible(ai.getCollection(), entityName);
        AliasesInfo eai = ai.copyForEntity(entityName, isVisible);
        this.checkAliases(eai, entityName);
        return this.updateAliasInfoMap(eai);
    }

    public CalendarsI.SynchStatusResponse getSynchStatus(String path) {
        return this.getSvc().getSynch().getSynchStatus(this.get(path));
    }

    public CalendarsI.CheckSubscriptionResult checkSubscription(String path) {
        return this.getSvc().getSynch().checkSubscription(this.get(path));
    }

    public Response refreshSubscription(BwCalendar val) {
        return this.getSvc().getSynch().refresh(val);
    }

    public String getSyncToken(String path) {
        return this.getCal().getSyncToken(path);
    }

    public boolean getSyncTokenIsValid(String token, String path) {
        if (token == null) {
            return false;
        }
        try {
            int pos = token.indexOf("-");
            if (pos < 0) {
                return false;
            }
            Date date = DateTimeUtil.fromISODateTimeUTC((String)token.substring(0, pos));
            if (date == null) {
                return false;
            }
            int maxMins = this.getSvc().getSystemProperties().getSynchMaxMinutes();
            if (maxMins <= 0) {
                this.warn("No max value set for systemProperties.synchMaxMinutes");
                return true;
            }
            long millis = new Date().getTime() - date.getTime();
            long mins = millis / 1000L / 60L;
            return mins <= (long)maxMins;
        }
        catch (Throwable ignored) {
            return false;
        }
    }

    public Set<BwCategory> getCategorySet(String href) {
        Collection<BwCalendar> cols = this.decomposeVirtualPath(href);
        if (Util.isEmpty(cols)) {
            if (this.debug()) {
                this.debug("No collections for vpath " + href);
            }
            return null;
        }
        BwCalendar curCol = null;
        TreeSet<BwCategory> cats = new TreeSet<BwCategory>();
        for (BwCalendar col : cols) {
            int numCats = 0;
            Set colCats = col.getCategories();
            if (!Util.isEmpty((Collection)colCats)) {
                for (BwCategory colCat : colCats) {
                    if (!colCat.unsaved()) {
                        cats.add(colCat);
                        continue;
                    }
                    BwCategory theCat = (BwCategory)this.getSvc().getCategoriesHandler().getPersistent(colCat.getUid());
                    if (theCat == null) continue;
                    cats.add(theCat);
                }
                numCats = colCats.size();
            }
            if (this.debug()) {
                this.debug("For col " + col.getPath() + " found " + numCats);
            }
            if (!col.getAlias()) continue;
            curCol = col;
        }
        while (curCol != null) {
            try {
                if ((curCol = this.get(curCol.getColPath())) == null || Util.isEmpty((Collection)curCol.getCategories())) continue;
                cats.addAll(curCol.getCategories());
            }
            catch (BedeworkAccessException ignored) {
                break;
            }
        }
        return cats;
    }

    public BwCalendar getSpecial(BwPrincipal owner, int calType, boolean create, int access) {
        CoreCalendarsI.GetSpecialCalendarResult gscr = this.getSpecialCalendar(owner, calType, create);
        if (gscr.noUserHome) {
            this.getSvc().getUsersHandler().add(owner.getAccount());
        }
        return this.getSpecialCalendar((BwPrincipal)owner, (int)calType, (boolean)create).cal;
    }

    CoreCalendarsI.GetSpecialCalendarResult getSpecialCalendar(BwPrincipal owner, int calType, boolean create) {
        return this.getCal().getSpecialCalendar(null, owner, calType, create, 25);
    }

    List<BwCalendar> findUserAlias(String val) {
        return this.getCal().findAlias(val);
    }

    Set<BwCalendar> getSynchCols(String path, String lastmod) {
        return this.getCal().getSynchCols(path, lastmod);
    }

    boolean delete(BwCalendar val, boolean emptyIt, boolean reallyDelete, boolean sendSchedulingMessage, boolean unsubscribe) {
        if (!emptyIt && !this.getCal().isEmpty(val)) {
            throw new BedeworkException("org.bedework.exception.calendarnotempty");
        }
        BwPreferences prefs = this.getPrefs(this.getPrincipal(val.getOwnerHref()));
        if (val.getPath().equals(prefs.getDefaultCalendarPath())) {
            throw new BedeworkException("org.bedework.exception.cannotdeletedefaultcalendar");
        }
        if (val.getCanAlias()) {
            this.getSvc().getSharingHandler().delete(val, sendSchedulingMessage);
        }
        if (unsubscribe) {
            this.getSvc().getSharingHandler().unsubscribe(val);
        }
        this.getSvc().getSynch().unsubscribe(val, true);
        if (!val.getSpecial()) {
            ((Preferences)this.getSvc().getPrefsHandler()).updateAdminPrefs(true, val, null, null, null);
        }
        if (!val.getInternalAlias() && emptyIt) {
            ResourcesI resI;
            List rs;
            if (val.getCalendarCollection()) {
                Events events = (Events)this.getSvc().getEventsHandler();
                for (EventInfo ei : events.getSynchEvents(val.getPath(), null)) {
                    Response delresp = events.delete(ei, false, sendSchedulingMessage, true);
                    if (delresp.isOk()) continue;
                    throw new BedeworkException("Failed to delete " + ei.getHref() + " response: " + delresp);
                }
            }
            if (!Util.isEmpty((Collection)(rs = (resI = this.getSvc().getResourcesHandler()).getAll(val.getPath())))) {
                for (BwResource r : rs) {
                    resI.delete(Util.buildPath((boolean)false, (String[])new String[]{r.getColPath(), "/", r.getName()}));
                }
            }
            for (BwCalendar cal : this.getChildren(val)) {
                if (this.delete(cal, true, true, sendSchedulingMessage, true)) continue;
                this.getSvc().rollbackTransaction();
                throw new BedeworkException("org.bedework.exception.calendarnotfound", cal.getPath());
            }
        }
        if (val.getSpecial()) {
            return true;
        }
        val.getProperties().clear();
        return this.getSvc().getCal().deleteCalendar(val, reallyDelete);
    }

    private void checkAliases(AliasesInfo rootAi, String entityName) {
        Events eventsH = (Events)this.getSvc().getEventsHandler();
        for (AliasesInfo ai : rootAi.getAliases()) {
            boolean isVisible = eventsH.isVisible(ai.getCollection(), entityName);
            AliasesInfo eai = ai.copyForEntity(entityName, isVisible);
            rootAi.addSharee(eai);
            this.checkAliases(eai, entityName);
        }
    }

    private AliasesInfo getAliasesInfo(String collectionHref) {
        AliasesInfo ai = aliasesInfoMap.get(AliasesInfo.makeKey((String)collectionHref, null));
        if (ai != null) {
            return ai;
        }
        BwCalendar col = this.getCal().getCalendar(collectionHref, 25, true);
        if (col == null) {
            return null;
        }
        ai = new AliasesInfo(this.getPrincipal().getPrincipalRef(), col, null);
        this.findAliases(col, ai);
        return this.updateAliasInfoMap(ai);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void findAliases(BwCalendar col, AliasesInfo rootAi) {
        boolean defaultEnabled;
        String collectionHref = col.getPath();
        boolean bl = defaultEnabled = !Boolean.parseBoolean(System.getProperty("org.bedework.nochangenote", "false")) && this.getSvc().getAuthProperties().getDefaultChangesNotifications();
        if (this.notificationsEnabled(col, defaultEnabled)) {
            rootAi.setNotificationsEnabled(true);
        }
        for (BwCalendar alias : ((Calendars)this.getCols()).findUserAlias(collectionHref)) {
            AliasesInfo ai = new AliasesInfo(this.getPrincipal().getPrincipalRef(), alias, null);
            rootAi.addSharee(ai);
            this.findAliases(alias, ai);
        }
        InviteType invite = this.getSvc().getSharingHandler().getInviteStatus(col);
        if (invite == null) {
            return;
        }
        for (UserType u : invite.getUsers()) {
            BwPrincipal principal = this.caladdrToPrincipal(u.getHref());
            if (principal == null) {
                AliasesInfo ai = new AliasesInfo(u.getHref(), col, null);
                ai.setExternalCua(true);
                rootAi.addSharee(ai);
                continue;
            }
            try {
                this.getSvc().pushPrincipal(principal);
                for (BwCalendar alias : ((Calendars)this.getCols()).findUserAlias(collectionHref)) {
                    if (!this.notificationsEnabled(alias, defaultEnabled)) continue;
                    AliasesInfo ai = new AliasesInfo(principal.getPrincipalRef(), alias, null);
                    rootAi.addSharee(ai);
                    this.findAliases(alias, ai);
                }
            }
            finally {
                this.getSvc().popPrincipal();
            }
        }
    }

    private boolean notificationsEnabled(BwCalendar col, boolean defaultEnabled) {
        if (col.getPublick().booleanValue()) {
            return true;
        }
        String enabledVal = col.getQproperty(AppleServerTags.notifyChanges);
        if (enabledVal == null) {
            return defaultEnabled;
        }
        return Boolean.parseBoolean(enabledVal);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AliasesInfo updateAliasInfoMap(AliasesInfo ai) {
        Map<String, AliasesInfo> map = aliasesInfoMap;
        synchronized (map) {
            String key = ai.makeKey();
            AliasesInfo mapAi = aliasesInfoMap.get(key);
            if (mapAi != null) {
                return mapAi;
            }
            aliasesInfoMap.put(key, ai);
            return ai;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAliasInfo(String val) {
        Map<String, AliasesInfo> map = aliasesInfoMap;
        synchronized (map) {
            ArrayList<AliasesInfo> removals = new ArrayList<AliasesInfo>();
            for (AliasesInfo ai : aliasesInfoMap.values()) {
                if (!ai.referencesCollection(val)) continue;
                removals.add(ai);
            }
            for (AliasesInfo ai : removals) {
                aliasesInfoMap.remove(ai.makeKey());
            }
        }
    }

    private void getAddContentCalendarCollections(boolean includeAliases, boolean isApprover, BwCalendar root, Set<BwCalendar> cals) {
        if (!includeAliases && root.getAlias()) {
            return;
        }
        BwCalendar col = this.resolveAlias(root, true, false);
        if (col == null) {
            return;
        }
        if (col.getCalType() == 1) {
            if (this.isPublicAdmin() && isApprover && !col.getPrimaryCollection()) {
                return;
            }
            CurrentAccess ca = this.getSvc().checkAccess((ShareableEntity)col, 8, true);
            if (ca.getAccessAllowed()) {
                cals.add(root);
            }
            return;
        }
        if (root.getCalendarCollection()) {
            return;
        }
        for (BwCalendar ch : this.getChildren(root)) {
            this.getAddContentCalendarCollections(includeAliases, isApprover, ch, cals);
        }
    }

    private void encryptPw(BwCalendar val) {
        try {
            val.setRemotePw(this.getSvc().getEncrypter().encrypt(val.getRemotePw()));
        }
        catch (Throwable t) {
            throw new BedeworkException(t);
        }
    }

    private void updateOK(Object o) {
        if (this.isGuest()) {
            throw new BedeworkAccessException();
        }
        if (this.isSuper()) {
            return;
        }
        if (!(o instanceof BwShareableDbentity)) {
            throw new BedeworkAccessException();
        }
        if (!this.isPublicAdmin()) {
            return;
        }
        BwShareableDbentity ent = (BwShareableDbentity)o;
        if (this.getPars().getAdminCanEditAllPublicContacts() || ent.getCreatorHref().equals(this.getPrincipal().getPrincipalRef())) {
            return;
        }
        throw new BedeworkAccessException();
    }

    private String normalizeUri(String uri) {
        try {
            uri = new URI(null, null, uri, null).toString();
            uri = new URI(URLEncoder.encode(uri, StandardCharsets.UTF_8)).normalize().getPath();
            uri = Util.buildPath((boolean)false, (String[])new String[]{URLDecoder.decode(uri, StandardCharsets.UTF_8)});
            if (this.debug()) {
                this.debug("Normalized uri=" + uri);
            }
            return uri;
        }
        catch (Throwable t) {
            if (this.debug()) {
                this.error(t);
            }
            throw new RuntimeException("Bad uri: " + uri);
        }
    }
}

