/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.calsvc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.TreeSet;
import org.bedework.access.Access;
import org.bedework.access.AccessException;
import org.bedework.access.AccessPrincipal;
import org.bedework.access.Ace;
import org.bedework.access.AceWho;
import org.bedework.access.Acl;
import org.bedework.access.CurrentAccess;
import org.bedework.access.Privilege;
import org.bedework.base.exc.BedeworkException;
import org.bedework.calfacade.BwCalendar;
import org.bedework.calfacade.BwPrincipal;
import org.bedework.calfacade.BwResource;
import org.bedework.calfacade.base.ShareableEntity;
import org.bedework.calfacade.svc.BwAdminGroup;
import org.bedework.calfacade.svc.BwCalSuite;
import org.bedework.calfacade.svc.BwPreferences;
import org.bedework.calfacade.svc.wrappers.BwCalSuiteWrapper;
import org.bedework.calsvc.CalSvc;
import org.bedework.calsvc.CalSvcDb;
import org.bedework.calsvci.CalSuitesI;
import org.bedework.util.misc.Util;

class CalSuites
extends CalSvcDb
implements CalSuitesI {
    private BwCalSuiteWrapper currentCalSuite;

    CalSuites(CalSvc svci) {
        super(svci);
    }

    public BwCalSuiteWrapper add(String name, String adminGroupName, String rootCollectionPath, String description) {
        BwCalSuite cs = this.getCal().getCalSuite(name);
        if (cs != null) {
            throw new BedeworkException("org.bedework.svci.duplicate.calsuite");
        }
        cs = new BwCalSuite();
        cs.setName(name);
        cs.setDescription(description);
        this.setRootCol(cs, rootCollectionPath);
        this.getSvc().setupSharableEntity((ShareableEntity)cs, this.getPrincipal().getPrincipalRef());
        HomeAndOwner ho = this.validateGroup(cs, adminGroupName);
        this.getCal().add(cs);
        this.setAccess(cs, ho);
        return this.wrap(cs, false);
    }

    public void set(BwCalSuiteWrapper val) {
        this.currentCalSuite = val;
    }

    public BwCalSuiteWrapper get() {
        if (this.currentCalSuite == null) {
            return null;
        }
        this.checkCollections((BwCalSuite)this.currentCalSuite);
        return this.currentCalSuite;
    }

    private void checkCollections(BwCalSuite cs) {
        if (cs.getRootCollection() == null && cs.getRootCollectionPath() != null) {
            cs.setRootCollection(this.getCols().get(cs.getRootCollectionPath()));
        }
    }

    public BwCalSuiteWrapper get(String name) {
        BwCalSuite cs = this.getCal().getCalSuite(name);
        if (cs == null) {
            return null;
        }
        this.checkCollections(cs);
        return this.wrap(cs, false);
    }

    public BwCalSuiteWrapper get(BwAdminGroup group) {
        BwCalSuite cs = this.getCal().get(group);
        if (cs == null) {
            return null;
        }
        this.checkCollections(cs);
        return this.wrap(cs, false);
    }

    public Collection<BwCalSuite> getAll() {
        Collection css = this.getCal().getAllCalSuites();
        TreeSet<BwCalSuite> retCss = new TreeSet<BwCalSuite>();
        for (BwCalSuite cs : css) {
            this.checkCollections(cs);
            BwCalSuiteWrapper w = this.wrap(cs, true);
            if (w == null) continue;
            retCss.add((BwCalSuite)w);
        }
        return retCss;
    }

    public void update(BwCalSuiteWrapper csw, String adminGroupName, String rootCollectionPath, String description) {
        BwCalSuite cs = csw.fetchEntity();
        if (adminGroupName != null) {
            HomeAndOwner ho = this.validateGroup(cs, adminGroupName);
            this.setAccess(cs, ho);
        }
        cs.setDescription(description);
        this.setRootCol(cs, rootCollectionPath);
        this.getCal().update(cs);
    }

    public void delete(BwCalSuiteWrapper val) {
        this.getCal().delete(val.fetchEntity());
    }

    public String getResourcesPath(BwCalSuite suite, CalSuitesI.ResourceClass cl) {
        if (cl == CalSuitesI.ResourceClass.global) {
            return "/public/Resources/";
        }
        BwPrincipal eventsOwner = this.getPrincipal(suite.getGroup().getOwnerHref());
        String home = this.getSvc().getPrincipalInfo().getCalendarHomePath((AccessPrincipal)eventsOwner);
        BwPreferences prefs = this.getPrefs(eventsOwner);
        String col = null;
        if (cl == CalSuitesI.ResourceClass.admin) {
            col = prefs.getAdminResourcesDirectory();
            if (col == null) {
                col = ".adminResources";
            }
        } else if (cl == CalSuitesI.ResourceClass.calsuite && (col = prefs.getSuiteResourcesDirectory()) == null) {
            col = ".csResources";
        }
        if (col != null) {
            return Util.buildPath((boolean)false, (String[])new String[]{home, "/", col});
        }
        throw new RuntimeException("System error");
    }

    public List<BwResource> getResources(BwCalSuite suite, CalSuitesI.ResourceClass cl) {
        return this.getRess().getAll(this.getResourcesPath(suite, cl));
    }

    public BwResource getResource(BwCalSuite suite, String name, CalSuitesI.ResourceClass cl) {
        try {
            BwResource r = this.getRess().get(Util.buildPath((boolean)false, (String[])new String[]{this.getResourcesPath(suite, cl), "/", name}));
            if (r != null) {
                this.getRess().getContent(r);
            }
            return r;
        }
        catch (BedeworkException be) {
            if ("org.bedework.exception.calendarnotfound".equals(be.getMessage())) {
                return null;
            }
            throw be;
        }
    }

    public void addResource(BwCalSuite suite, BwResource res, CalSuitesI.ResourceClass cl) {
        res.setColPath(this.getResourcesPath(suite, cl));
        this.getRess().save(res, false);
    }

    public void deleteResource(BwCalSuite suite, String name, CalSuitesI.ResourceClass cl) {
        this.getRess().delete(Util.buildPath((boolean)false, (String[])new String[]{this.getResourcesPath(suite, cl), "/", name}));
    }

    private BwCalendar getResourcesDir(BwCalSuite suite, CalSuitesI.ResourceClass cl) {
        String path = this.getResourcesPath(suite, cl);
        if (path == null) {
            throw new BedeworkException("org.bedework.svci.no.calsuite.resource.collection");
        }
        BwCalendar resCol = this.getCols().get(path);
        if (resCol != null) {
            return resCol;
        }
        resCol = new BwCalendar();
        resCol.setName(path.substring(path.lastIndexOf("/") + 1));
        resCol.setSummary(resCol.getName());
        resCol.setCreatorHref(suite.getOwnerHref());
        if (cl == CalSuitesI.ResourceClass.calsuite) {
            resCol.setOwnerHref(suite.getOwnerHref());
        } else {
            resCol.setOwnerHref(this.getPublicUser().getPrincipalRef());
        }
        String parentPath = path.substring(0, path.lastIndexOf("/"));
        resCol = this.getCols().add(resCol, parentPath);
        try {
            ArrayList<Privilege> readPrivs = new ArrayList<Privilege>();
            readPrivs.add(Access.read);
            ArrayList<Ace> aces = new ArrayList<Ace>();
            aces.add(Ace.makeAce((AceWho)AceWho.all, readPrivs, null));
            this.getSvc().changeAccess((ShareableEntity)resCol, aces, true);
        }
        catch (AccessException ae) {
            throw new BedeworkException((Throwable)ae);
        }
        return resCol;
    }

    private void setRootCol(BwCalSuite cs, String rootCollectionPath) {
        if (rootCollectionPath == null || rootCollectionPath.equals(cs.getRootCollectionPath())) {
            return;
        }
        BwCalendar rootCol = this.getCols().get(rootCollectionPath);
        if (rootCol == null) {
            throw new BedeworkException("org.bedework.svci.calsuite.unknown.root.collection", rootCollectionPath);
        }
        cs.setRootCollection(rootCol);
        cs.setRootCollectionPath(rootCol.getPath());
    }

    private HomeAndOwner validateGroup(BwCalSuite cs, String groupName) {
        if (groupName.length() > 255) {
            throw new BedeworkException("org.bedework.svci.calsuite.group.name.too.long");
        }
        BwAdminGroup agrp = (BwAdminGroup)this.getSvc().getAdminDirectories().findGroup(groupName);
        if (agrp == null) {
            throw new BedeworkException("org.bedework.exception.groupnotfound", groupName);
        }
        BwCalSuiteWrapper csw = this.get(agrp);
        if (csw != null && !csw.equals((Object)cs)) {
            throw new BedeworkException("org.bedework.svci.calsuite.group.assigned", csw.getName());
        }
        BwPrincipal eventsOwner = this.getPrincipal(agrp.getOwnerHref());
        if (eventsOwner == null) {
            throw new BedeworkException("org.bedework.svci.calsuite.badowner");
        }
        BwCalendar home = this.getCols().getHomeDb(eventsOwner, true);
        if (home == null) {
            throw new BedeworkException("org.bedework.svci.calsuite.missing.group.owner.home");
        }
        cs.setGroup(agrp);
        return new HomeAndOwner(home, eventsOwner);
    }

    private void setAccess(BwCalSuite cs, HomeAndOwner ho) {
        ArrayList<Privilege> allPrivs = new ArrayList<Privilege>();
        allPrivs.add(Access.all);
        ArrayList<Privilege> readPrivs = new ArrayList<Privilege>();
        readPrivs.add(Access.read);
        ArrayList<Ace> aces = new ArrayList<Ace>();
        try {
            aces.add(Ace.makeAce((AceWho)AceWho.owner, allPrivs, null));
            aces.add(Ace.makeAce((AceWho)AceWho.getAceWho((String)ho.eventsOwner().getAccount(), (int)1, (boolean)false), allPrivs, null));
            aces.add(Ace.makeAce((AceWho)AceWho.getAceWho(null, (int)8, (boolean)false), readPrivs, null));
            aces.add(Ace.makeAce((AceWho)AceWho.all, readPrivs, null));
            this.getSvc().changeAccess((ShareableEntity)ho.home(), aces, true);
            this.getSvc().changeAccess((ShareableEntity)cs, aces, true);
            String aclStr = new String(new Acl(aces).encode());
            ho.eventsOwner().setCategoryAccess(aclStr);
            ho.eventsOwner().setLocationAccess(aclStr);
            ho.eventsOwner().setContactAccess(aclStr);
        }
        catch (AccessException ae) {
            throw new BedeworkException((Throwable)ae);
        }
        this.getSvc().getUsersHandler().update(ho.eventsOwner());
    }

    private BwCalSuiteWrapper wrap(BwCalSuite cs, boolean alwaysReturn) {
        CurrentAccess ca = this.checkAccess((ShareableEntity)cs, 25, alwaysReturn);
        if (ca == null || !ca.getAccessAllowed()) {
            return null;
        }
        BwCalSuiteWrapper w = new BwCalSuiteWrapper(cs, ca);
        BwAdminGroup agrp = cs.getGroup();
        if (agrp == null) {
            return w;
        }
        BwPrincipal eventsOwner = this.getSvc().getUsersHandler().getPrincipal(agrp.getOwnerHref());
        if (eventsOwner == null) {
            return w;
        }
        w.setResourcesHome(this.getSvc().getPrincipalInfo().getCalendarHomePath((AccessPrincipal)eventsOwner));
        return w;
    }

    private record HomeAndOwner(BwCalendar home, BwPrincipal<?> eventsOwner) {
    }
}

