/*
 * Decompiled with CFR 0.152.
 */
package org.bedework.webdav.servlet.common;

import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.namespace.QName;
import org.bedework.base.response.GetEntityResponse;
import org.bedework.util.misc.Util;
import org.bedework.util.xml.XmlUtil;
import org.bedework.util.xml.tagdefs.WebdavTags;
import org.bedework.webdav.servlet.common.Headers;
import org.bedework.webdav.servlet.common.MethodBase;
import org.bedework.webdav.servlet.shared.WebdavBadRequest;
import org.bedework.webdav.servlet.shared.WebdavException;
import org.bedework.webdav.servlet.shared.WebdavNsIntf;
import org.bedework.webdav.servlet.shared.WebdavNsNode;
import org.bedework.webdav.servlet.shared.WebdavProperty;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PropFindMethod
extends MethodBase {
    private PropRequest parsedReq;

    @Override
    public void init() {
    }

    @Override
    public void doMethod(HttpServletRequest req, HttpServletResponse resp) {
        Document doc;
        if (this.debug()) {
            this.debug("PropFindMethod: doMethod");
        }
        if ((doc = this.parseContent(req, resp)) == null) {
            this.parsedReq = new PropRequest(PropRequest.ReqType.propAll);
        } else {
            this.processDoc(doc);
        }
        int depth = Headers.depth(req);
        if (depth == Integer.MIN_VALUE) {
            depth = Integer.MAX_VALUE;
        }
        if (this.parsedReq == null) {
            throw new WebdavBadRequest("PROPFIND: unexpected element");
        }
        if (this.debug()) {
            this.debug("PropFindMethod: depth=" + depth);
            this.debug("                type=" + this.parsedReq.reqType);
        }
        this.processResp(req, resp, depth);
    }

    private void processDoc(Document doc) {
        try {
            Element root = doc.getDocumentElement();
            if (!XmlUtil.nodeMatches((Node)root, (QName)WebdavTags.propfind)) {
                throw new WebdavBadRequest();
            }
            GetEntityResponse<Element> childResp = this.getOnlyChild(root);
            if (!childResp.isOk()) {
                throw new WebdavBadRequest(childResp.getMessage());
            }
            Element curnode = (Element)childResp.getEntity();
            String ns = curnode.getNamespaceURI();
            this.addNs(ns);
            if (this.debug()) {
                String nm = curnode.getLocalName();
                this.debug("reqtype: " + nm + " ns: " + ns);
            }
            this.parsedReq = this.tryPropRequest(curnode);
        }
        catch (WebdavException wde) {
            throw wde;
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            if (this.debug()) {
                this.error(t);
            }
            throw new WebdavException(500);
        }
    }

    public PropRequest tryPropRequest(Node nd) {
        if (XmlUtil.nodeMatches((Node)nd, (QName)WebdavTags.allprop)) {
            return new PropRequest(PropRequest.ReqType.propAll);
        }
        if (XmlUtil.nodeMatches((Node)nd, (QName)WebdavTags.prop)) {
            return this.parseProps(nd);
        }
        if (XmlUtil.nodeMatches((Node)nd, (QName)WebdavTags.propname)) {
            return new PropRequest(PropRequest.ReqType.propName);
        }
        return null;
    }

    public PropRequest parseProps(Node nd) {
        PropRequest pr = new PropRequest(PropRequest.ReqType.prop);
        pr.props = this.getNsIntf().parseProp(nd);
        return pr;
    }

    public void processResp(HttpServletRequest req, HttpServletResponse resp, int depth) {
        String resourceUri = this.getResourceUri(req);
        if (this.debug()) {
            this.debug("About to get node at " + resourceUri);
        }
        int nodeType = resourceUri.endsWith("/") ? 0 : 3;
        WebdavNsNode node = this.getNsIntf().getNode(resourceUri, 1, nodeType, false);
        if (node == null) {
            resp.setStatus(404);
            return;
        }
        this.addHeaders(req, resp, node);
        resp.setStatus(207);
        resp.setContentType("text/xml; charset=UTF-8");
        this.startEmit(resp);
        this.openTag(WebdavTags.multistatus);
        this.doNodeAndChildren(node, 0, depth);
        this.closeTag(WebdavTags.multistatus);
        this.flush();
    }

    public void doNodeProperties(WebdavNsNode node, PropRequest pr) {
        boolean propNameOrAll;
        node.generateHref(this.xml);
        boolean bl = propNameOrAll = pr.reqType == PropRequest.ReqType.propName || pr.reqType == PropRequest.ReqType.propAll;
        if (!propNameOrAll && Util.isEmpty(pr.props) || !node.getExists()) {
            this.openTag(WebdavTags.propstat);
            if (node.getStatus() == 200) {
                this.emptyTag(WebdavTags.prop);
            }
            this.addStatus(node.getStatus(), null);
            this.closeTag(WebdavTags.propstat);
            return;
        }
        if (propNameOrAll) {
            this.openTag(WebdavTags.propstat);
            if (this.debug()) {
                this.debug("doNodeProperties type=" + pr.reqType);
            }
            if (pr.reqType == PropRequest.ReqType.propName) {
                this.doPropNames(node);
            } else if (pr.reqType == PropRequest.ReqType.propAll) {
                this.doPropAll(node);
            }
            this.addStatus(node.getStatus(), null);
            this.closeTag(WebdavTags.propstat);
            return;
        }
        if (pr.reqType != PropRequest.ReqType.prop) {
            throw new WebdavBadRequest();
        }
        this.doPropFind(node, pr.props);
    }

    private void doNodeAndChildren(WebdavNsNode node, int curDepth, int maxDepth) {
        this.openTag(WebdavTags.response);
        this.doNodeProperties(node, this.parsedReq);
        this.closeTag(WebdavTags.response);
        this.flush();
        if (++curDepth > maxDepth) {
            return;
        }
        for (WebdavNsNode child : this.getNsIntf().getChildren(node, null)) {
            this.doNodeAndChildren(child, curDepth, maxDepth);
        }
    }

    private void doPropNames(WebdavNsNode node) {
        this.openTag(WebdavTags.prop);
        for (WebdavNsNode.PropertyTagEntry pte : node.getPropertyNames()) {
            if (!pte.inPropAll) continue;
            this.emptyTag(pte.tag);
        }
        this.closeTag(WebdavTags.prop);
    }

    private int doPropAll(WebdavNsNode node) {
        WebdavNsIntf intf = this.getNsIntf();
        this.openTag(WebdavTags.prop);
        this.doLockDiscovery(node);
        String sl = this.getNsIntf().getSupportedLocks();
        if (sl != null) {
            this.property(WebdavTags.supportedlock, sl);
        }
        for (WebdavNsNode.PropertyTagEntry pte : node.getPropertyNames()) {
            if (!pte.inPropAll) continue;
            intf.generatePropValue(node, new WebdavProperty(pte.tag, null), true);
        }
        this.closeTag(WebdavTags.prop);
        return 200;
    }

    private void doLockDiscovery(WebdavNsNode node) {
    }

    public static class PropRequest {
        public ReqType reqType;
        public List<WebdavProperty> props;

        PropRequest(ReqType reqType) {
            this.reqType = reqType;
        }

        public static enum ReqType {
            prop,
            propName,
            propAll;

        }
    }
}

