/*
 * Decompiled with CFR 0.152.
 */
package org.beangle.data.jdbc.engine;

import java.io.Serializable;
import java.sql.Connection;
import javax.sql.DataSource;
import org.beangle.commons.lang.Strings$;
import org.beangle.data.jdbc.engine.DB2;
import org.beangle.data.jdbc.engine.Derby;
import org.beangle.data.jdbc.engine.Engine;
import org.beangle.data.jdbc.engine.H2;
import org.beangle.data.jdbc.engine.HSQL;
import org.beangle.data.jdbc.engine.MySQL;
import org.beangle.data.jdbc.engine.Oracle;
import org.beangle.data.jdbc.engine.PostgreSQL;
import org.beangle.data.jdbc.engine.SQLServer;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Engines$
implements Serializable {
    private static final HashMap<String, Engine> name2Engines;
    public static final Engines$ MODULE$;

    private Engines$() {
    }

    static {
        MODULE$ = new Engines$();
        name2Engines = new HashMap();
        MODULE$.register((Seq<Engine>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Engine[]{new PostgreSQL("[8.4)"), new MySQL("[5.0,)"), new H2("[1.3,)"), new HSQL("[2.0.0,)"), new Oracle("[10.1)"), new DB2("[8.0]"), new SQLServer("[2005,2012)"), new Derby("10.5.3.0")}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Engines$.class);
    }

    private void register(Seq<Engine> engines) {
        engines.foreach((Function1 & Serializable)engine -> name2Engines.put((Object)engine.name(), engine));
    }

    public Engine forDataSource(DataSource ds) {
        Connection connection = ds.getConnection();
        String name = connection.getMetaData().getDatabaseProductName();
        connection.close();
        return this.forName(name);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Engine forName(String dbname) {
        Engine engine;
        String name = Strings$.MODULE$.capitalize(dbname);
        Option option = name2Engines.get((Object)(name = name.replace("sql", "SQL")));
        if (option instanceof Some) {
            Engine engine2;
            engine = engine2 = (Engine)((Some)option).value();
            return engine;
        } else {
            if (!None$.MODULE$.equals(option)) throw new MatchError((Object)option);
            if (dbname.toUpperCase().startsWith("DB2")) {
                engine = (Engine)name2Engines.apply((Object)"DB2");
                return engine;
            } else {
                if (!dbname.toUpperCase().startsWith("SQLSERVER") && !dbname.startsWith("Microsoft SQL Server")) throw new RuntimeException("Cannot find engine for database " + dbname);
                engine = (Engine)name2Engines.apply((Object)"Microsoft SQL Server");
            }
        }
        return engine;
    }

    public Engine H2() {
        return this.forName("H2");
    }

    public Engine MySQL() {
        return this.forName("MySQL");
    }

    public Engine PostgreSQL() {
        return this.forName("PostgreSQL");
    }

    public Engine Oracle() {
        return this.forName("Oracle");
    }

    public Engine DB2() {
        return this.forName("DB2");
    }

    public Engine HSQL() {
        return this.forName("HSQL Database Engine");
    }

    public Engine SQLServer() {
        return this.forName("Microsoft SQL Server");
    }

    public Engine Derby() {
        return this.forName("Derby");
    }
}

