/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.mojo;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.project.DefaultDependencyResolutionRequest;
import org.apache.maven.project.DefaultProjectBuildingRequest;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectBuildingRequest;
import org.apache.maven.project.ProjectBuildingResult;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.basepom.inline.mojo.PluginLog;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.transfer.ArtifactTransferException;
import org.eclipse.aether.transfer.NoRepositoryLayoutException;

final class DependencyBuilder {
    private static final PluginLog LOG = new PluginLog(DependencyBuilder.class);
    private final MavenProject rootProject;
    private final MavenSession mavenSession;
    private final ProjectBuilder projectBuilder;
    private final ProjectDependenciesResolver projectDependenciesResolver;
    private final List<MavenProject> reactorProjects;

    DependencyBuilder(MavenProject rootProject, MavenSession mavenSession, ProjectBuilder projectBuilder, ProjectDependenciesResolver projectDependenciesResolver, List<MavenProject> reactorProjects) {
        this.rootProject = rootProject;
        this.mavenSession = mavenSession;
        this.projectBuilder = projectBuilder;
        this.projectDependenciesResolver = projectDependenciesResolver;
        this.reactorProjects = ImmutableList.copyOf(reactorProjects);
    }

    ImmutableList<Dependency> mapDependency(Dependency dependency, DependencyFilter projectScopeFilter) throws DependencyResolutionException, ProjectBuildingException {
        Preconditions.checkNotNull((Object)dependency, (Object)"dependency is null");
        ProjectBuildingResult result = this.projectBuilder.build(DependencyBuilder.convertFromAetherDependency(dependency), false, this.createProjectBuildingRequest());
        MavenProject project = result.getProject();
        return this.mapProject(project, projectScopeFilter);
    }

    ImmutableList<Dependency> mapProject(MavenProject project, DependencyFilter scopeFilter) throws DependencyResolutionException {
        DependencyResolutionResult result;
        block6: {
            Preconditions.checkNotNull((Object)project, (Object)"project is null");
            DefaultDependencyResolutionRequest request = new DefaultDependencyResolutionRequest();
            request.setRepositorySession(this.createProjectBuildingRequest().getRepositorySession());
            request.setMavenProject(project);
            request.setResolutionFilter(scopeFilter);
            try {
                result = this.projectDependenciesResolver.resolve((DependencyResolutionRequest)request);
            }
            catch (DependencyResolutionException e) {
                result = e.getResult();
                ImmutableSet reactorProjects = (ImmutableSet)this.reactorProjects.stream().map(ProjectKey::fromProject).collect(ImmutableSet.toImmutableSet());
                ImmutableSet reactorDependencies = (ImmutableSet)result.getUnresolvedDependencies().stream().filter(d -> reactorProjects.contains((Object)ProjectKey.fromDependency(d))).collect(ImmutableSet.toImmutableSet());
                result.getUnresolvedDependencies().removeAll((Collection<?>)reactorDependencies);
                result.getResolvedDependencies().addAll(reactorDependencies);
                ImmutableSet systemDependencies = (ImmutableSet)result.getUnresolvedDependencies().stream().filter(d -> "system".equals(d.getScope())).collect(ImmutableSet.toImmutableSet());
                result.getUnresolvedDependencies().removeAll((Collection<?>)systemDependencies);
                result.getResolvedDependencies().addAll(systemDependencies);
                ImmutableSet optionalDependencies = (ImmutableSet)result.getUnresolvedDependencies().stream().filter(Dependency::isOptional).collect(ImmutableSet.toImmutableSet());
                result.getUnresolvedDependencies().removeAll((Collection<?>)optionalDependencies);
                result.getResolvedDependencies().addAll(optionalDependencies);
                if (result.getUnresolvedDependencies().isEmpty()) break block6;
                Throwable t = Throwables.getRootCause((Throwable)e);
                RemoteRepository repository = null;
                if (t instanceof NoRepositoryLayoutException) {
                    repository = ((NoRepositoryLayoutException)t).getRepository();
                } else if (t instanceof ArtifactTransferException) {
                    repository = ((ArtifactTransferException)t).getRepository();
                }
                if (repository != null && "legacy".equals(repository.getContentType())) {
                    LOG.warn("Could not access a legacy repository for artifacts:  %s; Reason: %s", result.getUnresolvedDependencies(), t.getMessage());
                }
                throw e;
            }
        }
        return ImmutableList.copyOf((Collection)result.getResolvedDependencies());
    }

    static org.apache.maven.artifact.Artifact convertFromAetherDependency(Dependency dependency) {
        org.apache.maven.artifact.Artifact mavenArtifact = RepositoryUtils.toArtifact((Artifact)DependencyBuilder.convertToPomArtifact(dependency.getArtifact()));
        mavenArtifact.setScope(dependency.getScope());
        mavenArtifact.setOptional(dependency.isOptional());
        return mavenArtifact;
    }

    private ProjectBuildingRequest createProjectBuildingRequest() {
        DefaultProjectBuildingRequest buildingRequest = new DefaultProjectBuildingRequest(this.mavenSession.getProjectBuildingRequest());
        buildingRequest.setRemoteRepositories(this.rootProject.getRemoteArtifactRepositories());
        return buildingRequest;
    }

    static Artifact convertToPomArtifact(Artifact artifact) {
        if (artifact.getClassifier().isEmpty() && "pom".equals(artifact.getExtension())) {
            return artifact;
        }
        return new DefaultArtifact(artifact.getGroupId(), artifact.getArtifactId(), "pom", artifact.getVersion());
    }

    private static final class ProjectKey {
        private final String groupId;
        private final String artifactId;
        private final String version;

        public static ProjectKey fromProject(MavenProject project) {
            Preconditions.checkNotNull((Object)project, (Object)"project; is null");
            return new ProjectKey(project.getGroupId(), project.getArtifactId(), project.getVersion());
        }

        public static ProjectKey fromDependency(Dependency dependency) {
            Preconditions.checkNotNull((Object)dependency, (Object)"artifact; is null");
            return new ProjectKey(dependency.getArtifact().getGroupId(), dependency.getArtifact().getArtifactId(), dependency.getArtifact().getVersion());
        }

        private ProjectKey(String groupId, String artifactId, String version) {
            this.groupId = (String)Preconditions.checkNotNull((Object)groupId, (Object)"groupId is null");
            this.artifactId = (String)Preconditions.checkNotNull((Object)artifactId, (Object)"artifactId is null");
            this.version = (String)Preconditions.checkNotNull((Object)version, (Object)"version is null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ProjectKey that = (ProjectKey)o;
            return this.groupId.equals(that.groupId) && this.artifactId.equals(that.artifactId) && this.version.equals(that.version);
        }

        public int hashCode() {
            return Objects.hash(this.groupId, this.artifactId, this.version);
        }
    }
}

