/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.mojo;

import com.google.common.io.CharStreams;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Objects;
import org.apache.maven.model.Model;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.basepom.inline.mojo.PomUtil;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestPomUtil {
    @Test
    public void testRoundTrip() throws Exception {
        String pomContents = CharStreams.toString((Readable)new InputStreamReader(TestPomUtil.class.getResourceAsStream("/testPom.xml")));
        PomUtil pomUtil = new PomUtil(pomContents);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pomContents.length() + 20);
             OutputStreamWriter streamWriter = new OutputStreamWriter(byteArrayOutputStream);){
            pomUtil.writePom(streamWriter);
            String result = new String(byteArrayOutputStream.toByteArray(), StandardCharsets.UTF_8);
            MavenXpp3Reader reader = new MavenXpp3Reader();
            MavenXpp3Writer writer = new MavenXpp3Writer();
            StringWriter origWriter = new StringWriter();
            StringWriter newWriter = new StringWriter();
            writer.write((Writer)origWriter, reader.read((Reader)new StringReader(pomContents)));
            writer.write((Writer)newWriter, reader.read((Reader)new StringReader(result)));
            Assertions.assertEquals((Object)newWriter.toString(), (Object)origWriter.toString());
        }
    }

    @Test
    public void testRemove() throws Exception {
        String pomContents = CharStreams.toString((Readable)new InputStreamReader(TestPomUtil.class.getResourceAsStream("/testPom.xml")));
        PomUtil pomUtil = new PomUtil(pomContents);
        Dependency dependency = new Dependency((Artifact)new DefaultArtifact("org.jdbi", "jdbi3-core", null, null), null);
        pomUtil.removeDependency(dependency);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pomContents.length() + 20);
             OutputStreamWriter writer = new OutputStreamWriter(byteArrayOutputStream);){
            pomUtil.writePom(writer);
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            Assertions.assertNotNull((Object)model);
            List dependencies = model.getDependencies();
            org.apache.maven.model.Dependency coreDependency = new org.apache.maven.model.Dependency();
            coreDependency.setArtifactId("jdbi3-core");
            coreDependency.setGroupId("org.jdbi");
            coreDependency.setVersion("3.24.0");
            org.apache.maven.model.Dependency testDependency = new org.apache.maven.model.Dependency();
            testDependency.setArtifactId("jdbi3-core");
            testDependency.setGroupId("org.jdbi");
            testDependency.setVersion("3.24.0");
            testDependency.setClassifier("tests");
            Assertions.assertTrue((boolean)this.containsDependency(dependencies, testDependency));
            Assertions.assertFalse((boolean)this.containsDependency(dependencies, coreDependency));
        }
    }

    @Test
    public void testRemoveWithClassifier() throws Exception {
        String pomContents = CharStreams.toString((Readable)new InputStreamReader(TestPomUtil.class.getResourceAsStream("/testPom.xml")));
        PomUtil pomUtil = new PomUtil(pomContents);
        Dependency dependency = new Dependency((Artifact)new DefaultArtifact("org.jdbi", "jdbi3-core", "tests", null, null), null);
        pomUtil.removeDependency(dependency);
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pomContents.length() + 20);
             OutputStreamWriter writer = new OutputStreamWriter(byteArrayOutputStream);){
            pomUtil.writePom(writer);
            MavenXpp3Reader reader = new MavenXpp3Reader();
            Model model = reader.read((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
            Assertions.assertNotNull((Object)model);
            List dependencies = model.getDependencies();
            org.apache.maven.model.Dependency coreDependency = new org.apache.maven.model.Dependency();
            coreDependency.setArtifactId("jdbi3-core");
            coreDependency.setGroupId("org.jdbi");
            coreDependency.setVersion("3.24.0");
            org.apache.maven.model.Dependency testDependency = new org.apache.maven.model.Dependency();
            testDependency.setArtifactId("jdbi3-core");
            testDependency.setGroupId("org.jdbi");
            testDependency.setVersion("3.24.0");
            testDependency.setClassifier("tests");
            Assertions.assertFalse((boolean)this.containsDependency(dependencies, testDependency));
            Assertions.assertTrue((boolean)this.containsDependency(dependencies, coreDependency));
        }
    }

    boolean containsDependency(Iterable<org.apache.maven.model.Dependency> dependencies, org.apache.maven.model.Dependency dependency) {
        for (org.apache.maven.model.Dependency d : dependencies) {
            if (!Objects.equals(d.getArtifactId(), dependency.getArtifactId()) || !Objects.equals(d.getGroupId(), dependency.getGroupId()) || !Objects.equals(d.getVersion(), dependency.getVersion()) || !Objects.equals(d.getClassifier(), dependency.getClassifier())) continue;
            return true;
        }
        return false;
    }
}

