/*
 * Decompiled with CFR 0.152.
 */
package org.basepom.inline.mojo;

import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.io.CharStreams;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.project.ProjectBuilder;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.basepom.inline.mojo.DependencyBuilder;
import org.basepom.inline.mojo.InlineDependency;
import org.basepom.inline.mojo.PluginLog;
import org.basepom.inline.mojo.PomUtil;
import org.basepom.inline.mojo.ScopeLimitingFilter;
import org.basepom.inline.transformer.ClassPath;
import org.basepom.inline.transformer.ClassPathResource;
import org.basepom.inline.transformer.ClassPathTag;
import org.basepom.inline.transformer.JarTransformer;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.graph.Dependency;
import org.jdom2.JDOMException;

@Mojo(name="inline", defaultPhase=LifecyclePhase.PACKAGE, requiresProject=true, threadSafe=true, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, requiresDependencyCollection=ResolutionScope.COMPILE_PLUS_RUNTIME)
public final class InlineMojo
extends AbstractMojo {
    private static final PluginLog LOG = new PluginLog(InlineMojo.class);
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    public MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    public MavenSession mavenSession;
    @Parameter(defaultValue="${reactorProjects}", readonly=true, required=true)
    public List<MavenProject> reactorProjects;
    @Component
    public ProjectBuilder mavenProjectBuilder;
    @Component
    public ProjectDependenciesResolver projectDependenciesResolver;
    @Component
    public RepositorySystem repositorySystem;
    @Component
    public MavenProjectHelper projectHelper;
    @Parameter(defaultValue="${project.build.directory}")
    public File outputDirectory = null;
    @Parameter(property="inline.pomFile", defaultValue="${project.file}")
    public File pomFile = null;
    @Parameter
    private List<InlineDependency> inlineDependencies = ImmutableList.of();
    @Parameter(defaultValue="false", property="inline.skip")
    public boolean skip = false;
    @Parameter(defaultValue="false", property="inline.quiet")
    public boolean quiet = false;
    @Parameter(required=true, property="inline.prefix")
    public String prefix = null;
    @Parameter(defaultValue="true", property="inline.requireProvided")
    public boolean requireProvided = true;
    @Parameter(defaultValue="true", property="inline.requireOptional")
    public boolean requireOptional = true;
    @Parameter(defaultValue="true", property="inline.failOnNoMatch")
    public boolean failOnNoMatch = true;
    @Parameter
    public File outputJarFile = null;
    @Parameter
    public File outputPomFile = null;
    @Parameter(defaultValue="false", property="inline.attachArtifact")
    public boolean inlinedArtifactAttached = false;
    @Parameter(defaultValue="true", property="inline.replacePomFile")
    public boolean replacePomFile = true;
    @Parameter(defaultValue="inlined")
    public String inlinedClassifierName = "inlined";

    public void setInlineDependencies(List<InlineDependency> inlineDependencies) {
        this.inlineDependencies = ImmutableList.copyOf(inlineDependencies);
    }

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            LOG.report(this.quiet, "skipping plugin execution", new Object[0]);
            return;
        }
        if ("pom".equals(this.project.getPackaging())) {
            LOG.report(this.quiet, "ignoring POM project", new Object[0]);
            return;
        }
        try {
            ImmutableSetMultimap.Builder dependencyBuilder = ImmutableSetMultimap.builder();
            ImmutableSet.Builder pomDependenciesToAdd = ImmutableSet.builder();
            if (this.computeDependencyMap((ImmutableSetMultimap.Builder<InlineDependency, Dependency>)dependencyBuilder, (ImmutableSet.Builder<Dependency>)pomDependenciesToAdd)) {
                throw new MojoExecutionException("Could not inline dependencies!");
            }
            ImmutableSetMultimap dependencyMap = dependencyBuilder.build();
            this.rewriteJarFile((ImmutableSetMultimap<InlineDependency, Dependency>)dependencyMap);
            this.rewritePomFile((Set<Dependency>)pomDependenciesToAdd.build(), (Set<Dependency>)ImmutableSet.copyOf((Collection)dependencyMap.values()));
        }
        catch (UncheckedIOException e) {
            throw new MojoExecutionException((Throwable)e.getCause());
        }
        catch (IOException | XMLStreamException | DependencyResolutionException | ProjectBuildingException | JDOMException e) {
            throw new MojoExecutionException(e);
        }
    }

    private boolean computeDependencyMap(ImmutableSetMultimap.Builder<InlineDependency, Dependency> builder, ImmutableSet.Builder<Dependency> pomBuilder) throws DependencyResolutionException, ProjectBuildingException {
        DependencyBuilder dependencyBuilder = new DependencyBuilder(this.project, this.mavenSession, this.mavenProjectBuilder, this.projectDependenciesResolver, this.reactorProjects);
        ImmutableList projectDependencies = dependencyBuilder.mapProject(this.project, ScopeLimitingFilter.computeDependencyScope("compile+runtime"));
        Map dependencyScopes = (Map)projectDependencies.stream().filter(dependency -> dependency.getArtifact() != null).collect(ImmutableMap.toImmutableMap(this::getId, (Function)Functions.identity()));
        projectDependencies = (ImmutableList)projectDependencies.stream().filter(this.createFilterSet()).collect(ImmutableList.toImmutableList());
        boolean error = false;
        BiConsumer<InlineDependency, Dependency> dependencyConsumer = (inlineDependency, dependency) -> {
            LOG.debug("%s matches %s for inlining.", inlineDependency, dependency);
            LOG.report(this.quiet, "Inlining %s.", this.getId((Dependency)dependency));
            builder.put(inlineDependency, dependency);
        };
        for (InlineDependency inlineDependency2 : this.inlineDependencies) {
            boolean foundMatch = false;
            for (Dependency projectDependency : projectDependencies) {
                if (!inlineDependency2.matchDependency(projectDependency)) continue;
                foundMatch = true;
                dependencyConsumer.accept(inlineDependency2, projectDependency);
                Consumer<Dependency> consumer = inlineDependency2.isTransitive() ? dependency -> dependencyConsumer.accept(inlineDependency2, (Dependency)dependency) : arg_0 -> pomBuilder.add(arg_0);
                dependencyBuilder.mapDependency(projectDependency, ScopeLimitingFilter.computeTransitiveScope(projectDependency.getScope())).stream().map(dependency -> dependencyScopes.getOrDefault(this.getId((Dependency)dependency), dependency)).filter(this.createFilterSet()).forEach(consumer);
            }
            if (foundMatch) continue;
            LOG.error("No matches for '%s' found!", inlineDependency2);
            error = this.failOnNoMatch;
        }
        return error;
    }

    private String getId(Dependency dependency) {
        org.eclipse.aether.artifact.Artifact artifact = dependency.getArtifact();
        Preconditions.checkState((artifact != null ? 1 : 0) != 0, (String)"Artifact for dependency %s is null!", (Object)dependency);
        return Joiner.on((char)':').join((Object)artifact.getGroupId(), (Object)artifact.getArtifactId(), new Object[]{artifact.getClassifier()});
    }

    private Predicate<Dependency> createFilterSet() {
        Predicate<Dependency> predicate = dependency -> !"system".equals(dependency.getScope());
        if (this.requireProvided) {
            predicate = predicate.and(dependency -> "provided".equals(dependency.getScope()));
        }
        if (this.requireOptional) {
            predicate = predicate.and(Dependency::isOptional);
        }
        return predicate;
    }

    private void rewriteJarFile(ImmutableSetMultimap<InlineDependency, Dependency> dependencies) throws IOException {
        File outputJar = this.outputJarFile != null ? this.outputJarFile : this.inlinedArtifactFileWithClassifier();
        this.doJarTransformation(outputJar, dependencies);
        if (this.outputJarFile == null) {
            if (this.inlinedArtifactAttached) {
                LOG.info("Attaching inlined artifact.", new Object[0]);
                this.projectHelper.attachArtifact(this.project, this.project.getArtifact().getType(), this.inlinedClassifierName, outputJar);
            } else {
                LOG.info("Replacing original artifact with inlined artifact.", new Object[0]);
                File originalArtifact = this.project.getArtifact().getFile();
                if (originalArtifact != null) {
                    File backupFile = new File(originalArtifact.getParentFile(), "original-" + originalArtifact.getName());
                    Files.move(originalArtifact.toPath(), backupFile.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                    Files.move(outputJar.toPath(), originalArtifact.toPath(), StandardCopyOption.ATOMIC_MOVE, StandardCopyOption.REPLACE_EXISTING);
                }
            }
        }
    }

    private void rewritePomFile(Set<Dependency> dependenciesToAdd, Set<Dependency> dependenciesToRemove) throws IOException, XMLStreamException, JDOMException {
        String pomContents;
        try (FileReader reader = new FileReader(this.project.getFile(), StandardCharsets.UTF_8);){
            pomContents = CharStreams.toString((Readable)reader);
        }
        PomUtil pomUtil = new PomUtil(pomContents);
        dependenciesToRemove.forEach(pomUtil::removeDependency);
        dependenciesToAdd.forEach(pomUtil::addDependency);
        File newPomFile = this.outputPomFile != null ? this.outputPomFile : new File(this.outputDirectory, "new-" + this.pomFile.getName());
        try (FileWriter writer = new FileWriter(newPomFile, StandardCharsets.UTF_8);){
            pomUtil.writePom(writer);
        }
        if (this.replacePomFile) {
            this.project.setPomFile(newPomFile);
        }
    }

    private void doJarTransformation(File outputJar, ImmutableSetMultimap<InlineDependency, Dependency> dependencies) throws IOException {
        try (JarOutputStream jarOutputStream = new JarOutputStream(new FileOutputStream(outputJar));){
            Consumer<ClassPathResource> jarConsumer = this.getJarWriter(jarOutputStream);
            JarTransformer transformer = new JarTransformer(jarConsumer);
            ClassPath classPath = new ClassPath(this.project.getBasedir());
            classPath.addFile(this.project.getArtifact().getFile(), new ClassPathTag[]{ClassPathTag.ROOT_JAR});
            dependencies.forEach((inlineDependency, dependency) -> classPath.addFile(dependency.getArtifact().getFile(), this.prefix, inlineDependency.isHideClasses(), new ClassPathTag[0]));
            transformer.transform(classPath);
        }
    }

    private Consumer<ClassPathResource> getJarWriter(JarOutputStream jarOutputStream) {
        return classPathResource -> {
            try {
                String name = classPathResource.getName();
                LOG.debug(String.format("Writing '%s' to jar", name), new Object[0]);
                JarEntry outputEntry = new JarEntry(name);
                outputEntry.setTime(classPathResource.getLastModifiedTime());
                outputEntry.setCompressedSize(-1L);
                jarOutputStream.putNextEntry(outputEntry);
                jarOutputStream.write(classPathResource.getContent());
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    private File inlinedArtifactFileWithClassifier() {
        Artifact artifact = this.project.getArtifact();
        String inlineName = String.format("%s-%s-%s.%s", this.project.getArtifactId(), artifact.getVersion(), this.inlinedClassifierName, artifact.getArtifactHandler().getExtension());
        return new File(this.outputDirectory, inlineName);
    }
}

