(ns scratch
  (:require [babashka.cli :as cli]))

(def global-spec {:config  {:desc "Config edn file to use"
                            :coerce []}
                  :verbose {:coerce :boolean}})
(def dns-spec {})
(def dns-get-spec {})

(def table
  [{:cmds []            :fn identity :spec global-spec}
   {:cmds ["dns"]       :fn identity :spec dns-spec}
   {:cmds ["dns" "get"] :fn identity :spec dns-get-spec}])

(defn -main
  [& args]
  (prn (cli/dispatch table (vec args))))

(when (= *file* (System/getProperty "babashka.file"))
  (apply -main *command-line-args*))

(comment
  ;; Correct
  (cli/dispatch table ["--config" "config-dev.edn"])
  #_ {:dispatch [], :opts {:config ["config-dev.edn"]}, :args nil}

  ;; Correct
  (cli/dispatch table ["--config" "config-dev.edn" "--config" "other.edn"])
  #_ {:dispatch [],
      :opts {:config ["config-dev.edn" "other.edn"]},
      :args nil}

  ;; Correct
  (cli/dispatch table ["--config" "config-dev.edn" "--config" "other.edn" "--verbose"])
  #_ {:dispatch [],
      :opts {:config ["config-dev.edn" "other.edn"], :verbose true},
      :args nil}

  ;; Incorrect
  (cli/dispatch table ["--config" "config-dev.edn" "--config" "other.edn" "dns"]
                {:spec global-spec})
  #_ {:dispatch [], :opts {:config ["config-dev.edn" "other.edn" "dns"]}, :args nil}
  ;; Expected
  #_ {:dispatch ["dns"], :opts {:config ["config-dev.edn" "other.edn"]}, :args nil}

  ;; Incorrect
  (cli/dispatch table ["--config" "config-dev.edn" "--config" "other.edn" "dns" "get"])
  #_ {:dispatch [],
      :opts {:config ["config-dev.edn" "other.edn" "dns" "get"]},
      :args nil}
  ;; Expected
  #_ {:dispatch ["dns" "get"],
      :opts {:config ["config-dev.edn" "other.edn"]},
      :args nil}

  ;; Correct - the --verbose flag seems to break up everything getting dragged into :config
  (cli/dispatch table ["--config" "config-dev.edn" "--config" "other.edn" "--verbose" "dns" "get"])
  #_ {:dispatch ["dns" "get"],
      :opts {:config ["config-dev.edn" "other.edn"], :verbose true},
      :args nil}

  ;; Incorrect
  (cli/dispatch table ["--config" "config-dev.edn" "--verbose" "--config" "other.edn" "dns" "get"])
  #_ {:dispatch [],
      :opts {:config ["config-dev.edn" "other.edn" "dns" "get"], :verbose true},
      :args nil}
  ;; Expected
  #_ {:dispatch ["dns" "get"],
      :opts {:config ["config-dev.edn" "other.edn"], :verbose true},
      :args nil}

  ;; Incorrect
  (cli/dispatch table ["--config" "config-dev.edn" "--config=other.edn" "dns" "get"])
  #_ {:dispatch [],
      :opts {:config ["config-dev.edn" "other.edn" "dns" "get"]},
      :args nil}
  ;; Expected
  #_ {:dispatch ["dns" "get"],
      :opts {:config ["config-dev.edn" "other.edn"]},
      :args nil}

  ;; Correct
  (cli/dispatch table ["dns" "get"])
  #_ {:dispatch ["dns" "get"], :opts {}, :args nil}

  )
