/*
 * Decompiled with CFR 0.152.
 */
package babashka.impl;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.jar.JarFile;

public class URLClassLoader
extends java.net.URLClassLoader
implements Closeable {
    private WeakHashMap<Closeable, Void> closeables = new WeakHashMap();

    public URLClassLoader(URL[] uRLArray) {
        super(uRLArray);
    }

    public URLClassLoader(URL[] uRLArray, java.net.URLClassLoader uRLClassLoader) {
        super(uRLArray, (ClassLoader)uRLClassLoader);
    }

    public void _addURL(URL uRL) {
        super.addURL(uRL);
    }

    @Override
    public URL getResource(String string) {
        return this.findResource(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getResourceAsStream(String string) {
        Objects.requireNonNull(string);
        URL uRL = this.getResource(string);
        try {
            if (uRL == null) {
                return null;
            }
            URLConnection uRLConnection = uRL.openConnection();
            InputStream inputStream = uRLConnection.getInputStream();
            if (uRLConnection instanceof JarURLConnection) {
                JarFile jarFile = ((JarURLConnection)uRLConnection).getJarFile();
                WeakHashMap<Closeable, Void> weakHashMap = this.closeables;
                synchronized (weakHashMap) {
                    if (!this.closeables.containsKey(jarFile)) {
                        this.closeables.put(jarFile, null);
                    }
                }
            }
            WeakHashMap<Closeable, Void> weakHashMap = this.closeables;
            synchronized (weakHashMap) {
                this.closeables.put(inputStream, null);
            }
            return inputStream;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        return this.findResources(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        super.close();
        ArrayList<IOException> arrayList = new ArrayList<IOException>();
        Object object = this.closeables;
        synchronized (object) {
            Set<Closeable> set = this.closeables.keySet();
            Iterator<Closeable> object2 = set.iterator();
            while (object2.hasNext()) {
                Closeable closeable = object2.next();
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    arrayList.add(iOException);
                }
            }
            this.closeables.clear();
        }
        if (arrayList.isEmpty()) {
            return;
        }
        object = (IOException)arrayList.remove(0);
        for (IOException iOException : arrayList) {
            ((Throwable)object).addSuppressed(iOException);
        }
        throw object;
    }
}

