/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.spring.config;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.axonframework.common.annotation.Internal;
import org.axonframework.common.configuration.ApplicationConfigurer;
import org.axonframework.common.configuration.AxonConfiguration;
import org.axonframework.common.configuration.ComponentRegistry;
import org.axonframework.common.configuration.Configuration;
import org.axonframework.common.configuration.LifecycleRegistry;
import org.axonframework.common.infra.ComponentDescriptor;
import org.axonframework.extension.spring.config.SpringComponentRegistry;
import org.axonframework.extension.spring.config.SpringLifecycleRegistry;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Internal
@Component
public class SpringAxonApplication
implements ApplicationConfigurer {
    private final SpringComponentRegistry componentRegistry;
    private final SpringLifecycleRegistry lifecycleRegistry;

    @Internal
    @Autowired
    public SpringAxonApplication(@Nonnull SpringComponentRegistry componentRegistry, @Nonnull SpringLifecycleRegistry lifecycleRegistry) {
        this.componentRegistry = Objects.requireNonNull(componentRegistry, "The componentRegistry may not be null.");
        this.lifecycleRegistry = Objects.requireNonNull(lifecycleRegistry, "The lifecycleRegistry may not be null.");
    }

    public ApplicationConfigurer componentRegistry(@Nonnull Consumer<ComponentRegistry> componentRegistrar) {
        componentRegistrar.accept(this.componentRegistry);
        return this;
    }

    public ApplicationConfigurer lifecycleRegistry(@Nonnull Consumer<LifecycleRegistry> lifecycleRegistrar) {
        lifecycleRegistrar.accept(this.lifecycleRegistry);
        return this;
    }

    public AxonConfiguration build() {
        return new AxonConfiguration(){

            public void start() {
            }

            public void shutdown() {
            }

            @Nonnull
            public <C> C getComponent(@Nonnull Class<C> type) {
                return (C)SpringAxonApplication.this.componentRegistry.configuration().getComponent(type);
            }

            @Nonnull
            public <C> C getComponent(@Nonnull Class<C> type, @Nullable String name) {
                return (C)SpringAxonApplication.this.componentRegistry.configuration().getComponent(type, name);
            }

            public <C> Optional<C> getOptionalComponent(@Nonnull Class<C> type) {
                return SpringAxonApplication.this.componentRegistry.configuration().getOptionalComponent(type);
            }

            public <C> Optional<C> getOptionalComponent(@Nonnull Class<C> type, @Nullable String name) {
                return SpringAxonApplication.this.componentRegistry.configuration().getOptionalComponent(type, name);
            }

            @Nonnull
            public <C> C getComponent(@Nonnull Class<C> type, @Nullable String name, @Nonnull Supplier<C> defaultImpl) {
                return (C)SpringAxonApplication.this.componentRegistry.configuration().getComponent(type, name, defaultImpl);
            }

            @Nonnull
            public <C> C getComponent(@Nonnull Class<C> type, @Nonnull Supplier<C> defaultImpl) {
                return (C)SpringAxonApplication.this.componentRegistry.configuration().getComponent(type, defaultImpl);
            }

            public List<Configuration> getModuleConfigurations() {
                return SpringAxonApplication.this.componentRegistry.configuration().getModuleConfigurations();
            }

            public Optional<Configuration> getModuleConfiguration(@Nonnull String name) {
                return SpringAxonApplication.this.componentRegistry.configuration().getModuleConfiguration(name);
            }

            @Nullable
            public Configuration getParent() {
                return SpringAxonApplication.this.componentRegistry.configuration().getParent();
            }

            @Nonnull
            public <C> Map<String, C> getComponents(@Nonnull Class<C> type) {
                return SpringAxonApplication.this.componentRegistry.configuration().getComponents(type);
            }

            public void describeTo(@Nonnull ComponentDescriptor descriptor) {
                descriptor.describeProperty("components", (Object)SpringAxonApplication.this.componentRegistry);
            }
        };
    }
}

