/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.spring.conversion.avro;

import jakarta.annotation.Nonnull;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.axonframework.extension.spring.conversion.avro.AvroSchemaScan;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ImportBeanDefinitionRegistrar;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class AvroSchemaPackages {
    private static final String BEAN = AvroSchemaPackages.class.getCanonicalName();
    private static final AvroSchemaPackages NONE = new AvroSchemaPackages(new String[0]);
    private final List<String> packages;

    @Nonnull
    public static AvroSchemaPackages get(BeanFactory beanFactory) {
        try {
            return (AvroSchemaPackages)beanFactory.getBean(BEAN, AvroSchemaPackages.class);
        }
        catch (NoSuchBeanDefinitionException e) {
            return NONE;
        }
    }

    AvroSchemaPackages(String ... packages) {
        this.packages = Arrays.stream(packages).filter(StringUtils::hasText).collect(Collectors.toList());
    }

    public List<String> getPackages() {
        return this.packages;
    }

    static class AvroSchemaScanPackagesBeanDefinition
    extends GenericBeanDefinition {
        private final LinkedHashSet<String> packageNames = new LinkedHashSet();

        AvroSchemaScanPackagesBeanDefinition(Collection<String> packageNames) {
            this.setBeanClass(AvroSchemaPackages.class);
            this.setRole(2);
            this.addPackageNames(packageNames);
        }

        public Supplier<?> getInstanceSupplier() {
            return () -> new AvroSchemaPackages(StringUtils.toStringArray(this.packageNames));
        }

        public void addPackageNames(Collection<String> packageNames) {
            this.packageNames.addAll(packageNames);
            this.getConstructorArgumentValues().addIndexedArgumentValue(0, (Object)StringUtils.toStringArray(this.packageNames));
        }
    }

    static class Registrar
    implements ImportBeanDefinitionRegistrar {
        private final Environment environment;

        Registrar(@Nonnull Environment environment) {
            Assert.notNull((Object)environment, (String)"Environment must not be null");
            this.environment = environment;
        }

        public static void register(@Nonnull BeanDefinitionRegistry registry, @Nonnull Set<String> packageNames) {
            Assert.notNull((Object)registry, (String)"Registry must not be null");
            Assert.notNull(packageNames, (String)"PackageNames must not be null");
            if (registry.containsBeanDefinition(BEAN)) {
                AvroSchemaScanPackagesBeanDefinition beanDefinition = (AvroSchemaScanPackagesBeanDefinition)registry.getBeanDefinition(BEAN);
                beanDefinition.addPackageNames(packageNames);
            } else {
                registry.registerBeanDefinition(BEAN, (BeanDefinition)new AvroSchemaScanPackagesBeanDefinition(packageNames));
            }
        }

        public static Set<String> getPackagesToScan(Environment environment, AnnotationMetadata metadata, String annotationClassName, String annotationAttributePackages, String annotationAttributePackageClasses) {
            AnnotationAttributes attributes = Objects.requireNonNull(AnnotationAttributes.fromMap((Map)metadata.getAnnotationAttributes(annotationClassName)));
            LinkedHashSet<String> packagesToScan = new LinkedHashSet<String>();
            for (String basePackage : attributes.getStringArray(annotationAttributePackages)) {
                String[] tokenized = StringUtils.tokenizeToStringArray((String)environment.resolvePlaceholders(basePackage), (String)",; \t\n");
                Collections.addAll(packagesToScan, tokenized);
            }
            for (Class basePackageClass : attributes.getClassArray(annotationAttributePackageClasses)) {
                packagesToScan.add(environment.resolvePlaceholders(ClassUtils.getPackageName((Class)basePackageClass)));
            }
            if (packagesToScan.isEmpty()) {
                String packageName = ClassUtils.getPackageName((String)metadata.getClassName());
                Assert.state((boolean)StringUtils.hasLength((String)packageName), (String)("@" + annotationClassName + " cannot be used with the default package"));
                return Collections.singleton(packageName);
            }
            return packagesToScan;
        }

        public void registerBeanDefinitions(@Nonnull AnnotationMetadata importingClassMetadata, @Nonnull BeanDefinitionRegistry registry) {
            Registrar.register(registry, Registrar.getPackagesToScan(this.environment, importingClassMetadata, AvroSchemaScan.class.getName(), "basePackages", "basePackageClasses"));
        }
    }
}

