/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.spring.authorization;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.axonframework.common.annotations.AnnotationUtils;
import org.axonframework.extension.spring.authorization.UnauthorizedMessageException;
import org.axonframework.messaging.Message;
import org.axonframework.messaging.MessageStream;
import org.axonframework.messaging.annotations.HandlerEnhancerDefinition;
import org.axonframework.messaging.annotations.MessageHandlingMember;
import org.axonframework.messaging.annotations.WrappedMessageHandlingMember;
import org.axonframework.messaging.unitofwork.ProcessingContext;
import org.springframework.security.access.annotation.Secured;

public class SecuredMessageHandlerDefinition
implements HandlerEnhancerDefinition {
    public <T> MessageHandlingMember<T> wrapHandler(@Nonnull MessageHandlingMember<T> original) {
        return original.unwrap(Executable.class).map(executable -> AnnotationUtils.findAnnotationAttributes((AnnotatedElement)executable, Secured.class).orElse(Map.of())).filter(attributes -> attributes.containsKey("secured")).map(attributes -> (String[])attributes.get("secured")).map(securityConfiguration -> new SecuredMessageHandlingMember(original, (String[])securityConfiguration)).orElse(original);
    }

    private static class SecuredMessageHandlingMember<T>
    extends WrappedMessageHandlingMember<T> {
        private final Set<String> requiredRoles;

        public SecuredMessageHandlingMember(MessageHandlingMember<T> delegate, String[] securityConfiguration) {
            super(delegate);
            this.requiredRoles = new HashSet<String>(Arrays.asList(securityConfiguration));
        }

        public MessageStream<?> handle(@Nonnull Message message, @Nonnull ProcessingContext context, @Nullable T target) {
            if (!this.hasRequiredRoles(message)) {
                throw new UnauthorizedMessageException("Unauthorized message with identifier [" + message.identifier() + "]");
            }
            return super.handle(message, context, target);
        }

        private boolean hasRequiredRoles(@Nonnull Message message) {
            HashSet<String> authorities = new HashSet<String>();
            if (message.metadata().containsKey((Object)"authorities")) {
                authorities.addAll(Arrays.asList(message.metadata().get((Object)"authorities").split(",")));
            }
            authorities.retainAll(this.requiredRoles);
            return !authorities.isEmpty();
        }
    }
}

