/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.springboot.autoconfig;

import jakarta.annotation.Nonnull;
import org.axonframework.common.configuration.ComponentDefinition;
import org.axonframework.common.configuration.ComponentRegistry;
import org.axonframework.common.configuration.ConfigurationEnhancer;
import org.axonframework.extension.springboot.UpdateCheckerProperties;
import org.axonframework.update.UpdateChecker;
import org.axonframework.update.UpdateCheckerHttpClient;
import org.axonframework.update.UpdateCheckerReporter;
import org.axonframework.update.configuration.UsagePropertyProvider;
import org.axonframework.update.detection.TestEnvironmentDetector;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Condition;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.core.type.AnnotatedTypeMetadata;

@AutoConfiguration
@EnableConfigurationProperties(value={UpdateCheckerProperties.class})
public class UpdateCheckerAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean
    @Conditional(value={NotTestEnvironmentCondition.class})
    public UsagePropertyProvider usagePropertyProvider(UpdateCheckerProperties properties) {
        return UsagePropertyProvider.create((UsagePropertyProvider[])new UsagePropertyProvider[]{properties});
    }

    @Bean
    @Conditional(value={NotTestEnvironmentCondition.class})
    public ConfigurationEnhancer springUpdateCheckerConfigEnhancer(final UsagePropertyProvider usagePropertyProvider) {
        return new ConfigurationEnhancer(){

            public void enhance(@Nonnull ComponentRegistry registry) {
                registry.registerIfNotPresent(ComponentDefinition.ofType(UpdateCheckerHttpClient.class).withBuilder(c -> new UpdateCheckerHttpClient(usagePropertyProvider))).registerIfNotPresent(ComponentDefinition.ofType(UpdateChecker.class).withBuilder(c -> new UpdateChecker((UpdateCheckerHttpClient)c.getComponent(UpdateCheckerHttpClient.class), (UpdateCheckerReporter)c.getComponent(UpdateCheckerReporter.class), usagePropertyProvider)).onStart(-134217728, UpdateChecker::start).onShutdown(-134217728, UpdateChecker::stop));
            }

            public int order() {
                return 0x7FFFFFF5;
            }
        };
    }

    static class NotTestEnvironmentCondition
    implements Condition {
        NotTestEnvironmentCondition() {
        }

        public boolean matches(ConditionContext context, AnnotatedTypeMetadata metadata) {
            return !TestEnvironmentDetector.isTestEnvironment();
        }
    }
}

