/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extension.springboot.actuator.axonserver;

import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.axonframework.axonserver.connector.AxonServerConnectionManager;
import org.axonframework.extension.springboot.actuator.HealthStatus;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

public class AxonServerHealthIndicator
extends AbstractHealthIndicator {
    private static final String CONNECTION = "%s.connection.active";
    private final AxonServerConnectionManager connectionManager;

    public AxonServerHealthIndicator(AxonServerConnectionManager connectionManager) {
        this.connectionManager = connectionManager;
    }

    protected void doHealthCheck(Health.Builder builder) {
        builder.up();
        AtomicBoolean anyConnectionUp = new AtomicBoolean(false);
        Map connections = this.connectionManager.connections();
        connections.forEach((context, connectionStatus) -> {
            String contextStatusCode;
            if (Boolean.FALSE.equals(connectionStatus)) {
                contextStatusCode = Status.DOWN.getCode();
                builder.status(HealthStatus.WARN);
            } else {
                contextStatusCode = Status.UP.getCode();
                anyConnectionUp.compareAndSet(false, true);
            }
            builder.withDetail(String.format(CONNECTION, context), (Object)contextStatusCode);
        });
        if (!connections.isEmpty() && !anyConnectionUp.get()) {
            builder.down();
        }
    }
}

