/*
 * Decompiled with CFR 0.152.
 */
package org.axonframework.extensions.mongo.eventsourcing.eventstore.documentperevent;

import com.mongodb.DBObject;
import java.time.Instant;
import java.time.temporal.TemporalAccessor;
import org.axonframework.common.DateTimeUtils;
import org.axonframework.eventhandling.DomainEventData;
import org.axonframework.eventhandling.DomainEventMessage;
import org.axonframework.extensions.mongo.eventsourcing.eventstore.documentperevent.EventEntryConfiguration;
import org.axonframework.serialization.SerializedMetaData;
import org.axonframework.serialization.SerializedObject;
import org.axonframework.serialization.Serializer;
import org.axonframework.serialization.SimpleSerializedObject;
import org.bson.Document;

public class EventEntry
implements DomainEventData<Object> {
    private final String aggregateIdentifier;
    private final String aggregateType;
    private final long sequenceNumber;
    private final String timestamp;
    private final Object serializedPayload;
    private final String payloadType;
    private final String payloadRevision;
    private final Object serializedMetaData;
    private final String eventIdentifier;

    public EventEntry(DomainEventMessage<?> event, Serializer serializer) {
        this.aggregateIdentifier = event.getAggregateIdentifier();
        this.aggregateType = event.getType();
        this.sequenceNumber = event.getSequenceNumber();
        this.eventIdentifier = event.getIdentifier();
        Class<String> serializationTarget = String.class;
        if (serializer.canSerializeTo(DBObject.class)) {
            serializationTarget = DBObject.class;
        }
        SerializedObject serializedPayloadObject = event.serializePayload(serializer, serializationTarget);
        SerializedObject serializedMetaDataObject = event.serializeMetaData(serializer, serializationTarget);
        this.serializedPayload = serializedPayloadObject.getData();
        this.payloadType = serializedPayloadObject.getType().getName();
        this.payloadRevision = serializedPayloadObject.getType().getRevision();
        this.serializedMetaData = serializedMetaDataObject.getData();
        this.timestamp = DateTimeUtils.formatInstant((TemporalAccessor)event.getTimestamp());
    }

    public EventEntry(Document dbObject, EventEntryConfiguration configuration) {
        String aggregateId = (String)dbObject.get((Object)configuration.aggregateIdentifierProperty());
        String eventId = (String)dbObject.get((Object)configuration.eventIdentifierProperty());
        this.aggregateIdentifier = eventId.equals(aggregateId) ? null : aggregateId;
        this.aggregateType = (String)dbObject.get((Object)configuration.typeProperty());
        this.sequenceNumber = ((Number)dbObject.get((Object)configuration.sequenceNumberProperty())).longValue();
        this.serializedPayload = dbObject.get((Object)configuration.payloadProperty());
        this.timestamp = (String)dbObject.get((Object)configuration.timestampProperty());
        this.payloadType = (String)dbObject.get((Object)configuration.payloadTypeProperty());
        this.payloadRevision = (String)dbObject.get((Object)configuration.payloadRevisionProperty());
        this.serializedMetaData = dbObject.get((Object)configuration.metaDataProperty());
        this.eventIdentifier = eventId;
    }

    public Document asDocument(EventEntryConfiguration configuration) {
        return new Document(configuration.aggregateIdentifierProperty(), (Object)this.aggregateIdentifier).append(configuration.typeProperty(), (Object)this.aggregateType).append(configuration.sequenceNumberProperty(), (Object)this.sequenceNumber).append(configuration.payloadProperty(), this.serializedPayload).append(configuration.timestampProperty(), (Object)this.timestamp).append(configuration.payloadTypeProperty(), (Object)this.payloadType).append(configuration.payloadRevisionProperty(), (Object)this.payloadRevision).append(configuration.metaDataProperty(), this.serializedMetaData).append(configuration.eventIdentifierProperty(), (Object)this.eventIdentifier);
    }

    public String getType() {
        return this.aggregateType;
    }

    public String getAggregateIdentifier() {
        return this.aggregateIdentifier;
    }

    public long getSequenceNumber() {
        return this.sequenceNumber;
    }

    public String getEventIdentifier() {
        return this.eventIdentifier;
    }

    public Instant getTimestamp() {
        return DateTimeUtils.parseInstant((CharSequence)this.timestamp);
    }

    public SerializedObject<Object> getMetaData() {
        return new SerializedMetaData(this.serializedMetaData, this.getRepresentationType());
    }

    public SerializedObject<Object> getPayload() {
        return new SimpleSerializedObject(this.serializedPayload, this.getRepresentationType(), this.payloadType, this.payloadRevision);
    }

    private Class<?> getRepresentationType() {
        Class<String> representationType = String.class;
        if (this.serializedPayload instanceof DBObject) {
            representationType = DBObject.class;
        } else if (this.serializedPayload instanceof Document) {
            representationType = Document.class;
        }
        return representationType;
    }
}

